/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;
import uk.co.real_logic.artio.engine.logger.ReplayIndexDescriptor;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.storage.messages.ReplayIndexRecordDecoder;

public final class ReplayIndexExtractor {
    public static void extract(EngineConfiguration configuration, long sessionId, boolean inbound, ReplayIndexHandler handler) {
        int streamId = inbound ? configuration.inboundLibraryStream() : configuration.outboundLibraryStream();
        File file = ReplayIndexDescriptor.replayIndexFile(configuration.logFileDir(), sessionId, streamId);
        ReplayIndexExtractor.extract(file, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(File file, ReplayIndexHandler handler) {
        MappedByteBuffer mappedByteBuffer = LoggerUtil.mapExistingFile(file);
        try {
            long iteratorPosition;
            UnsafeBuffer buffer = new UnsafeBuffer((ByteBuffer)mappedByteBuffer);
            MessageHeaderDecoder messageFrameHeader = new MessageHeaderDecoder();
            ReplayIndexRecordDecoder indexRecord = new ReplayIndexRecordDecoder();
            messageFrameHeader.wrap((DirectBuffer)buffer, 0);
            int actingBlockLength = messageFrameHeader.blockLength();
            int actingVersion = messageFrameHeader.version();
            int capacity = ReplayIndexDescriptor.recordCapacity(buffer.capacity());
            long stopIteratingPosition = iteratorPosition + (long)capacity;
            for (iteratorPosition = ReplayIndexDescriptor.beginChangeVolatile((AtomicBuffer)buffer); iteratorPosition < stopIteratingPosition; iteratorPosition += 32L) {
                long changePosition = ReplayIndexDescriptor.endChangeVolatile((AtomicBuffer)buffer);
                if (changePosition > iteratorPosition && iteratorPosition + (long)capacity <= ReplayIndexDescriptor.beginChangeVolatile((AtomicBuffer)buffer)) {
                    handler.onLapped();
                    iteratorPosition = changePosition;
                    stopIteratingPosition = iteratorPosition + (long)capacity;
                }
                int offset = ReplayIndexDescriptor.offset(iteratorPosition, capacity);
                indexRecord.wrap((DirectBuffer)buffer, offset, actingBlockLength, actingVersion);
                long beginPosition = indexRecord.position();
                if (beginPosition == 0L) {
                    break;
                }
                handler.onEntry(indexRecord);
            }
        }
        finally {
            IoUtil.unmap((MappedByteBuffer)mappedByteBuffer);
        }
    }

    public static class ReplayIndexValidator
    implements ReplayIndexHandler {
        private static final long MISSING = Long.MIN_VALUE;
        private final Long2LongHashMap sequenceIdToEndPosition = new Long2LongHashMap(Long.MIN_VALUE);
        private final List<ValidationError> errors = new ArrayList<ValidationError>();

        @Override
        public void onEntry(ReplayIndexRecordDecoder indexRecord) {
            int length;
            long position;
            long endPosition;
            int sequenceNumber;
            int sequenceIndex = indexRecord.sequenceIndex();
            long sequenceId = (long)sequenceIndex | (long)(sequenceNumber = indexRecord.sequenceNumber()) << 32;
            long oldEndPosition = this.sequenceIdToEndPosition.put(sequenceId, endPosition = (position = indexRecord.position()) + (long)(length = indexRecord.length()));
            if (oldEndPosition != Long.MIN_VALUE && oldEndPosition != position) {
                this.errors.add(new ValidationError(sequenceIndex, sequenceNumber, position, length, endPosition));
            }
        }

        public List<ValidationError> errors() {
            return this.errors;
        }

        @Override
        public void onLapped() {
            this.sequenceIdToEndPosition.clear();
        }
    }

    public static class ValidationError {
        private final int sequenceIndex;
        private final int sequenceNumber;
        private final long position;
        private final int length;
        private final long endPosition;

        public ValidationError(int sequenceIndex, int sequenceNumber, long position, int length, long endPosition) {
            this.sequenceIndex = sequenceIndex;
            this.sequenceNumber = sequenceNumber;
            this.position = position;
            this.length = length;
            this.endPosition = endPosition;
        }

        public int sequenceIndex() {
            return this.sequenceIndex;
        }

        public int sequenceNumber() {
            return this.sequenceNumber;
        }

        public long position() {
            return this.position;
        }

        public long endPosition() {
            return this.endPosition;
        }

        public String toString() {
            return "ValidationError{sequenceIndex=" + this.sequenceIndex + ", sequenceNumber=" + this.sequenceNumber + ", position=" + this.position + ", length=" + this.length + ", endPosition=" + this.endPosition + '}';
        }
    }

    public static interface ReplayIndexHandler {
        public void onEntry(ReplayIndexRecordDecoder var1);

        public void onLapped();
    }
}

