/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.IntHashSet;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.engine.ILink3RetransmitHandler;
import uk.co.real_logic.artio.engine.logger.ILink3MessageTracker;
import uk.co.real_logic.artio.engine.logger.MessageTracker;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;
import uk.co.real_logic.artio.engine.logger.Replayer;
import uk.co.real_logic.artio.engine.logger.ReplayerSession;
import uk.co.real_logic.artio.ilink.AbstractILink3Offsets;
import uk.co.real_logic.artio.ilink.AbstractILink3Parser;
import uk.co.real_logic.artio.ilink.AbstractILink3Proxy;
import uk.co.real_logic.artio.messages.ILinkMessageEncoder;

public class ILinkReplayerSession
extends ReplayerSession {
    private final IntHashSet gapfillOnRetransmitILinkTemplateIds;
    private final ILinkMessageEncoder iLinkMessageEncoder;
    private final AbstractILink3Parser iLink3Parser;
    private final AbstractILink3Proxy iLink3Proxy;
    private final AbstractILink3Offsets iLink3Offsets;
    private final ILink3RetransmitHandler iLink3RetransmitHandler;
    private final EpochNanoClock epochNanoClock;
    private boolean mustSendSequenceMessage = false;
    private State state;

    public ILinkReplayerSession(long connectionId, BufferClaim bufferClaim, IdleStrategy idleStrategy, int maxClaimAttempts, ExclusivePublication publication, ReplayQuery replayQuery, int beginSeqNo, int endSeqNo, long sessionId, Replayer replayer, IntHashSet gapfillOnRetransmitILinkTemplateIds, ILinkMessageEncoder iLinkMessageEncoder, AbstractILink3Parser iLink3Parser, AbstractILink3Proxy iLink3Proxy, AbstractILink3Offsets iLink3Offsets, ILink3RetransmitHandler iLink3RetransmitHandler, EpochNanoClock epochNanoClock) {
        super(connectionId, bufferClaim, idleStrategy, maxClaimAttempts, publication, replayQuery, beginSeqNo, endSeqNo, sessionId, 0, replayer);
        this.gapfillOnRetransmitILinkTemplateIds = gapfillOnRetransmitILinkTemplateIds;
        this.iLinkMessageEncoder = iLinkMessageEncoder;
        this.iLink3Parser = iLink3Parser;
        this.iLink3Proxy = iLink3Proxy;
        this.iLink3Offsets = iLink3Offsets;
        this.iLink3RetransmitHandler = iLink3RetransmitHandler;
        this.epochNanoClock = epochNanoClock;
        this.state = State.REPLAYING;
    }

    @Override
    MessageTracker messageTracker() {
        return new ILink3MessageTracker(this);
    }

    @Override
    public boolean attemptReplay() {
        switch (this.state) {
            case SEND_COMPLETE_MESSAGE: {
                if (this.mustSendSequenceMessage) {
                    if (this.sendSequence(this.endSeqNo + 1)) {
                        this.mustSendSequenceMessage = false;
                    } else {
                        return false;
                    }
                }
                return this.sendCompleteMessage();
            }
            case REPLAYING: {
                if (this.replayOperation.attemptReplay()) {
                    DebugLogger.log(LogTag.REPLAY_ATTEMPT, "ReplayerSession: REPLAYING step");
                    this.state = State.SEND_COMPLETE_MESSAGE;
                }
                return false;
            }
        }
        return false;
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        int seqNum;
        int encoderOffset = offset + 8;
        int headerOffset = encoderOffset + 4 + 16;
        int templateId = this.iLink3Parser.templateId(buffer, headerOffset);
        int blockLength = this.iLink3Parser.blockLength(buffer, headerOffset);
        int version = this.iLink3Parser.version(buffer, headerOffset);
        int messageOffset = headerOffset + 8;
        this.iLink3RetransmitHandler.onReplayedBusinessMessage(templateId, buffer, messageOffset, blockLength, version);
        if (this.gapfillOnRetransmitILinkTemplateIds.contains(templateId)) {
            this.mustSendSequenceMessage = true;
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        if (this.mustSendSequenceMessage && (seqNum = this.iLink3Offsets.seqNum(templateId, buffer, messageOffset)) != -1) {
            if (this.sendSequence(seqNum)) {
                this.mustSendSequenceMessage = false;
            } else {
                return ControlledFragmentHandler.Action.ABORT;
            }
        }
        this.iLinkMessageEncoder.wrap((MutableDirectBuffer)buffer, encoderOffset).connection(this.connectionId);
        return Pressure.apply(this.publication.offer(buffer, offset, length));
    }

    private boolean sendSequence(int nextSentSequenceNumber) {
        this.iLink3Proxy.connectionId(this.connectionId);
        return !Pressure.isBackPressured(this.iLink3Proxy.sendSequence(this.sessionId, (long)nextSentSequenceNumber));
    }

    @Override
    public void close() {
        if (this.replayOperation != null) {
            this.replayOperation.close();
        }
    }

    private static enum State {
        REPLAYING,
        SEND_COMPLETE_MESSAGE;

    }
}

