/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.engine.logger.FixReplayerCodecs;
import uk.co.real_logic.artio.fields.EpochFractionFormat;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.messages.ManageSessionDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;

public class FixSessionCodecsFactory
implements ControlledFragmentHandler {
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final ManageSessionDecoder manageSession = new ManageSessionDecoder();
    private final Map<String, FixReplayerCodecs> fixDictionaryClassToIndex = new HashMap<String, FixReplayerCodecs>();
    private final Long2ObjectHashMap<FixReplayerCodecs> sessionIdToFixDictionaryIndex = new Long2ObjectHashMap();
    private final Function<String, FixReplayerCodecs> makeFixReplayerCodecs = this::makeFixReplayerCodecs;
    final UtcTimestampEncoder timestampEncoder;

    public FixSessionCodecsFactory(EpochFractionFormat epochFractionFormat) {
        this.timestampEncoder = new UtcTimestampEncoder(epochFractionFormat);
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeader.wrap(buffer, offset);
        int blockLength = this.messageHeader.blockLength();
        int version = this.messageHeader.version();
        if (this.messageHeader.templateId() == 8) {
            this.manageSession.wrap(buffer, offset + 8, blockLength, version);
            this.manageSession.skipLocalCompId();
            this.manageSession.skipLocalSubId();
            this.manageSession.skipLocalLocationId();
            this.manageSession.skipRemoteCompId();
            this.manageSession.skipRemoteSubId();
            this.manageSession.skipRemoteLocationId();
            this.manageSession.skipAddress();
            this.manageSession.skipUsername();
            this.manageSession.skipPassword();
            this.onDictionary(this.manageSession.session(), this.manageSession.fixDictionary());
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void onDictionary(long sessionId, String fixDictionaryClassName) {
        FixReplayerCodecs fixReplayerCodecs = this.fixDictionaryClassToIndex.computeIfAbsent(fixDictionaryClassName, this.makeFixReplayerCodecs);
        FixReplayerCodecs previousIndex = (FixReplayerCodecs)this.sessionIdToFixDictionaryIndex.get(sessionId);
        if (previousIndex != fixReplayerCodecs) {
            this.sessionIdToFixDictionaryIndex.put(sessionId, (Object)fixReplayerCodecs);
        }
    }

    private FixReplayerCodecs makeFixReplayerCodecs(String fixDictionaryName) {
        return new FixReplayerCodecs(FixDictionary.find((String)fixDictionaryName), this.timestampEncoder);
    }

    FixReplayerCodecs get(long sessionId) {
        return (FixReplayerCodecs)this.sessionIdToFixDictionaryIndex.get(sessionId);
    }
}

