/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Aeron;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.Verify;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.engine.logger.FixMessageConsumer;
import uk.co.real_logic.artio.engine.logger.StreamTimestampZipper;
import uk.co.real_logic.artio.ilink.ILinkMessageConsumer;
import uk.co.real_logic.artio.messages.FixMessageDecoder;

public class FixMessageLogger
implements Agent {
    private final StreamTimestampZipper zipper;
    private final Aeron aeron;

    public static void main(String[] args) {
        Configuration configuration = new Configuration().fixMessageConsumer(FixMessageLogger::print);
        FixMessageLogger logger = new FixMessageLogger(configuration);
        AgentRunner runner = new AgentRunner(CommonConfiguration.backoffIdleStrategy(), Throwable::printStackTrace, null, (Agent)logger);
        AgentRunner.startOnThread((AgentRunner)runner);
    }

    private static void print(FixMessageDecoder fixMessageDecoder, DirectBuffer buffer, int offset, int length, Header header) {
        System.out.printf("%s: %s%n", fixMessageDecoder.status(), fixMessageDecoder.body());
    }

    @Deprecated
    public FixMessageLogger(FixMessageConsumer fixMessageConsumer, Aeron.Context context, String libraryAeronChannel, int inboundStreamId, int outboundStreamId, int outboundReplayStreamId) {
        this(new Configuration().fixMessageConsumer(fixMessageConsumer).context(context).libraryAeronChannel(libraryAeronChannel).inboundStreamId(inboundStreamId).outboundStreamId(outboundStreamId).outboundReplayStreamId(outboundReplayStreamId));
    }

    public FixMessageLogger(Configuration configuration) {
        configuration.conclude();
        this.aeron = Aeron.connect((Aeron.Context)configuration.context);
        this.zipper = new StreamTimestampZipper(this.aeron, configuration.libraryAeronChannel, configuration.fixMessageConsumer, configuration.iLinkMessageConsumer, configuration.compactionSize, configuration.inboundStreamId, configuration.outboundStreamId, configuration.outboundReplayStreamId);
    }

    public int doWork() {
        return this.zipper.poll();
    }

    public void onClose() {
        this.aeron.close();
    }

    public String roleName() {
        return "FixMessageLogger";
    }

    int bufferPosition() {
        return this.zipper.bufferPosition();
    }

    int bufferCapacity() {
        return this.zipper.bufferCapacity();
    }

    public static class Configuration {
        private static final int DEFAULT_COMPACTION_SIZE = 65536;
        private FixMessageConsumer fixMessageConsumer;
        private Aeron.Context context;
        private String libraryAeronChannel = "aeron:ipc";
        private int inboundStreamId = 1;
        private int outboundStreamId = 2;
        private int outboundReplayStreamId = 3;
        private int compactionSize = 65536;
        private ILinkMessageConsumer iLinkMessageConsumer;

        public Configuration fixMessageConsumer(FixMessageConsumer fixMessageConsumer) {
            this.fixMessageConsumer = fixMessageConsumer;
            return this;
        }

        public Configuration iLinkMessageConsumer(ILinkMessageConsumer iLinkMessageConsumer) {
            this.iLinkMessageConsumer = iLinkMessageConsumer;
            return this;
        }

        public Configuration context(Aeron.Context context) {
            this.context = context;
            return this;
        }

        public Configuration libraryAeronChannel(String libraryAeronChannel) {
            this.libraryAeronChannel = libraryAeronChannel;
            return this;
        }

        public Configuration inboundStreamId(int inboundStreamId) {
            this.inboundStreamId = inboundStreamId;
            return this;
        }

        public Configuration outboundStreamId(int outboundStreamId) {
            this.outboundStreamId = outboundStreamId;
            return this;
        }

        public Configuration outboundReplayStreamId(int outboundReplayStreamId) {
            this.outboundReplayStreamId = outboundReplayStreamId;
            return this;
        }

        public Configuration compactionSize(int compactionSize) {
            this.compactionSize = compactionSize;
            return this;
        }

        void conclude() {
            Verify.notNull((Object)this.fixMessageConsumer, (String)"fixMessageConsumer");
            if (this.compactionSize <= 0) {
                throw new IllegalArgumentException("Compaction size must be positive, but is: " + this.compactionSize);
            }
            if (this.context == null) {
                this.context = new Aeron.Context();
            }
        }
    }
}

