/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.session;

import io.aeron.logbuffer.ControlledFragmentHandler;
import java.util.concurrent.TimeUnit;
import org.agrona.DirectBuffer;
import org.agrona.Verify;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.dictionary.SessionConstants;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.fields.RejectReason;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.library.OnMessageInfo;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.messages.ReplayMessagesStatus;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.SessionCustomisationStrategy;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.session.SessionProcessHandler;
import uk.co.real_logic.artio.session.SessionProxy;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.EpochFractionClock;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class Session {
    public static final int UNKNOWN = -1;
    public static final long UNKNOWN_TIME = -1L;
    static final short ACTIVE_VALUE = 3;
    static final short LOGGING_OUT_VALUE = 5;
    static final short LOGGING_OUT_AND_DISCONNECTING_VALUE = 6;
    static final short AWAITING_LOGOUT_VALUE = 7;
    static final short DISCONNECTING_VALUE = 8;
    static final short DISCONNECTED_VALUE = 9;
    static final short DISABLED_VALUE = 10;
    private static final long NO_OPERATION = Integer.MIN_VALUE;
    static final long LIBRARY_DISCONNECTED = -2147483647L;
    private static final int INITIAL_SEQUENCE_NUMBER = 1;
    private static final double HEARTBEAT_PAUSE_FACTOR = 0.8;
    static final String TEST_REQ_ID = "TEST";
    private static final char[] TEST_REQ_ID_CHARS = "TEST".toCharArray();
    private static final int NO_LOGOUT_REJECT_REASON = -1;
    private final UtcTimestampEncoder timestampEncoder;
    protected final SessionIdStrategy sessionIdStrategy;
    protected final GatewayPublication outboundPublication;
    protected final MutableAsciiBuffer asciiBuffer;
    protected final int libraryId;
    protected final SessionProxy proxy;
    private final EpochClock epochClock;
    private final EpochFractionClock epochFractionClock;
    private final EpochNanoClock clock;
    private final long sendingTimeWindowInMs;
    private final long reasonableTransmissionTimeInMs;
    private final GatewayPublication inboundPublication;
    private final SessionCustomisationStrategy customisationStrategy;
    private final OnMessageInfo messageInfo;
    private CompositeKey sessionKey;
    private SessionState state;
    private String beginString;
    private AtomicCounter receivedMsgSeqNo;
    private AtomicCounter sentMsgSeqNo;
    private boolean awaitingResend = false;
    private int lastResentMsgSeqNo = 0;
    private int lastResendChunkMsgSeqNum = 0;
    private int endOfResendRequestRange = 0;
    private boolean awaitingHeartbeat = false;
    private boolean enableLastMsgSeqNumProcessed;
    protected long connectionId;
    private long id = -1L;
    private int lastReceivedMsgSeqNum;
    private int lastMsgSeqNumProcessed;
    private int lastSentMsgSeqNum;
    private int sequenceIndex;
    private long heartbeatIntervalInMs;
    private long nextRequiredInboundMessageTimeInMs;
    private long sendingHeartbeatIntervalInMs;
    private long nextRequiredHeartbeatTimeInMs;
    private long awaitingLogoutTimeoutInMs;
    private String username;
    private String password;
    private String connectedHost;
    private int connectedPort;
    private long lastLogonTime = -1L;
    private long lastSequenceResetTime = -1L;
    private boolean closedResendInterval;
    private int resendRequestChunkSize;
    private boolean sendRedundantResendRequests;
    private boolean incorrectBeginString = false;
    private SessionProcessHandler sessionProcessHandler;
    private int logoutRejectReason = -1;
    private FixDictionary fixDictionary;

    public Session(int heartbeatIntervalInS, long connectionId, EpochClock epochClock, EpochNanoClock clock, SessionState state, SessionProxy proxy, GatewayPublication inboundPublication, GatewayPublication outboundPublication, SessionIdStrategy sessionIdStrategy, long sendingTimeWindowInMs, AtomicCounter receivedMsgSeqNo, AtomicCounter sentMsgSeqNo, int libraryId, int initialSentSequenceNumber, int sequenceIndex, long reasonableTransmissionTimeInMs, MutableAsciiBuffer asciiBuffer, boolean enableLastMsgSeqNumProcessed, SessionCustomisationStrategy customisationStrategy, OnMessageInfo messageInfo, EpochFractionClock epochFractionClock) {
        Verify.notNull((Object)epochClock, (String)"clock");
        Verify.notNull((Object)state, (String)"session state");
        Verify.notNull((Object)proxy, (String)"session proxy");
        Verify.notNull((Object)outboundPublication, (String)"outboundPublication");
        Verify.notNull((Object)receivedMsgSeqNo, (String)"received MsgSeqNo counter");
        Verify.notNull((Object)sentMsgSeqNo, (String)"sent MsgSeqNo counter");
        Verify.notNull((Object)messageInfo, (String)"messageInfo");
        Verify.notNull((Object)epochFractionClock, (String)"epochFractionClock");
        this.messageInfo = messageInfo;
        this.epochClock = epochClock;
        this.proxy = proxy;
        this.connectionId = connectionId;
        this.outboundPublication = outboundPublication;
        this.sessionIdStrategy = sessionIdStrategy;
        this.sendingTimeWindowInMs = sendingTimeWindowInMs;
        this.receivedMsgSeqNo = receivedMsgSeqNo;
        this.sentMsgSeqNo = sentMsgSeqNo;
        this.libraryId = libraryId;
        this.sequenceIndex(sequenceIndex);
        this.lastSentMsgSeqNum = initialSentSequenceNumber - 1;
        this.reasonableTransmissionTimeInMs = reasonableTransmissionTimeInMs;
        this.enableLastMsgSeqNumProcessed = enableLastMsgSeqNumProcessed;
        this.asciiBuffer = asciiBuffer;
        this.clock = clock;
        this.inboundPublication = inboundPublication;
        this.customisationStrategy = customisationStrategy;
        this.state(state);
        this.heartbeatIntervalInS(heartbeatIntervalInS);
        this.lastMsgSeqNumProcessed = this.enableLastMsgSeqNumProcessed ? 0 : -1;
        this.timestampEncoder = new UtcTimestampEncoder(epochFractionClock.epochFractionPrecision());
        this.epochFractionClock = epochFractionClock;
    }

    public boolean isConnected() {
        SessionState state = this.state();
        return state != SessionState.CONNECTING && state != SessionState.DISCONNECTED && state != SessionState.DISABLED;
    }

    public SessionState state() {
        return this.state;
    }

    public boolean awaitingResend() {
        return this.awaitingResend;
    }

    public boolean awaitingHeartbeat() {
        return this.awaitingHeartbeat;
    }

    public boolean closedResendInterval() {
        return this.closedResendInterval;
    }

    public int resendRequestChunkSize() {
        return this.resendRequestChunkSize;
    }

    public boolean sendRedundantResendRequests() {
        return this.sendRedundantResendRequests;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public int lastSentMsgSeqNum() {
        return this.lastSentMsgSeqNum;
    }

    public int lastReceivedMsgSeqNum() {
        return this.lastReceivedMsgSeqNum;
    }

    public long heartbeatIntervalInMs() {
        return this.heartbeatIntervalInMs;
    }

    public String connectedHost() {
        return this.connectedHost;
    }

    public long connectionId() {
        return this.connectionId;
    }

    public long id() {
        return this.id;
    }

    public CompositeKey compositeKey() {
        return this.sessionKey;
    }

    public int connectedPort() {
        return this.connectedPort;
    }

    public long startLogout() {
        long position = this.trySendLogout();
        if (position < 0L) {
            this.state(SessionState.LOGGING_OUT);
        } else {
            this.awaitingLogoutTimeoutInMs = this.time() + this.heartbeatIntervalInMs;
            this.state(SessionState.AWAITING_LOGOUT);
        }
        return position;
    }

    public long requestDisconnect() {
        return this.requestDisconnect(DisconnectReason.APPLICATION_DISCONNECT);
    }

    private long requestDisconnect(DisconnectReason reason) {
        long position = Integer.MIN_VALUE;
        if (this.state() != SessionState.DISCONNECTED) {
            position = this.proxy.sendRequestDisconnect(this.connectionId, reason);
            this.state(position < 0L ? SessionState.DISCONNECTING : SessionState.DISCONNECTED);
        }
        return position;
    }

    public long logoutAndDisconnect() {
        return this.logoutAndDisconnect(DisconnectReason.APPLICATION_DISCONNECT);
    }

    private long logoutAndDisconnect(DisconnectReason reason) {
        long position = Integer.MIN_VALUE;
        if (this.state() != SessionState.DISCONNECTED) {
            position = this.trySendLogout();
            if (position < 0L) {
                this.state(SessionState.LOGGING_OUT_AND_DISCONNECTING);
            } else {
                position = this.requestDisconnect(reason);
            }
        }
        return position;
    }

    public int prepare(SessionHeaderEncoder header) {
        int sentSeqNum = this.newSentSeqNum();
        header.msgSeqNum(sentSeqNum).sendingTime(this.timestampEncoder.buffer(), this.timestampEncoder.encode(this.epochFractionClock.epochFractionTime()));
        if (this.enableLastMsgSeqNumProcessed) {
            header.lastMsgSeqNumProcessed(this.lastMsgSeqNumProcessed);
        }
        if (!header.hasSenderCompID()) {
            this.sessionIdStrategy.setupSession(this.sessionKey, header);
        }
        this.customisationStrategy.configureHeader(header, this.id);
        return sentSeqNum;
    }

    public long trySend(Encoder encoder) {
        return this.trySend(encoder, null, 0);
    }

    @Deprecated
    public long send(Encoder encoder) {
        return this.trySend(encoder);
    }

    public long trySend(Encoder encoder, DirectBuffer metaDataBuffer, int metaDataUpdateOffset) {
        this.validateCanSendMessage();
        int sentSeqNum = this.prepare(encoder.header());
        long result = encoder.encode(this.asciiBuffer, 0);
        int length = Encoder.length((long)result);
        int offset = Encoder.offset((long)result);
        long type = encoder.messageType();
        return this.trySend((DirectBuffer)this.asciiBuffer, offset, length, sentSeqNum, type, metaDataBuffer, metaDataUpdateOffset);
    }

    @Deprecated
    public long send(Encoder encoder, DirectBuffer metaDataBuffer, int metaDataUpdateOffset) {
        return this.trySend(encoder, metaDataBuffer, metaDataUpdateOffset);
    }

    public long trySend(DirectBuffer messageBuffer, int offset, int length, int seqNum, long messageType) {
        return this.trySend(messageBuffer, offset, length, seqNum, messageType, null, 0);
    }

    @Deprecated
    public long send(DirectBuffer messageBuffer, int offset, int length, int seqNum, long messageType) {
        return this.trySend(messageBuffer, offset, length, seqNum, messageType);
    }

    public long trySend(DirectBuffer messageBuffer, int offset, int length, int seqNum, long messageType, DirectBuffer metaDataBuffer, int metaDataUpdateOffset) {
        this.validateCanSendMessage();
        long position = this.outboundPublication.saveMessage(messageBuffer, offset, length, this.libraryId, messageType, this.id(), this.sequenceIndex(), this.connectionId, MessageStatus.OK, seqNum, metaDataBuffer, metaDataUpdateOffset);
        if (position > 0L) {
            this.lastSentMsgSeqNum(seqNum, position);
            DebugLogger.log(LogTag.FIX_MESSAGE, "Sent ", messageBuffer, offset, length);
        }
        return position;
    }

    @Deprecated
    public long send(DirectBuffer messageBuffer, int offset, int length, int seqNum, long messageType, DirectBuffer metaDataBuffer, int metaDataUpdateOffset) {
        return this.trySend(messageBuffer, offset, length, seqNum, messageType, metaDataBuffer, metaDataUpdateOffset);
    }

    public boolean canSendMessage() {
        SessionState state = this.state;
        return state == SessionState.ACTIVE || state == SessionState.DISCONNECTED;
    }

    public long trySendSequenceReset(int nextSentMessageSequenceNumber) {
        int newSequenceIndex = this.sequenceIndex() + 1;
        long position = this.proxy.sendSequenceReset(this.lastSentMsgSeqNum, nextSentMessageSequenceNumber, newSequenceIndex, this.lastMsgSeqNumProcessed);
        this.nextSequenceIndex(this.clock.nanoTime(), position);
        this.lastSentMsgSeqNum(nextSentMessageSequenceNumber - 1, position);
        return position;
    }

    @Deprecated
    public long sendSequenceReset(int nextSentMessageSequenceNumber) {
        return this.trySendSequenceReset(nextSentMessageSequenceNumber);
    }

    public long trySendSequenceReset(int nextSentMessageSequenceNumber, int nextReceivedMessageSequenceNumber) {
        long position = this.trySendSequenceReset(nextSentMessageSequenceNumber);
        this.lastReceivedMsgSeqNumOnly(nextReceivedMessageSequenceNumber - 1);
        if (this.redact(-1000L)) {
            this.sessionProcessHandler.enqueueTask(() -> this.redact(-1000L));
        }
        return position;
    }

    @Deprecated
    public long sendSequenceReset(int nextSentMessageSequenceNumber, int nextReceivedMessageSequenceNumber) {
        return this.trySendSequenceReset(nextSentMessageSequenceNumber, nextReceivedMessageSequenceNumber);
    }

    private void nextSequenceIndex(long messageTimeInNs, long position) {
        if (position >= 0L) {
            ++this.sequenceIndex;
            this.lastSequenceResetTime(messageTimeInNs);
        }
    }

    public long tryResetSequenceNumbers() {
        boolean sentSeqNum = true;
        int heartbeatIntervalInS = (int)TimeUnit.MILLISECONDS.toSeconds(this.heartbeatIntervalInMs);
        long position = this.proxy.sendLogon(1, heartbeatIntervalInS, this.username(), this.password(), true, this.sequenceIndex() + 1, this.lastMsgSeqNumProcessed);
        this.nextSequenceIndex(this.clock.nanoTime(), position);
        this.lastSentMsgSeqNum(1, position);
        return position;
    }

    @Deprecated
    public long resetSequenceNumbers() {
        return this.tryResetSequenceNumbers();
    }

    public boolean isActive() {
        return this.state == SessionState.ACTIVE;
    }

    public boolean isAcceptor() {
        return false;
    }

    public int sequenceIndex() {
        return this.sequenceIndex;
    }

    public void onDisconnect() {
        this.logoutRejectReason = -1;
        this.state(SessionState.DISCONNECTED);
        this.address("", -1);
        this.connectionId(-1L);
    }

    public Session lastReceivedMsgSeqNum(int lastReceivedMsgSeqNum) {
        if (this.lastReceivedMsgSeqNum > lastReceivedMsgSeqNum) {
            this.nextSequenceIndex(this.clock.nanoTime());
        }
        this.lastReceivedMsgSeqNumOnly(lastReceivedMsgSeqNum);
        return this;
    }

    private void nextSequenceIndex(long messageTimeInNs) {
        ++this.sequenceIndex;
        this.lastSequenceResetTime(messageTimeInNs);
    }

    public long lastLogonTime() {
        return this.lastLogonTime;
    }

    public long lastSequenceResetTime() {
        return this.lastSequenceResetTime;
    }

    public int lastSentMsgSeqNum(int lastSentMsgSeqNum) {
        this.lastSentMsgSeqNum = lastSentMsgSeqNum;
        this.sentMsgSeqNo.setOrdered((long)lastSentMsgSeqNum);
        this.incNextHeartbeatTime();
        return lastSentMsgSeqNum;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{connectionId=" + this.connectionId + ", sessionId=" + this.id + ", state=" + this.state + ", sequenceIndex=" + this.sequenceIndex + ", lastReceivedMsgSeqNum=" + this.lastReceivedMsgSeqNum + ", lastSentMsgSeqNum=" + this.lastSentMsgSeqNum + '}';
    }

    public String beginString() {
        return this.beginString;
    }

    public FixDictionary fixDictionary() {
        return this.fixDictionary;
    }

    public Reply<ReplayMessagesStatus> replayReceivedMessages(int replayFromSequenceNumber, int replayFromSequenceIndex, int replayToSequenceNumber, int replayToSequenceIndex, long timeout) {
        return this.sessionProcessHandler.replayReceivedMessages(this.id, replayFromSequenceNumber, replayFromSequenceIndex, replayToSequenceNumber, replayToSequenceIndex, timeout);
    }

    ControlledFragmentHandler.Action onInvalidFixDisconnect() {
        return Pressure.apply(this.requestDisconnect(DisconnectReason.INVALID_FIX_MESSAGE));
    }

    private void lastSentMsgSeqNum(int sentSeqNum, long position) {
        if (position >= 0L) {
            this.lastSentMsgSeqNum(sentSeqNum);
        }
    }

    private void validateCanSendMessage() {
        if (!this.canSendMessage()) {
            throw new IllegalStateException(String.format("Session isn't active it's %s, and thus can't send a message", this.state));
        }
    }

    ControlledFragmentHandler.Action onMessage(int msgSeqNo, char[] msgType, long sendingTime, long origSendingTime, boolean isPossDupOrResend, boolean possDup, long position) {
        return this.onMessage(msgSeqNo, msgType, msgType.length, sendingTime, origSendingTime, isPossDupOrResend, possDup, position);
    }

    ControlledFragmentHandler.Action onMessage(int msgSeqNo, char[] msgType, int msgTypeLength, long sendingTime, long origSendingTime, boolean isPossDupOrResend, boolean possDup, long position) {
        if (this.state() == SessionState.CONNECTED) {
            return Pressure.apply(this.requestDisconnect(DisconnectReason.FIRST_MESSAGE_NOT_LOGON));
        }
        long time = this.time();
        ControlledFragmentHandler.Action action = this.validateRequiredFieldsAndCodec(msgSeqNo, time, msgType, msgTypeLength, sendingTime, origSendingTime, possDup, position);
        if (action != null) {
            return action;
        }
        return this.checkSeqNoChange(msgSeqNo, time, isPossDupOrResend, position);
    }

    private ControlledFragmentHandler.Action validateRequiredFieldsAndCodec(int msgSeqNo, long time, char[] msgType, int msgTypeLength, long sendingTime, long origSendingTime, boolean possDup, long position) {
        ControlledFragmentHandler.Action validationResult;
        if (msgSeqNo == Integer.MIN_VALUE) {
            int sentSeqNum = this.newSentSeqNum();
            return this.checkPositionAndDisconnect(this.proxy.sendReceivedMessageWithoutSequenceNumber(sentSeqNum, this.sequenceIndex(), this.lastMsgSeqNumProcessed), DisconnectReason.MSG_SEQ_NO_MISSING);
        }
        if (Validation.CODEC_VALIDATION_ENABLED && (validationResult = this.validateCodec(time, msgSeqNo, msgType, msgTypeLength, sendingTime, origSendingTime, possDup, position)) != null) {
            return validationResult;
        }
        return null;
    }

    private ControlledFragmentHandler.Action validateCodec(long time, int msgSeqNum, char[] msgType, int msgTypeLength, long sendingTime, long origSendingTime, boolean possDup, long position) {
        if (possDup) {
            if (origSendingTime == -1L) {
                return this.onInvalidMessage(msgSeqNum, 122, msgType, msgTypeLength, RejectReason.REQUIRED_TAG_MISSING.representation(), position);
            }
            if (origSendingTime > sendingTime) {
                return this.rejectDueToSendingTime(msgSeqNum, msgType, msgTypeLength, position);
            }
        }
        if (sendingTime < time - this.sendingTimeWindowInMs || sendingTime > time + this.sendingTimeWindowInMs) {
            ControlledFragmentHandler.Action action = this.rejectDueToSendingTime(msgSeqNum, msgType, msgTypeLength, position);
            if (action != ControlledFragmentHandler.Action.ABORT) {
                this.logoutRejectReason(RejectReason.SENDINGTIME_ACCURACY_PROBLEM.representation());
                this.logoutAndDisconnect(DisconnectReason.INVALID_SENDING_TIME);
            }
            return action;
        }
        return null;
    }

    private ControlledFragmentHandler.Action checkSeqNoChange(int msgSeqNum, long time, boolean isPossDupOrResend, long position) {
        if (this.awaitingResend) {
            this.incNextReceivedInboundMessageTime(time);
            if (msgSeqNum == this.endOfResendMsgSeqNum()) {
                this.awaitingResend = false;
                this.lastResendChunkMsgSeqNum = 0;
                this.lastResentMsgSeqNo = 0;
                this.endOfResendRequestRange = 0;
            } else {
                if (msgSeqNum == this.lastResendChunkMsgSeqNum) {
                    ControlledFragmentHandler.Action action = this.checkPosition(this.trySendResendRequest(msgSeqNum + 1, this.endOfResendMsgSeqNum()));
                    if (action == ControlledFragmentHandler.Action.CONTINUE) {
                        this.lastResentMsgSeqNo = msgSeqNum;
                    }
                    return action;
                }
                if (msgSeqNum > this.endOfResendRequestRange) {
                    if (this.sendRedundantResendRequests) {
                        return Pressure.apply(this.trySendResendRequest(this.lastResendChunkMsgSeqNum, msgSeqNum));
                    }
                    return this.checkNormalSeqNoChange(msgSeqNum, time, isPossDupOrResend, position);
                }
                this.lastResentMsgSeqNo = msgSeqNum;
            }
        } else {
            return this.checkNormalSeqNoChange(msgSeqNum, time, isPossDupOrResend, position);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action checkNormalSeqNoChange(int msgSeqNum, long time, boolean isPossDupOrResend, long position) {
        int expectedSeqNo = this.expectedReceivedSeqNum();
        if (expectedSeqNo == msgSeqNum) {
            this.incNextReceivedInboundMessageTime(time);
            this.lastReceivedMsgSeqNum(msgSeqNum);
        } else {
            if (expectedSeqNo < msgSeqNum) {
                return this.requestResend(expectedSeqNo, msgSeqNum);
            }
            if (!isPossDupOrResend) {
                return this.msgSeqNumTooLow(msgSeqNum, expectedSeqNo, position);
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private int endOfResendMsgSeqNum() {
        return this.endOfResendRequestRange;
    }

    private ControlledFragmentHandler.Action requestResend(int expectedSeqNo, int receivedMsgSeqNo) {
        long position = this.trySendResendRequest(expectedSeqNo, receivedMsgSeqNo - 1);
        if (position >= 0L) {
            this.awaitingResend = true;
            this.lastResentMsgSeqNo = expectedSeqNo - 1;
            this.lastReceivedMsgSeqNum = receivedMsgSeqNo;
            this.endOfResendRequestRange = receivedMsgSeqNo - 1;
        }
        return this.checkPosition(position);
    }

    private long trySendResendRequest(int expectedSeqNo, int receivedMsgSeqNo) {
        int cappedEndSeqNo;
        boolean chunkedResend = this.resendRequestChunkSize != 0;
        int n = cappedEndSeqNo = chunkedResend ? expectedSeqNo + this.resendRequestChunkSize - 1 : receivedMsgSeqNo;
        int endSeqNo = cappedEndSeqNo < receivedMsgSeqNo ? cappedEndSeqNo : (this.closedResendInterval ? receivedMsgSeqNo : 0);
        long position = this.proxy.sendResendRequest(this.newSentSeqNum(), expectedSeqNo, endSeqNo, this.sequenceIndex(), this.lastMsgSeqNumProcessed);
        if (position > 0L && chunkedResend) {
            this.lastResendChunkMsgSeqNum = cappedEndSeqNo;
        }
        return position;
    }

    private ControlledFragmentHandler.Action msgSeqNumTooLow(int msgSeqNo, int expectedSeqNo, long position) {
        if (this.redact(position)) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        return this.checkPositionAndDisconnect(this.proxy.sendLowSequenceNumberLogout(this.newSentSeqNum(), expectedSeqNo, msgSeqNo, this.sequenceIndex(), this.lastMsgSeqNumProcessed), DisconnectReason.MSG_SEQ_NO_TOO_LOW);
    }

    private boolean redact(long position) {
        this.messageInfo.isValid(false);
        return this.inboundPublication.saveRedactSequenceUpdate(this.id, this.lastReceivedMsgSeqNum, position) < 0L;
    }

    private ControlledFragmentHandler.Action checkPosition(long position) {
        if (position < 0L) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        this.lastSentMsgSeqNum(this.newSentSeqNum());
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action rejectDueToSendingTime(int msgSeqNo, char[] msgType, int msgTypeLength, long position) {
        return this.onInvalidMessage(msgSeqNo, 52, msgType, msgTypeLength, RejectReason.SENDINGTIME_ACCURACY_PROBLEM.representation(), position);
    }

    private void incNextReceivedInboundMessageTime(long time) {
        this.nextRequiredInboundMessageTimeInMs = time + this.heartbeatIntervalInMs() + this.reasonableTransmissionTimeInMs;
    }

    ControlledFragmentHandler.Action onLogon(int heartbeatInterval, int msgSeqNum, long sendingTime, long origSendingTime, String username, String password, boolean isPossDupOrResend, boolean resetSeqNumFlag, boolean possDup, long position) {
        ControlledFragmentHandler.Action action = this.validateOrRejectHeartbeat(heartbeatInterval);
        if (action != null) {
            return action;
        }
        action = this.validateOrRejectSendingTime(sendingTime, position);
        if (action != null) {
            return action;
        }
        long logonTime = this.clock.nanoTime();
        if (resetSeqNumFlag) {
            return this.onResetSeqNumLogon(heartbeatInterval, username, password, logonTime, msgSeqNum);
        }
        if (this.state() == this.initialState()) {
            int expectedMsgSeqNo = this.expectedReceivedSeqNum();
            if (expectedMsgSeqNo == msgSeqNum) {
                action = this.respondToLogon(heartbeatInterval);
                if (action == ControlledFragmentHandler.Action.ABORT) {
                    return ControlledFragmentHandler.Action.ABORT;
                }
                this.setupCompleteLogonState(logonTime, heartbeatInterval, username, password, this.time());
                if (this.lastReceivedMsgSeqNum == 0) {
                    this.lastSequenceResetTime(logonTime);
                }
                this.lastReceivedMsgSeqNum(msgSeqNum);
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            if (expectedMsgSeqNo < msgSeqNum) {
                action = this.respondToLogon(heartbeatInterval);
                if (action == ControlledFragmentHandler.Action.ABORT) {
                    return ControlledFragmentHandler.Action.ABORT;
                }
                boolean requestSeqNumReset = this.proxy.seqNumResetRequested();
                if (requestSeqNumReset) {
                    this.lastReceivedMsgSeqNum = 0;
                    this.setupCompleteLogonStateReset(logonTime, heartbeatInterval, username, password, this.time());
                    return ControlledFragmentHandler.Action.CONTINUE;
                }
                this.setupCompleteLogonState(logonTime, heartbeatInterval, username, password, this.time());
                action = this.requestResend(expectedMsgSeqNo, msgSeqNum);
                return action;
            }
            return this.msgSeqNumTooLow(msgSeqNum, expectedMsgSeqNo, position);
        }
        return this.onMessage(msgSeqNum, SessionConstants.LOGON_MESSAGE_TYPE_CHARS, sendingTime, origSendingTime, isPossDupOrResend, possDup, position);
    }

    protected ControlledFragmentHandler.Action respondToLogon(int heartbeatInterval) {
        return this.replyToLogon(heartbeatInterval);
    }

    protected SessionState initialState() {
        return SessionState.CONNECTED;
    }

    private ControlledFragmentHandler.Action onResetSeqNumLogon(int heartbeatInterval, String username, String password, long logonTime, int msgSeqNo) {
        if (this.lastSentMsgSeqNum() != 1) {
            int logonSequenceIndex = this.isInitialRequest() ? this.sequenceIndex() : this.sequenceIndex() + 1;
            long position = this.proxy.sendLogon(1, heartbeatInterval, null, null, true, logonSequenceIndex, this.lastMsgSeqNumProcessed);
            if (position < 0L) {
                return ControlledFragmentHandler.Action.ABORT;
            }
            this.lastSentMsgSeqNum(1);
            this.lastReceivedMsgSeqNum(msgSeqNo);
            this.lastLogonTime(logonTime);
            this.lastSequenceResetTime(logonTime);
        } else {
            this.lastReceivedMsgSeqNumOnly(msgSeqNo);
        }
        this.setupCompleteLogonStateReset(logonTime, heartbeatInterval, username, password, this.time());
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void setupCompleteLogonStateReset(long logonTime, int heartbeatInterval, String username, String password, long currentTime) {
        this.setupCompleteLogonState(logonTime, heartbeatInterval, username, password, currentTime);
        this.lastSequenceResetTime(logonTime);
    }

    private void setupCompleteLogonState(long logonTime, int heartbeatInterval, String username, String password, long currentTime) {
        this.lastLogonTime(logonTime);
        this.setupLogonState(heartbeatInterval, username, password, currentTime);
    }

    private void setupLogonState(int heartbeatInterval, String username, String password, long currentTime) {
        this.incNextReceivedInboundMessageTime(currentTime);
        this.heartbeatIntervalInS(heartbeatInterval);
        this.state(SessionState.ACTIVE);
        this.username(username);
        this.password(password);
        if (this.sessionProcessHandler != null) {
            this.sessionProcessHandler.onLogon(this);
        }
    }

    void setupSession(long sessionId, CompositeKey sessionKey) {
        this.id(sessionId);
        this.sessionKey = sessionKey;
        this.proxy.setupSession(sessionId, sessionKey);
    }

    private ControlledFragmentHandler.Action replyToLogon(int heartbeatInterval) {
        return this.checkPosition(this.proxy.sendLogon(this.newSentSeqNum(), heartbeatInterval, null, null, false, this.sequenceIndex(), this.lastMsgSeqNumProcessed));
    }

    private ControlledFragmentHandler.Action validateOrRejectSendingTime(long sendingTime, long position) {
        if (Validation.CODEC_VALIDATION_DISABLED && sendingTime == Long.MIN_VALUE) {
            return null;
        }
        long time = this.time();
        if (sendingTime < time + this.sendingTimeWindowInMs && sendingTime > time - this.sendingTimeWindowInMs) {
            return null;
        }
        return this.checkPositionAndDisconnect(this.proxy.sendRejectWhilstNotLoggedOn(this.newSentSeqNum(), RejectReason.SENDINGTIME_ACCURACY_PROBLEM, this.sequenceIndex(), this.lastMsgSeqNumProcessed), DisconnectReason.INVALID_SENDING_TIME);
    }

    private ControlledFragmentHandler.Action validateOrRejectHeartbeat(int heartbeatInterval) {
        if (heartbeatInterval < 0) {
            this.messageInfo.isValid(false);
            return this.checkPositionAndDisconnect(this.proxy.sendNegativeHeartbeatLogout(this.newSentSeqNum(), this.sequenceIndex(), this.lastMsgSeqNumProcessed), DisconnectReason.NEGATIVE_HEARTBEAT_INTERVAL);
        }
        return null;
    }

    private ControlledFragmentHandler.Action checkPositionAndDisconnect(long position, DisconnectReason reason) {
        ControlledFragmentHandler.Action action = this.checkPosition(position);
        if (action != ControlledFragmentHandler.Action.ABORT) {
            this.requestDisconnect(reason);
        }
        return action;
    }

    private boolean isInitialRequest() {
        return 0 == this.lastReceivedMsgSeqNum();
    }

    ControlledFragmentHandler.Action onLogout(int msgSeqNo, long sendingTime, long origSendingTime, boolean possDup, long position) {
        long time = this.time();
        ControlledFragmentHandler.Action action = this.validateRequiredFieldsAndCodec(msgSeqNo, time, SessionConstants.LOGON_MESSAGE_TYPE_CHARS, SessionConstants.LOGON_MESSAGE_TYPE_CHARS.length, sendingTime, origSendingTime, possDup, position);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        this.lastReceivedMsgSeqNum(msgSeqNo);
        if (this.state() == SessionState.AWAITING_LOGOUT) {
            this.requestDisconnect(DisconnectReason.LOGOUT);
        } else {
            this.logoutAndDisconnect(DisconnectReason.LOGOUT);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    ControlledFragmentHandler.Action onTestRequest(int msgSeqNo, char[] testReqId, int testReqIdLength, long sendingTime, long origSendingTime, boolean isPossDupOrResend, boolean possDup, long position) {
        if (msgSeqNo == this.expectedReceivedSeqNum()) {
            int sentSeqNum = this.newSentSeqNum();
            long sentPosition = this.proxy.sendHeartbeat(sentSeqNum, testReqId, testReqIdLength, this.sequenceIndex(), this.lastMsgSeqNumProcessed);
            if (sentPosition < 0L) {
                return ControlledFragmentHandler.Action.ABORT;
            }
            this.lastSentMsgSeqNum(sentSeqNum);
        }
        return this.onMessage(msgSeqNo, SessionConstants.TEST_REQUEST_MESSAGE_TYPE_CHARS, sendingTime, origSendingTime, isPossDupOrResend, possDup, position);
    }

    ControlledFragmentHandler.Action onSequenceReset(int msgSeqNo, int newSeqNo, boolean gapFillFlag, boolean possDupFlag, long position) {
        if (!gapFillFlag) {
            return this.applySequenceReset(msgSeqNo, newSeqNo, position);
        }
        if (newSeqNo > msgSeqNo) {
            return this.onGapFill(msgSeqNo, newSeqNo, possDupFlag, position);
        }
        return this.applySequenceReset(msgSeqNo, newSeqNo, position);
    }

    private ControlledFragmentHandler.Action applySequenceReset(int receivedMsgSeqNo, int newSeqNo, long position) {
        int expectedMsgSeqNo = this.expectedReceivedSeqNum();
        if (newSeqNo > expectedMsgSeqNo) {
            this.lastReceivedMsgSeqNum(newSeqNo - 1);
        } else if (newSeqNo < expectedMsgSeqNo) {
            if (this.redact(position)) {
                return ControlledFragmentHandler.Action.ABORT;
            }
            return this.checkPosition(this.proxy.sendReject(this.newSentSeqNum(), receivedMsgSeqNo, 36, SessionConstants.SEQUENCE_RESET_MESSAGE_TYPE_CHARS, SessionConstants.SEQUENCE_RESET_MESSAGE_TYPE_CHARS.length, RejectReason.VALUE_IS_INCORRECT.representation(), this.sequenceIndex(), this.lastMsgSeqNumProcessed));
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onGapFill(int receivedMsgSeqNo, int newSeqNo, boolean possDupFlag, long position) {
        int expectedMsgSeqNo;
        int n = expectedMsgSeqNo = this.awaitingResend ? this.lastResentMsgSeqNo + 1 : this.expectedReceivedSeqNum();
        if (receivedMsgSeqNo > expectedMsgSeqNo) {
            ControlledFragmentHandler.Action action = this.checkPosition(this.trySendResendRequest(expectedMsgSeqNo, receivedMsgSeqNo - 1));
            if (action != ControlledFragmentHandler.Action.ABORT) {
                if (this.awaitingResend) {
                    this.lastResentMsgSeqNo = newSeqNo - 1;
                } else {
                    this.lastReceivedMsgSeqNum(newSeqNo - 1);
                }
            }
            return action;
        }
        if (receivedMsgSeqNo < expectedMsgSeqNo) {
            if (!possDupFlag) {
                return this.msgSeqNumTooLow(receivedMsgSeqNo, expectedMsgSeqNo, position);
            }
        } else if (this.awaitingResend) {
            if (this.lastReceivedMsgSeqNum <= newSeqNo) {
                this.awaitingResend = false;
                this.lastResentMsgSeqNo = 0;
                this.lastResendChunkMsgSeqNum = 0;
                this.endOfResendRequestRange = 0;
                if (this.lastReceivedMsgSeqNum < newSeqNo) {
                    this.lastReceivedMsgSeqNum(newSeqNo - 1);
                }
            } else {
                if (newSeqNo == this.lastResendChunkMsgSeqNum) {
                    ControlledFragmentHandler.Action action = this.checkPosition(this.trySendResendRequest(newSeqNo, this.endOfResendMsgSeqNum()));
                    if (action == ControlledFragmentHandler.Action.CONTINUE) {
                        this.lastResentMsgSeqNo = newSeqNo - 1;
                    }
                    return action;
                }
                this.lastResentMsgSeqNo = newSeqNo - 1;
            }
        } else {
            this.lastReceivedMsgSeqNum(newSeqNo - 1);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    ControlledFragmentHandler.Action onResendRequest(int msgSeqNum, int beginSeqNum, int endSeqNum, boolean isPossDupOrResend, boolean possDup, long sendingTime, long origSendingTime, long position, AsciiBuffer messageBuffer, int messageOffset, int messageLength) {
        boolean replayUpToMostRecent;
        ControlledFragmentHandler.Action action = this.onMessage(msgSeqNum, SessionConstants.RESEND_REQUEST_MESSAGE_TYPE_CHARS, sendingTime, origSendingTime, isPossDupOrResend, possDup, position);
        if (action == ControlledFragmentHandler.Action.ABORT || !this.messageInfo.isValid()) {
            return action;
        }
        boolean bl = replayUpToMostRecent = endSeqNum == 0;
        if (!replayUpToMostRecent) {
            if (endSeqNum < beginSeqNum) {
                String message = messageBuffer.getAscii(messageOffset, messageLength);
                throw new IllegalStateException(String.format("[%s] Error in resend request, endSeqNo (%d) < beginSeqNo (%d)", message, endSeqNum, beginSeqNum));
            }
            if (beginSeqNum > this.lastSentMsgSeqNum) {
                return this.checkPosition(this.proxy.sendReject(this.newSentSeqNum(), msgSeqNum, 7, SessionConstants.RESEND_REQUEST_MESSAGE_TYPE_CHARS, SessionConstants.RESEND_REQUEST_MESSAGE_TYPE_CHARS.length, RejectReason.VALUE_IS_INCORRECT.representation(), this.sequenceIndex(), this.lastMsgSeqNumProcessed));
            }
        }
        int correctedEndSeqNo = replayUpToMostRecent ? this.lastSentMsgSeqNum : Math.min(this.lastSentMsgSeqNum, endSeqNum);
        return Pressure.apply(this.inboundPublication.saveValidResendRequest(this.id, this.connectionId, beginSeqNum, correctedEndSeqNo, this.sequenceIndex, (DirectBuffer)messageBuffer, messageOffset, messageLength));
    }

    ControlledFragmentHandler.Action onReject(int msgSeqNo, long sendingTime, long origSendingTime, boolean isPossDupOrResend, boolean possDup, long position) {
        return this.onMessage(msgSeqNo, SessionConstants.REJECT_MESSAGE_TYPE_CHARS, sendingTime, origSendingTime, isPossDupOrResend, possDup, position);
    }

    boolean onBeginString(char[] value, int length, boolean isLogon) {
        boolean isValid = CodecUtil.equals((char[])value, (String)this.beginString, (int)length);
        if (!isValid) {
            if (!isLogon) {
                int sentMsgSeqNum = this.newSentSeqNum();
                long position = this.proxy.sendIncorrectBeginStringLogout(sentMsgSeqNum, this.sequenceIndex(), this.lastMsgSeqNumProcessed);
                if (position < 0L) {
                    this.incorrectBeginString = true;
                    this.state(SessionState.DISCONNECTING);
                    return false;
                }
                this.lastSentMsgSeqNum(sentMsgSeqNum);
            }
            this.requestDisconnect(DisconnectReason.INCORRECT_BEGIN_STRING);
        }
        return isValid;
    }

    private void incNextHeartbeatTime() {
        this.nextRequiredHeartbeatTimeInMs = this.time() + this.sendingHeartbeatIntervalInMs;
    }

    private long trySendLogout() {
        long position;
        int sentSeqNum = this.newSentSeqNum();
        long l = position = this.logoutRejectReason == -1 ? this.proxy.sendLogout(sentSeqNum, this.sequenceIndex(), this.lastMsgSeqNumProcessed) : this.proxy.sendLogout(sentSeqNum, this.sequenceIndex(), this.logoutRejectReason, this.lastMsgSeqNumProcessed);
        if (position >= 0L) {
            this.lastSentMsgSeqNum(sentSeqNum);
        }
        return position;
    }

    void heartbeatIntervalInS(int heartbeatIntervalInS) {
        this.heartbeatIntervalInMs = TimeUnit.SECONDS.toMillis(heartbeatIntervalInS);
        long time = this.time();
        this.incNextReceivedInboundMessageTime(time);
        this.sendingHeartbeatIntervalInMs = (long)((double)this.heartbeatIntervalInMs * 0.8);
        this.nextRequiredHeartbeatTimeInMs = time + this.sendingHeartbeatIntervalInMs;
    }

    protected Session state(SessionState state) {
        this.state = state;
        return this;
    }

    void id(long id) {
        this.id = id;
    }

    protected long time() {
        return this.epochClock.time();
    }

    void lastReceivedMsgSeqNumOnly(int value) {
        this.lastReceivedMsgSeqNum = value;
        this.receivedMsgSeqNo.setOrdered((long)value);
    }

    int expectedReceivedSeqNum() {
        return this.lastReceivedMsgSeqNum + 1;
    }

    int newSentSeqNum() {
        return this.lastSentMsgSeqNum + 1;
    }

    private void incReceivedSeqNum() {
        ++this.lastReceivedMsgSeqNum;
        this.receivedMsgSeqNo.increment();
    }

    void lastSequenceResetTime(long lastSequenceResetTime) {
        this.lastSequenceResetTime = lastSequenceResetTime;
    }

    ControlledFragmentHandler.Action onInvalidMessage(int refSeqNum, int refTagId, char[] refMsgType, int refMsgTypeLength, int rejectReason, long position) {
        this.messageInfo.isValid(false);
        ControlledFragmentHandler.Action action = this.checkPosition(this.proxy.sendReject(this.newSentSeqNum(), refSeqNum, refTagId, refMsgType, refMsgTypeLength, rejectReason, this.sequenceIndex(), this.lastMsgSeqNumProcessed));
        if (action != ControlledFragmentHandler.Action.ABORT) {
            this.incReceivedSeqNum();
        }
        return action;
    }

    ControlledFragmentHandler.Action onHeartbeat(int msgSeqNum, char[] testReqID, int testReqIDLength, long sendingTime, long origSendingTime, boolean isPossDupOrResend, boolean possDup, long position) {
        if (this.awaitingHeartbeat && CodecUtil.equals((char[])testReqID, (char[])TEST_REQ_ID_CHARS, (int)testReqIDLength)) {
            this.awaitingHeartbeat = false;
        }
        return this.onMessage(msgSeqNum, SessionConstants.HEARTBEAT_MESSAGE_TYPE_CHARS, sendingTime, origSendingTime, isPossDupOrResend, possDup, position);
    }

    ControlledFragmentHandler.Action onInvalidMessageType(int msgSeqNum, char[] msgType, int msgTypeLength, long position) {
        return this.onInvalidMessage(msgSeqNum, Integer.MIN_VALUE, msgType, msgTypeLength, RejectReason.INVALID_MSGTYPE.representation(), position);
    }

    void disable() {
        this.state(SessionState.DISABLED);
        this.close();
    }

    int poll(long time) {
        int sentSeqNum;
        boolean isActive;
        short state = this.state().value();
        switch (state) {
            case 8: {
                if (this.incorrectBeginString) {
                    int sentMsgSeqNum = this.newSentSeqNum();
                    long position = this.proxy.sendIncorrectBeginStringLogout(sentMsgSeqNum, this.sequenceIndex(), this.lastMsgSeqNumProcessed);
                    if (position < 0L) {
                        return 1;
                    }
                    this.lastSentMsgSeqNum(sentMsgSeqNum);
                    this.requestDisconnect(DisconnectReason.INCORRECT_BEGIN_STRING);
                } else {
                    this.requestDisconnect();
                }
                return 1;
            }
            case 5: {
                this.startLogout();
                return 1;
            }
            case 6: {
                long position = this.trySendLogout();
                this.state(position < 0L ? SessionState.LOGGING_OUT_AND_DISCONNECTING : SessionState.DISCONNECTING);
                return 1;
            }
            case 7: {
                if (time > this.awaitingLogoutTimeoutInMs && !Pressure.isBackPressured(this.requestDisconnect())) {
                    this.state(SessionState.DISCONNECTING);
                }
                return 1;
            }
            case 9: 
            case 10: {
                return 0;
            }
        }
        int actions = 0;
        boolean bl = isActive = state == 3;
        if (isActive && time >= this.nextRequiredHeartbeatTimeInMs) {
            sentSeqNum = this.newSentSeqNum();
            long position = this.proxy.sendHeartbeat(sentSeqNum, this.sequenceIndex(), this.lastMsgSeqNumProcessed);
            this.lastSentMsgSeqNum(sentSeqNum, position);
            ++actions;
        }
        if (time >= this.nextRequiredInboundMessageTimeInMs) {
            if (this.awaitingHeartbeat) {
                this.requestDisconnect();
            } else if (isActive && this.proxy.sendTestRequest(sentSeqNum = this.newSentSeqNum(), TEST_REQ_ID, this.sequenceIndex(), this.lastMsgSeqNumProcessed) >= 0L) {
                this.lastSentMsgSeqNum(sentSeqNum);
                this.awaitingHeartbeat = true;
                this.incNextReceivedInboundMessageTime(time);
            }
            ++actions;
        }
        return actions;
    }

    void libraryConnected(boolean libraryConnected) {
        this.proxy.libraryConnected(libraryConnected);
    }

    void sequenceIndex(int sequenceIndex) {
        this.sequenceIndex = sequenceIndex;
    }

    protected long sendingTime(long sendingTime, long origSendingTime) {
        return -1L == origSendingTime ? sendingTime : origSendingTime;
    }

    void sessionProcessHandler(SessionProcessHandler sessionProcessHandler) {
        this.sessionProcessHandler = sessionProcessHandler;
    }

    void logoutRejectReason(int logoutRejectReason) {
        this.logoutRejectReason = logoutRejectReason;
    }

    void address(String connectedHost, int connectedPort) {
        this.connectedHost = connectedHost;
        this.connectedPort = connectedPort;
    }

    void username(String username) {
        this.username = username;
    }

    void password(String password) {
        this.password = password;
    }

    void lastLogonTime(long logonTime) {
        this.lastLogonTime = logonTime;
    }

    void awaitingResend(boolean awaitingResend) {
        this.awaitingResend = awaitingResend;
    }

    void resendRequestChunkSize(int resendRequestChunkSize) {
        this.resendRequestChunkSize = resendRequestChunkSize;
    }

    void closedResendInterval(boolean closedResendInterval) {
        this.closedResendInterval = closedResendInterval;
    }

    void sendRedundantResendRequests(boolean sendRedundantResendRequests) {
        this.sendRedundantResendRequests = sendRedundantResendRequests;
    }

    void updateLastMessageProcessed() {
        if (this.enableLastMsgSeqNumProcessed) {
            this.lastMsgSeqNumProcessed = this.lastReceivedMsgSeqNum;
        }
    }

    void initialLastReceivedMsgSeqNum(int lastReceivedMsgSeqNum) {
        this.lastReceivedMsgSeqNum(lastReceivedMsgSeqNum);
        this.updateLastMessageProcessed();
    }

    int lastMsgSeqNumProcessed() {
        return this.lastMsgSeqNumProcessed;
    }

    void lastResentMsgSeqNo(int lastResentMsgSeqNo) {
        this.lastResentMsgSeqNo = lastResentMsgSeqNo;
    }

    int lastResentMsgSeqNo() {
        return this.lastResentMsgSeqNo;
    }

    void lastResendChunkMsgSeqNum(int lastResendChunkMsgSeqNum) {
        this.lastResendChunkMsgSeqNum = lastResendChunkMsgSeqNum;
    }

    int lastResendChunkMsgSeqNum() {
        return this.lastResendChunkMsgSeqNum;
    }

    void endOfResendRequestRange(int endOfResendRequestRange) {
        this.endOfResendRequestRange = endOfResendRequestRange;
    }

    int endOfResendRequestRange() {
        return this.endOfResendRequestRange;
    }

    void awaitingHeartbeat(boolean awaitingHeartbeat) {
        this.awaitingHeartbeat = awaitingHeartbeat;
    }

    void fixDictionary(FixDictionary fixDictionary) {
        this.fixDictionary = fixDictionary;
        this.proxy.fixDictionary(fixDictionary);
        this.beginString = fixDictionary.beginString();
    }

    void connectionId(long connectionId) {
        this.connectionId = connectionId;
        this.proxy.connectionId(connectionId);
    }

    void enableLastMsgSeqNumProcessed(boolean enableLastMsgSeqNumProcessed) {
        this.enableLastMsgSeqNumProcessed = enableLastMsgSeqNumProcessed;
    }

    OnMessageInfo messageInfo() {
        return this.messageInfo;
    }

    void refreshSequenceNumberCounters(FixCounters counters) {
        this.closeCounters();
        this.receivedMsgSeqNo = counters.receivedMsgSeqNo(this.connectionId);
        this.sentMsgSeqNo = counters.receivedMsgSeqNo(this.connectionId);
    }

    void close() {
        this.closeCounters();
    }

    private void closeCounters() {
        this.sentMsgSeqNo.close();
        this.receivedMsgSeqNo.close();
    }

    boolean areCountersClosed() {
        return this.sentMsgSeqNo.isClosed() || this.receivedMsgSeqNo.isClosed();
    }
}

