/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.protocol;

import io.aeron.Aeron;
import io.aeron.ExclusivePublication;
import io.aeron.Subscription;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.StreamInformation;
import uk.co.real_logic.artio.engine.RecordingCoordinator;
import uk.co.real_logic.artio.protocol.GatewayPublication;

public final class Streams {
    private final int streamId;
    private final EpochNanoClock clock;
    private final Aeron aeron;
    private final String aeronChannel;
    private final boolean printAeronStreamIdentifiers;
    private final AtomicCounter failedPublications;
    private final int maxClaimAttempts;
    private final RecordingCoordinator recordingCoordinator;

    public Streams(Aeron aeron, String aeronChannel, boolean printAeronStreamIdentifiers, AtomicCounter failedPublications, int streamId, EpochNanoClock clock, int maxClaimAttempts, RecordingCoordinator recordingCoordinator) {
        this.aeron = aeron;
        this.aeronChannel = aeronChannel;
        this.printAeronStreamIdentifiers = printAeronStreamIdentifiers;
        this.failedPublications = failedPublications;
        this.streamId = streamId;
        this.clock = clock;
        this.maxClaimAttempts = maxClaimAttempts;
        this.recordingCoordinator = recordingCoordinator;
    }

    public GatewayPublication gatewayPublication(IdleStrategy idleStrategy, ExclusivePublication dataPublication) {
        return new GatewayPublication(dataPublication, this.failedPublications, idleStrategy, this.clock, this.maxClaimAttempts);
    }

    public ExclusivePublication dataPublication(String name) {
        ExclusivePublication publication = this.recordingCoordinator.track(this.aeronChannel, this.streamId);
        StreamInformation.print(name, publication, this.printAeronStreamIdentifiers);
        return publication;
    }

    public Subscription subscription(String name) {
        Subscription subscription = this.aeron.addSubscription(this.aeronChannel, this.streamId);
        StreamInformation.print(name, subscription, this.printAeronStreamIdentifiers);
        return subscription;
    }
}

