/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.engine.logger.FixMessageConsumer;
import uk.co.real_logic.artio.ilink.ILinkMessageConsumer;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.ILinkMessageDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;

class LogEntryHandler
implements ControlledFragmentHandler {
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final FixMessageDecoder fixMessage = new FixMessageDecoder();
    private final ILinkMessageDecoder iLinkMessage = new ILinkMessageDecoder();
    private final FixMessageConsumer fixHandler;
    private final ILinkMessageConsumer iLinkHandler;

    LogEntryHandler(FixMessageConsumer fixHandler, ILinkMessageConsumer iLinkHandler) {
        this.fixHandler = fixHandler;
        this.iLinkHandler = iLinkHandler;
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeader.wrap(buffer, offset);
        int templateId = this.messageHeader.templateId();
        int blockLength = this.messageHeader.blockLength();
        int version = this.messageHeader.version();
        if (templateId == 1) {
            this.fixMessage.wrap(buffer, offset += 8, blockLength, version);
            if (version >= FixMessageDecoder.metaDataSinceVersion()) {
                offset += FixMessageDecoder.metaDataHeaderLength() + this.fixMessage.metaDataLength();
                this.fixMessage.skipMetaData();
            }
            this.fixHandler.onMessage(this.fixMessage, buffer, offset, length, header);
        } else if (templateId == 58) {
            this.iLinkMessage.wrap(buffer, offset += 8, blockLength, version);
            this.iLinkHandler.onBusinessMessage(this.iLinkMessage, buffer, offset += 16, header);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }
}

