/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Subscription;
import io.aeron.logbuffer.ControlledFragmentHandler;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.Agent;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.decoder.AbstractResendRequestDecoder;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.engine.ReplayerCommandQueue;
import uk.co.real_logic.artio.engine.SenderSequenceNumbers;
import uk.co.real_logic.artio.engine.logger.FixReplayerCodecs;
import uk.co.real_logic.artio.engine.logger.FixSessionCodecsFactory;
import uk.co.real_logic.artio.engine.logger.GapFillEncoder;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.protocol.ProtocolHandler;
import uk.co.real_logic.artio.protocol.ProtocolSubscription;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class GapFiller
implements ProtocolHandler,
Agent {
    private static final int FRAGMENT_LIMIT = 10;
    private final AsciiBuffer decoderBuffer = new MutableAsciiBuffer();
    private final ReplayerCommandQueue replayerCommandQueue;
    private final FixSessionCodecsFactory fixSessionCodecsFactory;
    private final ControlledFragmentHandler protocolSubscription;
    private final Subscription inboundSubscription;
    private final GatewayPublication publication;
    private final String agentNamePrefix;
    private final SenderSequenceNumbers senderSequenceNumbers;

    public GapFiller(Subscription inboundSubscription, GatewayPublication publication, String agentNamePrefix, SenderSequenceNumbers senderSequenceNumbers, ReplayerCommandQueue replayerCommandQueue, FixSessionCodecsFactory fixSessionCodecsFactory) {
        this.inboundSubscription = inboundSubscription;
        this.publication = publication;
        this.agentNamePrefix = agentNamePrefix;
        this.senderSequenceNumbers = senderSequenceNumbers;
        this.replayerCommandQueue = replayerCommandQueue;
        this.fixSessionCodecsFactory = fixSessionCodecsFactory;
        this.protocolSubscription = ProtocolSubscription.of(this, fixSessionCodecsFactory);
    }

    public int doWork() {
        return this.replayerCommandQueue.poll() + this.inboundSubscription.controlledPoll(this.protocolSubscription, 10);
    }

    public String roleName() {
        return this.agentNamePrefix + "GapFiller";
    }

    @Override
    public ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, int libraryId, long connectionId, long sessionId, int sequenceIndex, long messageType, long timestamp, MessageStatus status, int sequenceNumber, long position, int metaDataLength) {
        if (messageType == 50L && status == MessageStatus.OK) {
            this.decoderBuffer.wrap(buffer);
            FixReplayerCodecs fixReplayerCodecs = this.fixSessionCodecsFactory.get(sessionId);
            AbstractResendRequestDecoder resendRequest = fixReplayerCodecs.resendRequest();
            GapFillEncoder encoder = fixReplayerCodecs.gapFillEncoder();
            resendRequest.decode(this.decoderBuffer, offset, length);
            SessionHeaderDecoder reqHeader = resendRequest.header();
            int beginSeqNo = resendRequest.beginSeqNo();
            int endSeqNo = resendRequest.endSeqNo();
            int lastSentSeqNo = this.newSeqNo(connectionId);
            int newSeqNo = endSeqNo == 0 ? lastSentSeqNo : endSeqNo;
            int gapFillMsgSeqNum = beginSeqNo;
            encoder.setupMessage(reqHeader);
            long result = encoder.encode(gapFillMsgSeqNum, newSeqNo);
            int encodedLength = Encoder.length((long)result);
            int encodedOffset = Encoder.offset((long)result);
            long sentPosition = this.publication.saveMessage((DirectBuffer)encoder.buffer(), encodedOffset, encodedLength, libraryId, 52L, sessionId, sequenceIndex, connectionId, MessageStatus.OK, gapFillMsgSeqNum);
            if (Pressure.isBackPressured(sentPosition)) {
                return ControlledFragmentHandler.Action.ABORT;
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onILinkMessage(long connectionId, DirectBuffer buffer, int offset) {
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private int newSeqNo(long connectionId) {
        return this.senderSequenceNumbers.lastSentSequenceNumber(connectionId) + 1;
    }

    @Override
    public ControlledFragmentHandler.Action onDisconnect(int libraryId, long connectionId, DisconnectReason reason) {
        return ControlledFragmentHandler.Action.CONTINUE;
    }
}

