/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.engine.PossDupEnabler;
import uk.co.real_logic.artio.engine.ReplayHandler;
import uk.co.real_logic.artio.engine.SequenceNumberExtractor;
import uk.co.real_logic.artio.engine.framer.MessageTypeExtractor;
import uk.co.real_logic.artio.engine.logger.FixMessageTracker;
import uk.co.real_logic.artio.engine.logger.GapFillEncoder;
import uk.co.real_logic.artio.engine.logger.MessageTracker;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;
import uk.co.real_logic.artio.engine.logger.Replayer;
import uk.co.real_logic.artio.engine.logger.ReplayerSession;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.FixMessageEncoder;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

class FixReplayerSession
extends ReplayerSession {
    private static final int NONE = -1;
    private static final byte[] NO_BYTES = new byte[0];
    private static final FixMessageEncoder FIX_MESSAGE_ENCODER = new FixMessageEncoder();
    private static final FixMessageDecoder FIX_MESSAGE = new FixMessageDecoder();
    private static final AsciiBuffer ASCII_BUFFER = new MutableAsciiBuffer();
    private final GapFillEncoder gapFillEncoder;
    private final PossDupEnabler possDupEnabler;
    private final String message;
    private final ReplayHandler replayHandler;
    private final LongHashSet gapFillMessageTypes;
    private final ErrorHandler errorHandler;
    private final SequenceNumberExtractor sequenceNumberExtractor;
    private final AtomicCounter bytesInBuffer;
    private final int maxBytesInBuffer;
    private int lastSeqNo;
    private int beginGapFillSeqNum = -1;
    private State state;

    FixReplayerSession(BufferClaim bufferClaim, IdleStrategy idleStrategy, ReplayHandler replayHandler, int maxClaimAttempts, LongHashSet gapFillMessageTypes, ExclusivePublication publication, EpochClock clock, int beginSeqNo, int endSeqNo, long connectionId, long sessionId, int sequenceIndex, ReplayQuery replayQuery, String message, ErrorHandler errorHandler, GapFillEncoder gapFillEncoder, AtomicCounter bytesInBuffer, int maxBytesInBuffer, UtcTimestampEncoder utcTimestampEncoder, Replayer replayer) {
        super(connectionId, bufferClaim, idleStrategy, maxClaimAttempts, publication, replayQuery, beginSeqNo, endSeqNo, sessionId, sequenceIndex, replayer);
        this.replayHandler = replayHandler;
        this.gapFillMessageTypes = gapFillMessageTypes;
        this.message = message;
        this.errorHandler = errorHandler;
        this.gapFillEncoder = gapFillEncoder;
        this.maxBytesInBuffer = maxBytesInBuffer;
        this.bytesInBuffer = bytesInBuffer;
        this.sequenceNumberExtractor = new SequenceNumberExtractor(errorHandler);
        this.lastSeqNo = beginSeqNo - 1;
        this.possDupEnabler = new PossDupEnabler(utcTimestampEncoder, bufferClaim, this::claimMessageBuffer, this::onPreCommit, x$0 -> this.onIllegalState((String)x$0, new Object[0]), this::onException, clock, publication.maxPayloadLength(), LogTag.FIX_MESSAGE);
        this.state = State.REPLAYING;
    }

    @Override
    MessageTracker messageTracker() {
        return new FixMessageTracker(LogTag.REPLAY, this, this.sessionId);
    }

    private void onPreCommit(MutableDirectBuffer buffer, int offset) {
        int frameOffset = offset + 8;
        FIX_MESSAGE_ENCODER.wrap(buffer, frameOffset).connection(this.connectionId);
    }

    private void onException(Throwable e) {
        String exMessage = String.format("[%s] Error replying to message", this.message);
        this.errorHandler.onError((Throwable)new IllegalArgumentException(exMessage, e));
    }

    private void onIllegalState(String message, Object ... arguments) {
        this.errorHandler.onError((Throwable)new IllegalStateException(String.format(message, arguments)));
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer srcBuffer, int srcOffset, int srcLength, Header header) {
        this.replayer.messageHeaderDecoder.wrap(srcBuffer, srcOffset);
        int actingBlockLength = this.replayer.messageHeaderDecoder.blockLength();
        int offset = srcOffset + 8;
        int version = this.replayer.messageHeaderDecoder.version();
        FIX_MESSAGE.wrap(srcBuffer, offset, actingBlockLength, version);
        if (FIX_MESSAGE.status() == MessageStatus.OK) {
            int metaDataAdjustment = version >= FixMessageDecoder.metaDataSinceVersion() ? FixMessageDecoder.metaDataHeaderLength() + FIX_MESSAGE.metaDataLength() : 0;
            int messageFrameBlockLength = Replayer.MESSAGE_FRAME_BLOCK_LENGTH + metaDataAdjustment;
            int messageOffset = srcOffset + messageFrameBlockLength;
            int messageLength = srcLength - messageFrameBlockLength;
            int msgSeqNum = this.sequenceNumberExtractor.extract(srcBuffer, messageOffset, messageLength);
            long messageType = MessageTypeExtractor.getMessageType(FIX_MESSAGE);
            ASCII_BUFFER.wrap(srcBuffer);
            this.replayHandler.onReplayedMessage((DirectBuffer)ASCII_BUFFER, messageOffset, messageLength, FIX_MESSAGE.libraryId(), FIX_MESSAGE.session(), FIX_MESSAGE.sequenceIndex(), messageType);
            if (this.gapFillMessageTypes.contains(messageType)) {
                if (this.beginGapFillSeqNum == -1) {
                    this.beginGapFillSeqNum = this.lastSeqNo + 1;
                }
                this.lastSeqNo = msgSeqNum;
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            if (this.beginGapFillSeqNum != -1) {
                this.sendGapFill(this.beginGapFillSeqNum, msgSeqNum);
            } else if (msgSeqNum > this.lastSeqNo + 1) {
                this.sendGapFill(this.lastSeqNo, msgSeqNum);
            }
            ControlledFragmentHandler.Action action = this.possDupEnabler.enablePossDupFlag(srcBuffer, messageOffset, messageLength, srcOffset, srcLength, metaDataAdjustment);
            if (action != ControlledFragmentHandler.Action.ABORT) {
                this.lastSeqNo = msgSeqNum;
            }
            return action;
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action sendGapFill(int msgSeqNo, int newSeqNo) {
        long result = this.gapFillEncoder.encode(msgSeqNo, newSeqNo);
        int gapFillLength = Encoder.length((long)result);
        int gapFillOffset = Encoder.offset((long)result);
        if (this.claimMessageBuffer(Replayer.MESSAGE_FRAME_BLOCK_LENGTH + gapFillLength + FixMessageDecoder.metaDataHeaderLength(), gapFillLength)) {
            int destOffset = this.bufferClaim.offset();
            MutableDirectBuffer destBuffer = this.bufferClaim.buffer();
            MutableAsciiBuffer gapFillBuffer = this.gapFillEncoder.buffer();
            FIX_MESSAGE_ENCODER.wrapAndApplyHeader(destBuffer, destOffset, this.replayer.messageHeaderEncoder).libraryId(0).messageType(52L).session(this.sessionId).sequenceIndex(this.sequenceIndex).connection(this.connectionId).timestamp(0L).status(MessageStatus.OK).putMetaData(NO_BYTES, 0, 0).putBody((DirectBuffer)gapFillBuffer, gapFillOffset, gapFillLength);
            this.bufferClaim.commit();
            DebugLogger.log(LogTag.FIX_MESSAGE, "Replayed: ", (DirectBuffer)gapFillBuffer, gapFillOffset, gapFillLength);
            this.beginGapFillSeqNum = -1;
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        DebugLogger.log(LogTag.REPLAY, "Back pressured trying to sendGapFill");
        return ControlledFragmentHandler.Action.ABORT;
    }

    private boolean claimMessageBuffer(int newLength, int messageLength) {
        if ((long)this.maxBytesInBuffer > this.bytesInBuffer.get() + (long)messageLength) {
            return this.claimBuffer(newLength);
        }
        return false;
    }

    @Override
    boolean attemptReplay() {
        switch (this.state) {
            case REPLAYING: {
                DebugLogger.log(LogTag.REPLAY_ATTEMPT, "ReplayerSession: REPLAYING step");
                if (this.replayOperation.attemptReplay()) {
                    this.state = State.CHECK_REPLAY;
                    return this.attemptReplay();
                }
                return false;
            }
            case CHECK_REPLAY: {
                DebugLogger.log(LogTag.REPLAY_ATTEMPT, "ReplayerSession: CHECK_REPLAY step");
                if (this.completeReplay()) {
                    this.state = State.SEND_COMPLETE_MESSAGE;
                }
                return false;
            }
            case SEND_COMPLETE_MESSAGE: {
                return this.sendCompleteMessage();
            }
        }
        return false;
    }

    private boolean completeReplay() {
        int replayedMessages = this.replayOperation.replayedMessages();
        if (this.beginGapFillSeqNum != -1) {
            int newSequenceNumber = this.endSeqNo + 1;
            ControlledFragmentHandler.Action action = this.sendGapFill(this.beginGapFillSeqNum, newSequenceNumber);
            DebugLogger.log(LogTag.REPLAY, this.replayer.completeReplayGapfillFormatter, action.name(), (long)replayedMessages, (long)this.beginGapFillSeqNum, (long)newSequenceNumber);
            return action != ControlledFragmentHandler.Action.ABORT;
        }
        int expectedCount = this.endSeqNo - this.beginSeqNo + 1;
        DebugLogger.log(LogTag.REPLAY, this.replayer.completeNotRecentFormatter, (long)replayedMessages, (long)this.endSeqNo, (long)this.beginSeqNo, (long)expectedCount);
        if (replayedMessages != expectedCount) {
            ControlledFragmentHandler.Action action;
            if (replayedMessages == 0 && (action = this.sendGapFill(this.beginSeqNo, this.endSeqNo + 1)) == ControlledFragmentHandler.Action.ABORT) {
                return false;
            }
            this.onIllegalState("[%s] Error in resend request, count(%d) < expectedCount (%d)", this.message, replayedMessages, expectedCount);
        }
        return true;
    }

    public String toString() {
        return "FixReplayerSession{message='" + this.message + '\'' + ", gapFillMessageTypes=" + this.gapFillMessageTypes + ", bytesInBuffer=" + this.bytesInBuffer + ", maxBytesInBuffer=" + this.maxBytesInBuffer + ", lastSeqNo=" + this.lastSeqNo + ", beginGapFillSeqNum=" + this.beginGapFillSeqNum + ", state=" + (Object)((Object)this.state) + ", connectionId=" + this.connectionId + ", beginSeqNo=" + this.beginSeqNo + ", endSeqNo=" + this.endSeqNo + ", sessionId=" + this.sessionId + ", sequenceIndex=" + this.sequenceIndex + '}';
    }

    private static enum State {
        REPLAYING,
        CHECK_REPLAY,
        SEND_COMPLETE_MESSAGE;

    }
}

