/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import java.util.concurrent.atomic.AtomicInteger;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.engine.ReplayerCommand;
import uk.co.real_logic.artio.engine.SenderSequenceNumbers;

public class SenderSequenceNumber
implements ReplayerCommand {
    private final long connectionId;
    private final AtomicCounter bytesInBuffer;
    private final SenderSequenceNumbers senderSequenceNumbers;
    private final AtomicInteger lastSentSequenceNumber = new AtomicInteger();

    SenderSequenceNumber(long connectionId, AtomicCounter bytesInBuffer, SenderSequenceNumbers senderSequenceNumbers) {
        this.connectionId = connectionId;
        this.bytesInBuffer = bytesInBuffer;
        this.senderSequenceNumbers = senderSequenceNumbers;
    }

    public void onNewMessage(int sequenceNumber) {
        this.lastSentSequenceNumber.set(sequenceNumber);
    }

    public int lastSentSequenceNumber() {
        return this.lastSentSequenceNumber.get();
    }

    public long connectionId() {
        return this.connectionId;
    }

    public AtomicCounter bytesInBuffer() {
        return this.bytesInBuffer;
    }

    public void close() {
        this.senderSequenceNumbers.onSenderClosed(this);
    }

    @Override
    public void execute() {
        this.senderSequenceNumbers.onSenderSequenceNumber(this);
    }
}

