/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Aeron;
import io.aeron.ControlledFragmentAssembler;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.status.RecordingPos;
import io.aeron.logbuffer.ControlledFragmentHandler;
import java.util.List;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.status.CountersReader;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.logger.MessageTracker;
import uk.co.real_logic.artio.engine.logger.RecordingRange;
import uk.co.real_logic.artio.util.CharFormatter;

public class ReplayOperation {
    private static final ThreadLocal<CharFormatter> RECORDING_RANGE_FORMATTER = ThreadLocal.withInitial(() -> new CharFormatter("ReplayOperation : Attempting Recording Range: RecordingRange{recordingId=%s, sessionId=%s, position=%s, length=%s, count=%s}%n"));
    private static final ThreadLocal<CharFormatter> POLLING_REPLAY_FORMATTER = ThreadLocal.withInitial(() -> new CharFormatter("Polling Replay Image pos=%s%n"));
    private static final ThreadLocal<CharFormatter> FINISHED_FORMATTER = ThreadLocal.withInitial(() -> new CharFormatter("Finished with Image @ pos=%s, closed=%s, eos=%s%n"));
    private static final ThreadLocal<CharFormatter> MESSAGE_REPLAY_COUNT_FORMATTER = ThreadLocal.withInitial(() -> new CharFormatter("Finished with messageTrackerCount=%s, recordingRangeCount=%s%n"));
    private final MessageTracker messageTracker;
    private final ControlledFragmentAssembler assembler;
    private final List<RecordingRange> ranges;
    private final AeronArchive aeronArchive;
    private final ErrorHandler errorHandler;
    private final int archiveReplayStream;
    private final LogTag logTag;
    private final CountersReader countersReader;
    private final Subscription subscription;
    private int replayedMessages = 0;
    private RecordingRange recordingRange;
    private int aeronSessionId;
    private Image image;

    ReplayOperation(List<RecordingRange> ranges, AeronArchive aeronArchive, ErrorHandler errorHandler, Subscription subscription, int archiveReplayStream, LogTag logTag, MessageTracker messageTracker) {
        this.messageTracker = messageTracker;
        this.assembler = new ControlledFragmentAssembler((ControlledFragmentHandler)this.messageTracker);
        this.ranges = ranges;
        this.aeronArchive = aeronArchive;
        this.errorHandler = errorHandler;
        this.archiveReplayStream = archiveReplayStream;
        this.logTag = logTag;
        Aeron aeron = aeronArchive.context().aeron();
        this.countersReader = aeron.countersReader();
        this.subscription = subscription;
    }

    public boolean attemptReplay() {
        if (this.recordingRange == null) {
            DebugLogger.log(this.logTag, "Acquiring Recording Range");
            if (this.ranges.isEmpty()) {
                return true;
            }
            this.recordingRange = this.ranges.get(0);
            this.logRange();
            long beginPosition = this.recordingRange.position;
            long length = this.recordingRange.length;
            long endPosition = beginPosition + length;
            long recordingId = this.recordingRange.recordingId;
            if (this.archivingNotComplete(endPosition, recordingId)) {
                DebugLogger.log(this.logTag, "Archiving not complete");
                this.recordingRange = null;
                return false;
            }
            this.ranges.remove(0);
            try {
                this.aeronSessionId = (int)this.aeronArchive.startReplay(recordingId, beginPosition, length, "aeron:ipc", this.archiveReplayStream);
                this.messageTracker.reset();
                if (this.image != null && this.aeronSessionId != this.image.sessionId()) {
                    this.image = null;
                }
            }
            catch (Throwable exception) {
                this.errorHandler.onError(exception);
                return true;
            }
        }
        if (this.image == null) {
            DebugLogger.log(this.logTag, "Acquiring Replay Image");
            this.image = this.subscription.imageBySessionId(this.aeronSessionId);
            return false;
        }
        if (DebugLogger.isEnabled(this.logTag)) {
            DebugLogger.log(this.logTag, POLLING_REPLAY_FORMATTER.get().clear().with(this.image.position()));
        }
        this.image.controlledPoll((ControlledFragmentHandler)this.assembler, Integer.MAX_VALUE);
        int messageTrackerCount = this.messageTracker.count;
        int recordingRangeCount = this.recordingRange.count;
        boolean closed = this.image.isClosed();
        boolean endOfStream = this.image.isEndOfStream();
        if (closed || endOfStream) {
            return this.onEndOfImage(recordingRangeCount, closed, endOfStream);
        }
        if (messageTrackerCount < recordingRangeCount) {
            return false;
        }
        return this.onReachedMessageReplayCount(messageTrackerCount, recordingRangeCount);
    }

    private void logRange() {
        LogTag logTag = this.logTag;
        if (DebugLogger.isEnabled(logTag)) {
            RecordingRange recordingRange = this.recordingRange;
            DebugLogger.log(logTag, RECORDING_RANGE_FORMATTER.get().clear().with(recordingRange.recordingId).with(recordingRange.sessionId).with(recordingRange.position).with(recordingRange.length).with(recordingRange.count));
        }
    }

    private boolean onReachedMessageReplayCount(int messageTrackerCount, int recordingRangeCount) {
        DebugLogger.log(this.logTag, MESSAGE_REPLAY_COUNT_FORMATTER.get(), (long)messageTrackerCount, (long)recordingRangeCount);
        this.replayedMessages += recordingRangeCount;
        this.recordingRange = null;
        return this.ranges.isEmpty();
    }

    private boolean onEndOfImage(int recordingRangeCount, boolean closed, boolean endOfStream) {
        if (DebugLogger.isEnabled(this.logTag)) {
            DebugLogger.log(this.logTag, FINISHED_FORMATTER.get().clear().with(this.image.position()).with(closed).with(endOfStream));
        }
        this.aeronSessionId = 0;
        this.replayedMessages += recordingRangeCount;
        this.recordingRange = null;
        this.image = null;
        return this.ranges.isEmpty();
    }

    int replayedMessages() {
        return this.replayedMessages;
    }

    private boolean archivingNotComplete(long endPosition, long recordingId) {
        int counterId = RecordingPos.findCounterIdByRecording((CountersReader)this.countersReader, (long)recordingId);
        if (counterId != -1) {
            long counterPosition = this.countersReader.getCounterValue(counterId);
            return counterPosition < endPosition;
        }
        return false;
    }

    public void close() {
        if (this.aeronSessionId != 0) {
            this.aeronArchive.stopReplay((long)this.aeronSessionId);
        }
    }
}

