/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import uk.co.real_logic.artio.engine.logger.EnqueuedReplay;
import uk.co.real_logic.artio.engine.logger.ReplayerSession;

class ReplayChannel {
    private ReplayerSession session;
    private Deque<EnqueuedReplay> enqueuedReplays;

    ReplayChannel(ReplayerSession session) {
        Objects.requireNonNull(session);
        this.startReplay(session);
    }

    void enqueueReplay(EnqueuedReplay enqueuedReplay) {
        if (this.enqueuedReplays == null) {
            this.enqueuedReplays = new ArrayDeque<EnqueuedReplay>();
        }
        this.enqueuedReplays.addLast(enqueuedReplay);
    }

    public int enqueuedReplayCount() {
        Deque<EnqueuedReplay> enqueuedReplays = this.enqueuedReplays;
        return enqueuedReplays == null ? 0 : enqueuedReplays.size();
    }

    void startReplay(ReplayerSession session) {
        this.session = session;
    }

    EnqueuedReplay pollReplay() {
        Deque<EnqueuedReplay> enqueuedReplays = this.enqueuedReplays;
        return enqueuedReplays == null ? null : enqueuedReplays.pollFirst();
    }

    boolean attemptReplay() {
        return this.session == null || this.session.attemptReplay();
    }

    void close() {
        this.session.close();
    }
}

