/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import org.agrona.DirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.artio.engine.SectorFramer;
import uk.co.real_logic.artio.engine.logger.IndexedPositionConsumer;
import uk.co.real_logic.artio.engine.logger.IndexedPositionWriter;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.storage.messages.IndexedPositionDecoder;

class IndexedPositionReader {
    static final long UNKNOWN_POSITION = -1L;
    private final IndexedPositionDecoder decoder = new IndexedPositionDecoder();
    private final int actingBlockLength;
    private final int actingVersion;
    private final AtomicBuffer buffer;
    private final SectorFramer sectorFramer;

    IndexedPositionReader(AtomicBuffer buffer) {
        this.buffer = buffer;
        MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
        messageHeader.wrap((DirectBuffer)buffer, 0);
        this.actingBlockLength = messageHeader.blockLength();
        this.actingVersion = messageHeader.version();
        this.sectorFramer = new SectorFramer(buffer.capacity());
    }

    long indexedPosition(long recordingId) {
        IndexedPositionDecoder decoder = this.decoder;
        int actingBlockLength = this.actingBlockLength;
        int actingVersion = this.actingVersion;
        AtomicBuffer buffer = this.buffer;
        int offset = 8;
        while ((offset = this.sectorFramer.claim(offset, 24)) != -1) {
            decoder.wrap((DirectBuffer)buffer, offset, actingBlockLength, actingVersion);
            long position = buffer.getLongVolatile(offset + IndexedPositionWriter.POSITION_OFFSET);
            if (position == 0L) {
                return -1L;
            }
            if (decoder.recordingId() == recordingId) {
                return position;
            }
            offset += 24;
        }
        return -1L;
    }

    void readLastPosition(IndexedPositionConsumer consumer) {
        IndexedPositionDecoder decoder = this.decoder;
        int actingBlockLength = this.actingBlockLength;
        int actingVersion = this.actingVersion;
        AtomicBuffer buffer = this.buffer;
        int offset = 8;
        while ((offset = this.sectorFramer.claim(offset, 24)) != -1) {
            decoder.wrap((DirectBuffer)buffer, offset, actingBlockLength, actingVersion);
            int sessionId = decoder.sessionId();
            long recordingId = decoder.recordingId();
            if (sessionId != 0) {
                consumer.accept(sessionId, recordingId, decoder.position());
            }
            offset += 24;
        }
        return;
    }
}

