/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.agrona.collections.Long2ObjectHashMap;
import uk.co.real_logic.artio.LivenessDetector;
import uk.co.real_logic.artio.engine.ConnectedSessionInfo;
import uk.co.real_logic.artio.engine.framer.ConnectingSession;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.GatewaySessions;
import uk.co.real_logic.artio.engine.framer.LibraryInfo;
import uk.co.real_logic.artio.engine.framer.SubscriptionSlowPeeker;

final class LiveLibraryInfo
implements LibraryInfo {
    private final int libraryId;
    private final String libraryName;
    private final LivenessDetector livenessDetector;
    private final int aeronSessionId;
    private final SubscriptionSlowPeeker.LibrarySlowPeeker librarySlowPeeker;
    private final List<GatewaySession> allSessions = new CopyOnWriteArrayList<GatewaySession>();
    private final List<ConnectedSessionInfo> unmodifiableAllSessions = Collections.unmodifiableList(this.allSessions);
    private final Long2ObjectHashMap<ConnectingSession> correlationIdToConnectingSession = new Long2ObjectHashMap();
    private long acquireAtPosition;

    LiveLibraryInfo(int libraryId, String libraryName, LivenessDetector livenessDetector, int aeronSessionId, SubscriptionSlowPeeker.LibrarySlowPeeker librarySlowPeeker) {
        this.libraryId = libraryId;
        this.libraryName = libraryName;
        this.livenessDetector = livenessDetector;
        this.aeronSessionId = aeronSessionId;
        this.librarySlowPeeker = librarySlowPeeker;
    }

    @Override
    public int libraryId() {
        return this.libraryId;
    }

    @Override
    public String libraryName() {
        return this.libraryName;
    }

    @Override
    public List<ConnectedSessionInfo> sessions() {
        return this.unmodifiableAllSessions;
    }

    public String toString() {
        return "LibraryInfo{libraryId=" + this.libraryId + ", allSessions=" + this.allSessions + '}';
    }

    int aeronSessionId() {
        return this.aeronSessionId;
    }

    List<GatewaySession> gatewaySessions() {
        return this.allSessions;
    }

    void onHeartbeat(long timeInMs) {
        this.livenessDetector.onHeartbeat(timeInMs);
    }

    int poll(long timeInMs) {
        return this.livenessDetector.poll(timeInMs);
    }

    boolean isConnected() {
        return this.livenessDetector.isConnected();
    }

    void addSession(GatewaySession session) {
        this.allSessions.add(session);
    }

    void removeSessionByConnectionId(long connectionId) {
        GatewaySessions.removeSessionByConnectionId(connectionId, this.allSessions);
    }

    void offlineSession(long connectionId) {
        List<GatewaySession> sessions = this.allSessions;
        int size = sessions.size();
        for (int i = 0; i < size; ++i) {
            GatewaySession session = sessions.get(i);
            if (session.connectionId() != connectionId) continue;
            session.goOffline();
        }
    }

    GatewaySession removeSessionBySessionId(long sessionId) {
        int index = GatewaySessions.indexBySessionId(sessionId, this.allSessions);
        return index == -1 ? null : this.allSessions.remove(index);
    }

    GatewaySession lookupSessionById(long sessionId) {
        int index = GatewaySessions.indexBySessionId(sessionId, this.allSessions);
        return index == -1 ? null : this.allSessions.get(index);
    }

    public void removeSession(GatewaySession gatewaySession) {
        this.allSessions.remove(gatewaySession);
    }

    void acquireAtPosition(long libraryPosition) {
        this.acquireAtPosition = libraryPosition;
    }

    long acquireAtPosition() {
        return this.acquireAtPosition;
    }

    SubscriptionSlowPeeker.LibrarySlowPeeker librarySlowPeeker() {
        return this.librarySlowPeeker;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveLibraryInfo that = (LiveLibraryInfo)o;
        return this.libraryId == that.libraryId;
    }

    public int hashCode() {
        return this.libraryId;
    }

    void releaseSlowPeeker() {
        this.librarySlowPeeker.removeLibrary();
    }

    void connectionStartsConnecting(long correlationId, ConnectingSession connectingSession) {
        this.correlationIdToConnectingSession.put(correlationId, (Object)connectingSession);
    }

    ConnectingSession connectionFinishesConnecting(long correlationId) {
        return (ConnectingSession)this.correlationIdToConnectingSession.remove(correlationId);
    }
}

