/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import io.aeron.ChannelUri;
import io.aeron.ControlledFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.exceptions.RegistrationException;
import io.aeron.logbuffer.ControlledFragmentHandler;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BooleanSupplier;
import java.util.function.ToIntFunction;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.LivenessDetector;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.engine.RecordingCoordinator;
import uk.co.real_logic.artio.fields.EpochFractionFormat;
import uk.co.real_logic.artio.ilink.AbstractILink3Parser;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.FollowerSessionReply;
import uk.co.real_logic.artio.library.ILink3Connection;
import uk.co.real_logic.artio.library.ILink3ConnectionConfiguration;
import uk.co.real_logic.artio.library.ILink3Subscription;
import uk.co.real_logic.artio.library.InitiateILink3ConnectionReply;
import uk.co.real_logic.artio.library.InitiateSessionReply;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.LibraryReply;
import uk.co.real_logic.artio.library.LibraryTransport;
import uk.co.real_logic.artio.library.MetadataHandler;
import uk.co.real_logic.artio.library.OnMessageInfo;
import uk.co.real_logic.artio.library.ReadMetaDataReply;
import uk.co.real_logic.artio.library.ReleaseToGatewayReply;
import uk.co.real_logic.artio.library.ReplayMessagesReply;
import uk.co.real_logic.artio.library.RequestSessionReply;
import uk.co.real_logic.artio.library.SessionAcquiredInfo;
import uk.co.real_logic.artio.library.SessionConfiguration;
import uk.co.real_logic.artio.library.SessionExistsHandler;
import uk.co.real_logic.artio.library.SessionSubscriber;
import uk.co.real_logic.artio.library.UnmodifiableWrapper;
import uk.co.real_logic.artio.library.WriteMetaDataReply;
import uk.co.real_logic.artio.messages.ConnectionType;
import uk.co.real_logic.artio.messages.ControlNotificationDecoder;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.GatewayError;
import uk.co.real_logic.artio.messages.InitialAcceptedSessionOwner;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.messages.MetaDataStatus;
import uk.co.real_logic.artio.messages.ReplayMessagesStatus;
import uk.co.real_logic.artio.messages.SessionReplyStatus;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.messages.SessionStatus;
import uk.co.real_logic.artio.messages.SlowStatus;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.protocol.LibraryEndPointHandler;
import uk.co.real_logic.artio.protocol.LibraryProtocolSubscription;
import uk.co.real_logic.artio.protocol.NotConnectedException;
import uk.co.real_logic.artio.protocol.ProtocolHandler;
import uk.co.real_logic.artio.protocol.ProtocolSubscription;
import uk.co.real_logic.artio.session.AcceptorSession;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.InitiatorSession;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.session.SessionParser;
import uk.co.real_logic.artio.session.SessionProxy;
import uk.co.real_logic.artio.session.SessionWriter;
import uk.co.real_logic.artio.timing.LibraryTimers;
import uk.co.real_logic.artio.timing.Timer;
import uk.co.real_logic.artio.util.CharFormatter;
import uk.co.real_logic.artio.util.EpochFractionClock;
import uk.co.real_logic.artio.util.EpochFractionClocks;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.validation.MessageValidationStrategy;

final class LibraryPoller
implements LibraryEndPointHandler,
ProtocolHandler,
AutoCloseable {
    private static final int CONNECTED = 0;
    private static final int ATTEMPT_CONNECT = 1;
    private static final int CONNECTING = 2;
    private static final int ATTEMPT_CURRENT_NODE = 3;
    private static final int CLOSED = 4;
    private static final int ENGINE_DISCONNECT = 5;
    private static final ILink3Connection[] EMPTY_ILINK_CONNECTIONS = new ILink3Connection[0];
    private static final InternalSession[] EMPTY_SESSIONS = new InternalSession[0];
    private final Long2ObjectHashMap<WeakReference<InternalSession>> sessionIdToCachedSession = new Long2ObjectHashMap();
    private final Long2ObjectHashMap<SessionSubscriber> connectionIdToSession = new Long2ObjectHashMap();
    private ILink3Connection[] iLink3Connections = EMPTY_ILINK_CONNECTIONS;
    private final List<ILink3Connection> unmodifiableILink3Connections = new UnmodifiableWrapper<ILink3Connection>(() -> this.iLink3Connections);
    private InternalSession[] sessions = EMPTY_SESSIONS;
    private InternalSession[] pendingInitiatorSessions = EMPTY_SESSIONS;
    private final List<Session> unmodifiableSessions = new UnmodifiableWrapper<Session>(() -> this.sessions);
    private final Long2ObjectHashMap<ILink3Subscription> connectionIdToILink3Subscription = new Long2ObjectHashMap();
    private static final ErrorHandler THROW_ERRORS = LangUtil::rethrowUnchecked;
    private final LongHashSet sessionIds = new LongHashSet();
    private final int libraryId;
    private final EpochClock epochClock;
    private final EpochFractionClock epochFractionClock;
    private final LibraryConfiguration configuration;
    private final SessionIdStrategy sessionIdStrategy;
    private final Timer sessionTimer;
    private final Timer receiveTimer;
    private final SessionExistsHandler sessionExistsHandler;
    private final boolean enginesAreClustered;
    private final FixCounters fixCounters;
    private final Long2ObjectHashMap<LibraryReply<?>> correlationIdToReply = new Long2ObjectHashMap();
    private final List<BooleanSupplier> tasks = new ArrayList<BooleanSupplier>();
    private final LibraryTransport transport;
    private final FixLibrary fixLibrary;
    private final Runnable onDisconnectFunc = this::onDisconnect;
    private final SessionAcquiredInfo sessionAcquiredInfo = new SessionAcquiredInfo();
    private final CharFormatter receivedFormatter = new CharFormatter("(%s) Received %s %n");
    private final CharFormatter disconnectedFormatter = new CharFormatter("%s: Disconnected from [%s]%n");
    private final CharFormatter connectedFormatter = new CharFormatter("%s: Connected to [%s]%n");
    private final CharFormatter attemptConnectFormatter = new CharFormatter("%s: Attempting to connect to %s%n");
    private final CharFormatter attemptNextFormatter = new CharFormatter("%s: Attempting connect to next engine (%s) in round-robin%n");
    private final CharFormatter initiatorConnectFormatter = new CharFormatter("Init Connect: %s, %s%n");
    private final CharFormatter acceptorConnectFormatter = new CharFormatter("Acct Connect: %s, %s%n");
    private final CharFormatter controlNotificationFormatter = new CharFormatter("%s: Received Control Notification from engine at timeInMs %s%n");
    private final CharFormatter applicationHeartbeatFormatter = new CharFormatter("%s: Received Heartbeat from engine at timeInMs %s%n");
    private final CharFormatter reconnectFormatter = new CharFormatter("Reconnect: %s, %s, %s%n");
    private final CharFormatter onDisconnectFormatter = new CharFormatter("%s: Session Disconnect @ Library %s, %s%n");
    private final CharFormatter sessionExistsFormatter = new CharFormatter("onSessionExists: conn=%s, sess=%s, sentSeqNo=%s, recvSeqNo=%s%n");
    private long currentCorrelationId = ThreadLocalRandom.current().nextLong(1L, Long.MAX_VALUE);
    private InitialAcceptedSessionOwner initialAcceptedSessionOwner;
    private int state = 2;
    private LivenessDetector livenessDetector;
    private Subscription inboundSubscription;
    private GatewayPublication inboundPublication;
    private GatewayPublication outboundPublication;
    private String currentAeronChannel;
    private long nextSendLibraryConnectTime;
    private long nextEngineAttemptTime;
    private long connectCorrelationId = 0L;
    private int sessionLogoutIndex = 0;
    private Iterator<ILink3Subscription> iLink3LogoutIterator = null;
    private final ControlledFragmentHandler outboundSubscription = new ControlledFragmentAssembler(ProtocolSubscription.of(this, new LibraryProtocolSubscription(this)));

    LibraryPoller(LibraryConfiguration configuration, LibraryTimers timers, FixCounters fixCounters, LibraryTransport transport, FixLibrary fixLibrary, EpochClock epochClock) {
        this.libraryId = configuration.libraryId();
        this.fixCounters = fixCounters;
        this.transport = transport;
        this.fixLibrary = fixLibrary;
        this.sessionTimer = timers.sessionTimer();
        this.receiveTimer = timers.receiveTimer();
        this.configuration = configuration;
        this.sessionIdStrategy = configuration.sessionIdStrategy();
        this.sessionExistsHandler = configuration.sessionExistsHandler();
        this.epochClock = epochClock;
        this.enginesAreClustered = configuration.libraryAeronChannels().size() > 1;
        this.epochFractionClock = EpochFractionClocks.create((EpochClock)epochClock, (EpochNanoClock)configuration.epochNanoClock(), (EpochFractionFormat)configuration.sessionEpochFractionFormat());
    }

    boolean isConnected() {
        return this.state == 0;
    }

    boolean isClosed() {
        return this.state == 4;
    }

    boolean isAtEndOfDay() {
        return this.state == 5;
    }

    int libraryId() {
        return this.libraryId;
    }

    List<Session> sessions() {
        return this.unmodifiableSessions;
    }

    Reply<Session> initiate(SessionConfiguration configuration) {
        Objects.requireNonNull(configuration, "configuration");
        this.validateEndOfDay();
        return new InitiateSessionReply(this, this.timeInMs() + configuration.timeoutInMs(), configuration);
    }

    public Reply<ILink3Connection> initiate(ILink3ConnectionConfiguration configuration) {
        Objects.requireNonNull(configuration, "configuration");
        this.validateEndOfDay();
        return new InitiateILink3ConnectionReply(this, this.timeInMs() + (long)configuration.requestedKeepAliveIntervalInMs(), configuration);
    }

    Reply<SessionReplyStatus> releaseToGateway(Session session, long timeoutInMs) {
        Objects.requireNonNull(session, "session");
        this.validateEndOfDay();
        return new ReleaseToGatewayReply(this, this.timeInMs() + timeoutInMs, (InternalSession)session);
    }

    Reply<SessionReplyStatus> requestSession(long sessionId, int resendFromSequenceNumber, int resendFromSequenceIndex, long timeoutInMs) {
        this.validateEndOfDay();
        return new RequestSessionReply(this, this.timeInMs() + timeoutInMs, sessionId, resendFromSequenceNumber, resendFromSequenceIndex);
    }

    SessionWriter followerSession(long id, long connectionId, int sequenceIndex) {
        this.checkState();
        return new SessionWriter(this.libraryId, id, connectionId, this.sessionBuffer(), this.outboundPublication, sequenceIndex);
    }

    Reply<SessionWriter> followerSession(SessionHeaderEncoder headerEncoder, long timeoutInMs) {
        this.validateEndOfDay();
        return new FollowerSessionReply(this, this.timeInMs() + timeoutInMs, headerEncoder);
    }

    Reply<MetaDataStatus> writeMetaData(long sessionId, int metaDataOffset, DirectBuffer buffer, int offset, int length) {
        if (metaDataOffset < 0) {
            throw new IllegalArgumentException("metaDataOffset should never be negative and is " + metaDataOffset);
        }
        return new WriteMetaDataReply(this, this.timeInMs() + this.configuration.replyTimeoutInMs(), sessionId, metaDataOffset, buffer, offset, length);
    }

    public void readMetaData(long sessionId, MetadataHandler handler) {
        new ReadMetaDataReply(this, this.timeInMs() + this.configuration.replyTimeoutInMs(), sessionId, handler);
    }

    void disableSession(InternalSession session) {
        this.sessions = (InternalSession[])ArrayUtil.remove((Object[])this.sessions, (Object)session);
        session.disable();
        this.cacheSession(session);
    }

    private void cacheSession(InternalSession session) {
        this.sessionIdToCachedSession.put(session.id(), new WeakReference<InternalSession>(session));
    }

    long saveWriteMetaData(long sessionId, int metaDataOffset, DirectBuffer buffer, int offset, int length, long correlationId) {
        this.checkState();
        return this.outboundPublication.saveWriteMetaData(this.libraryId, sessionId, metaDataOffset, correlationId, buffer, offset, length);
    }

    long saveReadMetaData(long sessionId, long correlationId) {
        this.checkState();
        return this.outboundPublication.saveReadMetaData(this.libraryId, sessionId, correlationId);
    }

    long saveReleaseSession(Session session, long correlationId) {
        this.checkState();
        return this.outboundPublication.saveReleaseSession(this.libraryId, session.connectionId(), session.id(), correlationId, session.state(), session.awaitingResend(), session.heartbeatIntervalInMs(), session.lastSentMsgSeqNum(), session.lastReceivedMsgSeqNum(), session.username(), session.password());
    }

    long saveInitiateConnection(String host, int port, long correlationId, SessionConfiguration configuration) {
        this.checkState();
        return this.outboundPublication.saveInitiateConnection(this.libraryId, host, port, configuration.senderCompId(), configuration.senderSubId(), configuration.senderLocationId(), configuration.targetCompId(), configuration.targetSubId(), configuration.targetLocationId(), configuration.sequenceNumberType(), configuration.resetSeqNum(), configuration.initialReceivedSequenceNumber(), configuration.initialSentSequenceNumber(), configuration.closedResendInterval(), configuration.resendRequestChunkSize(), configuration.sendRedundantResendRequests(), configuration.enableLastMsgSeqNumProcessed(), configuration.username(), configuration.password(), configuration.fixDictionary(), this.configuration.defaultHeartbeatIntervalInS(), correlationId);
    }

    long saveReplayMessages(long sessionId, long correlationId, int replayFromSequenceNumber, int replayFromSequenceIndex, int replayToSequenceNumber, int replayToSequenceIndex, long latestReplyArrivalTimeInMs) {
        this.checkState();
        return this.outboundPublication.saveReplayMessages(this.libraryId, sessionId, correlationId, replayFromSequenceNumber, replayFromSequenceIndex, replayToSequenceNumber, replayToSequenceIndex, latestReplyArrivalTimeInMs);
    }

    void onInitiatorSessionTimeout(long correlationId, long connectionId) {
        this.checkState();
        if (connectionId == -1L) {
            this.onTimeoutWaitingForConnection(correlationId);
        } else if (!this.saveNoLogonRequestDisconnect(connectionId)) {
            this.tasks.add(() -> this.saveNoLogonRequestDisconnect(connectionId));
        }
    }

    void onTimeoutWaitingForConnection(long correlationId) {
        if (!this.saveMidConnectionDisconnect(correlationId)) {
            this.tasks.add(() -> this.saveMidConnectionDisconnect(correlationId));
        }
    }

    private boolean saveMidConnectionDisconnect(long correlationId) {
        return this.outboundPublication.saveMidConnectionDisconnect(this.libraryId, correlationId) > 0L;
    }

    private boolean saveNoLogonRequestDisconnect(long connectionId) {
        return this.outboundPublication.saveRequestDisconnect(this.libraryId, connectionId, DisconnectReason.NO_LOGON) > 0L;
    }

    long saveRequestSession(long sessionId, long correlationId, int lastReceivedSequenceNumber, int sequenceIndex) {
        this.checkState();
        return this.outboundPublication.saveRequestSession(this.libraryId, sessionId, correlationId, lastReceivedSequenceNumber, sequenceIndex);
    }

    long saveFollowerSessionRequest(long correlationId, MutableAsciiBuffer buffer, int offset, int length) {
        this.checkState();
        return this.outboundPublication.saveFollowerSessionRequest(this.libraryId, correlationId, (DirectBuffer)buffer, offset, length);
    }

    int poll(int fragmentLimit) {
        long timeInMs = this.timeInMs();
        switch (this.state) {
            case 0: {
                return this.pollWithoutReconnect(timeInMs, fragmentLimit);
            }
            case 1: {
                this.startConnecting();
                return this.pollWithoutReconnect(timeInMs, fragmentLimit);
            }
            case 2: {
                this.nextConnectingStep(timeInMs);
                return this.pollWithoutReconnect(timeInMs, fragmentLimit);
            }
            case 3: {
                this.connectToNewEngine(timeInMs);
                this.state = 2;
                return this.pollWithoutReconnect(timeInMs, fragmentLimit);
            }
            case 5: {
                this.attemptEngineCloseBasedLogout();
                return this.pollWithoutReconnect(timeInMs, fragmentLimit);
            }
        }
        return 0;
    }

    private int pollWithoutReconnect(long timeInMs, int fragmentLimit) {
        int operations = 0;
        operations += this.inboundSubscription.controlledPoll(this.outboundSubscription, fragmentLimit);
        operations += this.livenessDetector.poll(timeInMs);
        operations += this.pollSessions(timeInMs);
        operations += this.pollPendingInitiatorSessions(timeInMs);
        return operations += this.checkReplies(timeInMs);
    }

    void startConnecting() {
        this.startConnecting(this.timeInMs());
    }

    private void startConnecting(long timeInMs) {
        try {
            this.state = 2;
            this.currentAeronChannel = this.configuration.libraryAeronChannels().get(0);
            DebugLogger.log(LogTag.LIBRARY_CONNECT, this.attemptConnectFormatter, (long)this.libraryId, this.currentAeronChannel);
            this.initStreams();
            this.newLivenessDetector();
            this.resetNextEngineTimer(timeInMs);
            this.sendLibraryConnect(timeInMs);
        }
        catch (Exception ex) {
            try {
                this.closeWithParent();
            }
            catch (Exception closeException) {
                ex.addSuppressed(closeException);
            }
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
    }

    private void nextConnectingStep(long timeInMs) {
        if (timeInMs > this.nextEngineAttemptTime) {
            this.attemptNextEngine();
            this.connectToNewEngine(timeInMs);
        } else if (timeInMs > this.nextSendLibraryConnectTime) {
            this.sendLibraryConnect(timeInMs);
        }
    }

    private void connectToNewEngine(long timeInMs) {
        this.initStreams();
        this.newLivenessDetector();
        this.sendLibraryConnect(timeInMs);
        this.resetNextEngineTimer(timeInMs);
    }

    private void attemptNextEngine() {
        if (this.enginesAreClustered) {
            List<String> aeronChannels = this.configuration.libraryAeronChannels();
            int nextIndex = (aeronChannels.indexOf(this.currentAeronChannel) + 1) % aeronChannels.size();
            this.currentAeronChannel = aeronChannels.get(nextIndex);
            DebugLogger.log(LogTag.LIBRARY_CONNECT, this.attemptNextFormatter, (long)this.libraryId, this.currentAeronChannel);
        }
    }

    private void resetNextEngineTimer(long timeInMs) {
        this.nextEngineAttemptTime = this.configuration.replyTimeoutInMs() + timeInMs;
    }

    private void initStreams() {
        if (this.enginesAreClustered || this.isFirstConnect()) {
            this.transport.initStreams(this.currentAeronChannel);
            this.inboundSubscription = this.transport.inboundSubscription();
            this.inboundPublication = this.transport.inboundPublication();
            this.outboundPublication = this.transport.outboundPublication();
        }
    }

    private void newLivenessDetector() {
        this.livenessDetector = LivenessDetector.forLibrary(this.outboundPublication, this.libraryId, this.configuration.replyTimeoutInMs(), this.onDisconnectFunc);
    }

    private boolean isFirstConnect() {
        return !this.transport.isReconnect();
    }

    private void sendLibraryConnect(long timeInMs) {
        try {
            long correlationId = ++this.currentCorrelationId;
            if (this.outboundPublication.saveLibraryConnect(this.libraryId, this.configuration.libraryName(), correlationId) < 0L) {
                this.connectToNextEngineNow(timeInMs);
            } else {
                this.connectCorrelationId = correlationId;
                this.nextSendLibraryConnectTime = this.configuration.connectAttemptTimeoutInMs() + timeInMs;
            }
        }
        catch (NotConnectedException e) {
            this.connectToNextEngineNow(timeInMs);
        }
    }

    private void connectToNextEngineNow(long timeInMs) {
        this.nextEngineAttemptTime = timeInMs;
    }

    private void onConnect() {
        DebugLogger.log(LogTag.LIBRARY_CONNECT, this.connectedFormatter, (long)this.libraryId, this.currentAeronChannel);
        this.configuration.libraryConnectHandler().onConnect(this.fixLibrary);
        this.setLibraryConnected(true);
    }

    private void onDisconnect() {
        DebugLogger.log(LogTag.LIBRARY_CONNECT, this.disconnectedFormatter, (long)this.libraryId, this.currentAeronChannel);
        this.configuration.libraryConnectHandler().onDisconnect(this.fixLibrary);
        this.setLibraryConnected(false);
        this.state = 1;
    }

    private void setLibraryConnected(boolean libraryConnected) {
        for (InternalSession session : this.sessions) {
            session.libraryConnected(libraryConnected);
        }
    }

    String currentAeronChannel() {
        return this.currentAeronChannel;
    }

    private int pollSessions(long timeInMs) {
        InternalSession[] sessions = this.sessions;
        int total = 0;
        for (InternalSession session : sessions) {
            total += session.poll(timeInMs);
        }
        for (ILink3Connection connection : this.iLink3Connections) {
            total += connection.poll(timeInMs);
        }
        return total;
    }

    private int pollPendingInitiatorSessions(long timeInMs) {
        Object[] pendingSessions = this.pendingInitiatorSessions;
        int total = 0;
        int i = 0;
        int size = pendingSessions.length;
        while (i < size) {
            InternalSession session = pendingSessions[i];
            total += session.poll(timeInMs);
            if (session.state() == SessionState.ACTIVE) {
                pendingSessions = (InternalSession[])ArrayUtil.remove((Object[])pendingSessions, (int)i);
                this.pendingInitiatorSessions = pendingSessions;
                --size;
                this.sessions = (InternalSession[])ArrayUtil.add((Object[])this.sessions, (Object)session);
                continue;
            }
            ++i;
        }
        return total;
    }

    long timeInMs() {
        return this.epochClock.time();
    }

    private int checkReplies(long timeInMs) {
        int count = 0;
        Long2ObjectHashMap.ValueIterator iterator = this.correlationIdToReply.values().iterator();
        while (iterator.hasNext()) {
            LibraryReply reply = (LibraryReply)iterator.next();
            if (!reply.poll(timeInMs)) continue;
            iterator.remove();
            ++count;
        }
        CollectionUtil.removeIf(this.tasks, BooleanSupplier::getAsBoolean);
        return count;
    }

    long register(LibraryReply<?> reply) {
        long correlationId = ++this.currentCorrelationId;
        this.correlationIdToReply.put(correlationId, reply);
        return correlationId;
    }

    void deregister(long correlationId) {
        this.correlationIdToReply.remove(correlationId);
    }

    @Override
    public ControlledFragmentHandler.Action onManageSession(int libraryId, long connectionId, long sessionId, int lastSentSeqNum, int lastRecvSeqNum, SessionStatus sessionStatus, SlowStatus slowStatus, ConnectionType connectionType, SessionState sessionState, int heartbeatIntervalInS, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, long correlationId, int sequenceIndex, boolean awaitingResend, int lastResentMsgSeqNo, int lastResendChunkMsgSeqNum, int endOfResendRequestRange, boolean awaitingHeartbeat, int logonReceivedSequenceNumber, int logonSequenceIndex, long lastLogonTime, long lastSequenceResetTime, String localCompId, String localSubId, String localLocationId, String remoteCompId, String remoteSubId, String remoteLocationId, String address, String username, String password, Class<? extends FixDictionary> fixDictionaryType, MetaDataStatus metaDataStatus, DirectBuffer metaDataBuffer, int metaDataOffset, int metaDataLength) {
        if (this.state == 0) {
            FixDictionary fixDictionary = FixDictionary.of(fixDictionaryType);
            if (libraryId == 0) {
                this.sessionExistsHandler.onSessionExists(this.fixLibrary, sessionId, localCompId, localSubId, localLocationId, remoteCompId, remoteSubId, remoteLocationId, logonReceivedSequenceNumber, logonSequenceIndex);
            } else if (libraryId == this.libraryId) {
                if (sessionStatus == SessionStatus.SESSION_HANDOVER) {
                    this.sessionAcquiredInfo.wrap(slowStatus, metaDataStatus, metaDataBuffer, metaDataOffset, metaDataLength);
                    this.onHandoverSession(libraryId, connectionId, sessionId, lastSentSeqNum, lastRecvSeqNum, connectionType, sessionState, heartbeatIntervalInS, closedResendInterval, resendRequestChunkSize, sendRedundantResendRequests, enableLastMsgSeqNumProcessed, correlationId, sequenceIndex, awaitingResend, lastResentMsgSeqNo, lastResendChunkMsgSeqNum, endOfResendRequestRange, awaitingHeartbeat, lastLogonTime, lastSequenceResetTime, localCompId, localSubId, localLocationId, remoteCompId, remoteSubId, remoteLocationId, address, username, password, fixDictionary);
                } else {
                    this.sessionExistsHandler.onSessionExists(this.fixLibrary, sessionId, localCompId, localSubId, localLocationId, remoteCompId, remoteSubId, remoteLocationId, logonReceivedSequenceNumber, logonSequenceIndex);
                }
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void onHandoverSession(int libraryId, long connectionId, long sessionId, int lastSentSeqNum, int lastRecvSeqNum, ConnectionType connectionType, SessionState sessionState, int heartbeatIntervalInS, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, long correlationId, int sequenceIndex, boolean awaitingResend, int lastResentMsgSeqNo, int lastResendChunkMsgSeqNum, int endOfResendRequestRange, boolean awaitingHeartbeat, long lastLogonTime, long lastSequenceResetTime, String localCompId, String localSubId, String localLocationId, String remoteCompId, String remoteSubId, String remoteLocationId, String address, String username, String password, FixDictionary fixDictionary) {
        OnMessageInfo messageInfo;
        InitiateSessionReply reply = null;
        InternalSession session = this.checkReconnect(sessionId, connectionId, sessionState, heartbeatIntervalInS, sequenceIndex, enableLastMsgSeqNumProcessed, fixDictionary, connectionType, address);
        boolean isNewConnect = session == null;
        OnMessageInfo onMessageInfo = messageInfo = isNewConnect ? new OnMessageInfo() : session.messageInfo();
        if (connectionType == ConnectionType.INITIATOR) {
            boolean resetSeqNum;
            DebugLogger.log(LogTag.FIX_CONNECTION, this.initiatorConnectFormatter, connectionId, (long)libraryId);
            LibraryReply task = (LibraryReply)this.correlationIdToReply.get(correlationId);
            boolean isReply = task instanceof InitiateSessionReply;
            if (isReply) {
                reply = (InitiateSessionReply)task;
                reply.onTcpConnected(connectionId);
            }
            SessionConfiguration sessionConfiguration = isReply ? reply.configuration() : null;
            int initialReceivedSequenceNumber = this.initiatorNewSequenceNumber(sessionConfiguration, SessionConfiguration::initialReceivedSequenceNumber, lastRecvSeqNum);
            int initialSentSequenceNumber = this.initiatorNewSequenceNumber(sessionConfiguration, SessionConfiguration::initialSentSequenceNumber, lastSentSeqNum);
            boolean bl = resetSeqNum = sessionConfiguration != null && sessionConfiguration.resetSeqNum();
            if (isNewConnect) {
                session = this.newInitiatorSession(connectionId, initialSentSequenceNumber, initialReceivedSequenceNumber, sessionState, sequenceIndex, enableLastMsgSeqNumProcessed, fixDictionary, resetSeqNum, messageInfo);
            } else {
                session.lastSentMsgSeqNum(initialSentSequenceNumber - 1);
                session.lastReceivedMsgSeqNumOnly(initialReceivedSequenceNumber - 1);
            }
        } else {
            DebugLogger.log(LogTag.FIX_CONNECTION, this.acceptorConnectFormatter, connectionId, (long)libraryId);
            if (isNewConnect) {
                session = this.acceptSession(connectionId, address, sessionState, heartbeatIntervalInS, sequenceIndex, enableLastMsgSeqNumProcessed, fixDictionary, messageInfo);
                session.initialLastReceivedMsgSeqNum(lastRecvSeqNum);
            } else {
                session.lastReceivedMsgSeqNumOnly(lastRecvSeqNum);
            }
            session.lastSentMsgSeqNum(lastSentSeqNum);
        }
        CompositeKey compositeKey = this.sessionIdStrategy.onInitiateLogon(localCompId, localSubId, localLocationId, remoteCompId, remoteSubId, remoteLocationId);
        session.username(username);
        session.password(password);
        session.setupSession(sessionId, compositeKey);
        session.closedResendInterval(closedResendInterval);
        session.resendRequestChunkSize(resendRequestChunkSize);
        session.sendRedundantResendRequests(sendRedundantResendRequests);
        session.awaitingResend(awaitingResend);
        session.lastResentMsgSeqNo(lastResentMsgSeqNo);
        session.lastResendChunkMsgSeqNum(lastResendChunkMsgSeqNum);
        session.endOfResendRequestRange(endOfResendRequestRange);
        session.awaitingHeartbeat(awaitingHeartbeat);
        if (lastLogonTime != -1L) {
            session.lastLogonTime(lastLogonTime);
        }
        if (lastSequenceResetTime != -1L) {
            session.lastSequenceResetTime(lastSequenceResetTime);
        }
        this.createSessionSubscriber(connectionId, session, reply, fixDictionary, messageInfo, compositeKey);
        if (isNewConnect) {
            this.insertSession(session, connectionType, sessionState);
        }
        DebugLogger.log(LogTag.GATEWAY_MESSAGE, this.sessionExistsFormatter, connectionId, sessionId, (long)lastSentSeqNum, (long)lastRecvSeqNum);
    }

    private InternalSession checkReconnect(long sessionId, long connectionId, SessionState sessionState, int heartbeatIntervalInS, int sequenceIndex, boolean enableLastMsgSeqNumProcessed, FixDictionary fixDictionary, ConnectionType connectionType, String address) {
        InternalSession[] sessions;
        for (InternalSession session : sessions = this.sessions) {
            if (session.id() != sessionId) continue;
            DebugLogger.log(LogTag.FIX_CONNECTION, this.reconnectFormatter, connectionId, (long)this.libraryId, sessionId);
            session.onReconnect(connectionId, sessionState, heartbeatIntervalInS, sequenceIndex, enableLastMsgSeqNumProcessed, fixDictionary, address, this.fixCounters);
            return session;
        }
        WeakReference reference = (WeakReference)this.sessionIdToCachedSession.remove(sessionId);
        if (reference != null) {
            InternalSession session = (InternalSession)reference.get();
            if (session != null) {
                this.insertSession(session, connectionType, sessionState);
                session.onReconnect(connectionId, sessionState, heartbeatIntervalInS, sequenceIndex, enableLastMsgSeqNumProcessed, fixDictionary, address, this.fixCounters);
            }
            return session;
        }
        return null;
    }

    private void insertSession(InternalSession session, ConnectionType connectionType, SessionState sessionState) {
        if (connectionType == ConnectionType.INITIATOR && sessionState != SessionState.ACTIVE) {
            this.pendingInitiatorSessions = (InternalSession[])ArrayUtil.add((Object[])this.pendingInitiatorSessions, (Object)session);
        } else {
            this.sessions = (InternalSession[])ArrayUtil.add((Object[])this.sessions, (Object)session);
        }
    }

    @Override
    public ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, int libraryId, long connectionId, long sessionId, int sequenceIndex, long messageType, long timestamp, MessageStatus status, int sequenceNumber, long position, int metaDataLength) {
        if (libraryId == this.libraryId) {
            DebugLogger.log(LogTag.FIX_MESSAGE, this.receivedFormatter, libraryId, buffer, offset, length);
            SessionSubscriber subscriber = (SessionSubscriber)this.connectionIdToSession.get(connectionId);
            if (subscriber != null) {
                return subscriber.onMessage(buffer, offset, length, libraryId, sequenceIndex, messageType, timestamp, status, position);
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onDisconnect(int libraryId, long connectionId, DisconnectReason reason) {
        boolean soleLibraryMode;
        DebugLogger.log(LogTag.GATEWAY_MESSAGE, this.onDisconnectFormatter, (long)libraryId, connectionId, reason.name());
        if (libraryId != this.libraryId) {
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        boolean bl = soleLibraryMode = this.initialAcceptedSessionOwner == InitialAcceptedSessionOwner.SOLE_LIBRARY;
        if (soleLibraryMode) {
            SessionSubscriber subscriber = (SessionSubscriber)this.connectionIdToSession.get(connectionId);
            if (subscriber != null) {
                return subscriber.onDisconnect(libraryId, reason);
            }
            this.onILink3Disconnect(connectionId);
        } else {
            SessionSubscriber subscriber = (SessionSubscriber)this.connectionIdToSession.remove(connectionId);
            if (subscriber != null) {
                ControlledFragmentHandler.Action action = subscriber.onDisconnect(libraryId, reason);
                if (action == ControlledFragmentHandler.Action.ABORT) {
                    this.connectionIdToSession.put(connectionId, (Object)subscriber);
                } else {
                    InternalSession session = subscriber.session();
                    session.close();
                    this.pendingInitiatorSessions = (InternalSession[])ArrayUtil.remove((Object[])this.pendingInitiatorSessions, (Object)session);
                    this.sessions = (InternalSession[])ArrayUtil.remove((Object[])this.sessions, (Object)session);
                    this.cacheSession(session);
                }
                return action;
            }
            this.onILink3Disconnect(connectionId);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void onILink3Disconnect(long connectionId) {
        ILink3Subscription subscription = (ILink3Subscription)this.connectionIdToILink3Subscription.remove(connectionId);
        if (subscription != null) {
            subscription.onDisconnect();
            this.remove(subscription.session());
        }
    }

    @Override
    public ControlledFragmentHandler.Action onILinkMessage(long connectionId, DirectBuffer buffer, int offset) {
        ILink3Subscription subscription = (ILink3Subscription)this.connectionIdToILink3Subscription.get(connectionId);
        if (subscription != null) {
            return Pressure.apply(subscription.onMessage(buffer, offset));
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onError(int libraryId, GatewayError errorType, long replyToId, String message) {
        LibraryReply reply;
        if (libraryId == this.libraryId && (reply = (LibraryReply)this.correlationIdToReply.remove(replyToId)) != null) {
            reply.onError(errorType, message);
        }
        return this.configuration.gatewayErrorHandler().onError(errorType, libraryId, message);
    }

    @Override
    public ControlledFragmentHandler.Action onApplicationHeartbeat(int libraryId) {
        if (libraryId == this.libraryId) {
            long timeInMs = this.timeInMs();
            DebugLogger.log(LogTag.APPLICATION_HEARTBEAT, this.applicationHeartbeatFormatter, (long)libraryId, timeInMs);
            this.livenessDetector.onHeartbeat(timeInMs);
            if (!this.isConnected() && this.livenessDetector.isConnected()) {
                this.state = 0;
                this.onConnect();
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onReleaseSessionReply(int libraryId, long replyToId, SessionReplyStatus status) {
        ReleaseToGatewayReply reply = (ReleaseToGatewayReply)this.correlationIdToReply.remove(replyToId);
        if (reply != null) {
            reply.onComplete(status);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onRequestSessionReply(int libraryId, long replyToId, SessionReplyStatus status) {
        RequestSessionReply reply = (RequestSessionReply)this.correlationIdToReply.remove(replyToId);
        if (reply != null) {
            reply.onComplete(status);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onFollowerSessionReply(int libraryId, long replyToId, long sessionId) {
        FollowerSessionReply reply = (FollowerSessionReply)this.correlationIdToReply.remove(replyToId);
        if (reply != null) {
            reply.onComplete(this.followerSession(sessionId, -1L, 0));
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onReplayMessagesReply(int libraryId, long replyToId, ReplayMessagesStatus status) {
        ReplayMessagesReply reply = (ReplayMessagesReply)this.correlationIdToReply.remove(replyToId);
        if (reply != null) {
            reply.onComplete(status);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onWriteMetaDataReply(int libraryId, long replyToId, MetaDataStatus status) {
        WriteMetaDataReply reply = (WriteMetaDataReply)this.correlationIdToReply.remove(replyToId);
        if (reply != null) {
            reply.onComplete(status);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onILinkConnect(int libraryId, long correlationId, long connectionId, long uuid, long lastReceivedSequenceNumber, long lastSentSequenceNumber, boolean newlyAllocated, long lastUuid) {
        InitiateILink3ConnectionReply reply;
        if (libraryId == this.libraryId && (reply = (InitiateILink3ConnectionReply)this.correlationIdToReply.remove(correlationId)) != null) {
            DebugLogger.log(LogTag.FIX_CONNECTION, this.initiatorConnectFormatter, connectionId, (long)libraryId);
            reply.onTcpConnected();
            ILink3ConnectionConfiguration configuration = reply.configuration();
            ILink3Connection connection = this.makeILink3Connection(configuration, connectionId, reply, libraryId, this, uuid, lastReceivedSequenceNumber, lastSentSequenceNumber, newlyAllocated, lastUuid);
            ILink3Subscription subscription = new ILink3Subscription(AbstractILink3Parser.make((ILink3Connection)connection, (ErrorHandler)THROW_ERRORS), connection);
            this.connectionIdToILink3Subscription.put(connectionId, (Object)subscription);
            this.iLink3Connections = (ILink3Connection[])ArrayUtil.add((Object[])this.iLink3Connections, (Object)connection);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ILink3Connection makeILink3Connection(ILink3ConnectionConfiguration configuration, long connectionId, InitiateILink3ConnectionReply initiateReply, int libraryId, LibraryPoller owner, long uuid, long lastReceivedSequenceNumber, long lastSentSequenceNumber, boolean newlyAllocated, long lastUuid) {
        try {
            Class<?> cls = Class.forName("uk.co.real_logic.artio.library.InternalILink3Connection");
            Constructor<?> constructor = cls.getConstructor(ILink3ConnectionConfiguration.class, Long.TYPE, InitiateILink3ConnectionReply.class, GatewayPublication.class, GatewayPublication.class, Integer.TYPE, LibraryPoller.class, Long.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE, Long.TYPE, EpochNanoClock.class);
            return (ILink3Connection)constructor.newInstance(configuration, connectionId, initiateReply, this.outboundPublication, this.inboundPublication, libraryId, owner, uuid, lastReceivedSequenceNumber, lastSentSequenceNumber, newlyAllocated, lastUuid, this.configuration.epochNanoClock());
        }
        catch (InvocationTargetException e) {
            LangUtil.rethrowUnchecked((Throwable)e.getTargetException());
            return null;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            LangUtil.rethrowUnchecked((Throwable)e);
            return null;
        }
    }

    @Override
    public ControlledFragmentHandler.Action onReadMetaDataReply(int libraryId, long replyToId, MetaDataStatus status, DirectBuffer srcBuffer, int srcOffset, int srcLength) {
        ReadMetaDataReply reply = (ReadMetaDataReply)this.correlationIdToReply.remove(replyToId);
        if (reply != null) {
            reply.onComplete(status, srcBuffer, srcOffset, srcLength);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onEngineClose(int libraryId) {
        if (libraryId == this.libraryId) {
            DebugLogger.log(LogTag.CLOSE, "Received engine close message, starting ENGINE_CLOSE operation");
            this.state = 5;
            this.sessionLogoutIndex = 0;
            this.attemptEngineCloseBasedLogout();
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void attemptEngineCloseBasedLogout() {
        InternalSession[] sessions = this.sessions;
        int length = sessions.length;
        int initialSessionLogoutIndex = this.sessionLogoutIndex;
        while (this.sessionLogoutIndex < length) {
            InternalSession session = sessions[this.sessionLogoutIndex];
            long position = session.state() == SessionState.ACTIVE ? session.logoutAndDisconnect() : session.requestDisconnect();
            if (position < 0L) {
                return;
            }
            ++this.sessionLogoutIndex;
        }
        if (this.sessionLogoutIndex != initialSessionLogoutIndex && length > 0) {
            DebugLogger.log(LogTag.CLOSE, "Completed logging out FIX Sessions");
        }
        if (this.iLink3LogoutIterator == null) {
            this.iLink3LogoutIterator = this.connectionIdToILink3Subscription.values().iterator();
        }
        while (this.iLink3LogoutIterator.hasNext()) {
            ILink3Subscription iLink3Subscription = this.iLink3LogoutIterator.next();
            if (!Pressure.isBackPressured(iLink3Subscription.requestDisconnect(DisconnectReason.ENGINE_SHUTDOWN))) continue;
            return;
        }
        if (!this.connectionIdToILink3Subscription.isEmpty()) {
            DebugLogger.log(LogTag.CLOSE, "Completed logging out ILink 3 Sessions");
        }
        this.state = 0;
    }

    private void validateEndOfDay() {
        if (this.isAtEndOfDay()) {
            throw new IllegalStateException("Cannot perform operation whilst end of day process is running");
        }
    }

    @Override
    public ControlledFragmentHandler.Action onControlNotification(int libraryId, InitialAcceptedSessionOwner initialAcceptedSessionOwner, ControlNotificationDecoder.SessionsDecoder sessionsDecoder) {
        if (libraryId == this.libraryId) {
            long timeInMs = this.timeInMs();
            this.livenessDetector.onHeartbeat(timeInMs);
            this.state = 0;
            this.initialAcceptedSessionOwner = initialAcceptedSessionOwner;
            DebugLogger.log(LogTag.LIBRARY_CONNECT, this.controlNotificationFormatter, (long)libraryId, timeInMs);
            this.controlUpdateILinkSessions();
            return this.controlUpdateSessions(libraryId, sessionsDecoder);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void controlUpdateILinkSessions() {
        if (this.iLink3Connections.length > 0) {
            for (ILink3Connection session : this.iLink3Connections) {
                session.unbindState();
            }
            this.iLink3Connections = new ILink3Connection[0];
        }
        this.connectionIdToILink3Subscription.clear();
    }

    private ControlledFragmentHandler.Action controlUpdateSessions(int libraryId, ControlNotificationDecoder.SessionsDecoder sessionsDecoder) {
        LongHashSet sessionIds = this.sessionIds;
        Object[] sessions = this.sessions;
        sessionIds.clear();
        while (sessionsDecoder.hasNext()) {
            sessionsDecoder.next();
            sessionIds.add(sessionsDecoder.sessionId());
        }
        int size = sessions.length;
        for (int i = 0; i < size; ++i) {
            InternalSession session = sessions[i];
            long sessionId = session.id();
            if (!sessionIds.remove(sessionId)) {
                SessionSubscriber subscriber = (SessionSubscriber)this.connectionIdToSession.remove(session.connectionId());
                if (subscriber != null) {
                    subscriber.onTimeout(libraryId);
                }
                session.close();
                sessions = (InternalSession[])ArrayUtil.remove((Object[])sessions, (int)i);
                --size;
                continue;
            }
            ++i;
        }
        this.sessions = sessions;
        if (!sessionIds.isEmpty()) {
            String msg = String.format("The gateway thinks that we own the following session ids: %s", sessionIds);
            this.configuration.gatewayErrorHandler().onError(GatewayError.UNKNOWN_SESSION, libraryId, msg);
        }
        return ControlledFragmentHandler.Action.BREAK;
    }

    @Override
    public ControlledFragmentHandler.Action onLibraryExtendPosition(int libraryId, long correlationId, int newSessionId, long stopPosition, int initialTermId, int termBufferLength, int mtuLength) {
        if (libraryId == this.libraryId && newSessionId != this.outboundPublication.id()) {
            long timeInMs;
            block3: {
                timeInMs = this.timeInMs();
                this.resetNextEngineTimer(timeInMs);
                ChannelUri channelUri = ChannelUri.parse((CharSequence)this.currentAeronChannel);
                channelUri.initialPosition(stopPosition, initialTermId, termBufferLength);
                RecordingCoordinator.setMtuLength(mtuLength, channelUri);
                channelUri.put("session-id", Integer.toString(newSessionId));
                String channel = channelUri.toString();
                DebugLogger.log(LogTag.LIBRARY_CONNECT, "Extended Library Position to: ", channel);
                try {
                    this.transport.newOutboundPublication(channel);
                }
                catch (RegistrationException e) {
                    if (e.getMessage().contains("existing publication has clashing session id")) break block3;
                    throw e;
                }
            }
            this.livenessDetector.onConnectStep(timeInMs);
            this.sendLibraryConnect(timeInMs);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onSlowStatusNotification(int libraryId, long connectionId, boolean hasBecomeSlow) {
        SessionSubscriber subscriber;
        if (libraryId == this.libraryId && (subscriber = (SessionSubscriber)this.connectionIdToSession.get(connectionId)) != null) {
            subscriber.onSlowStatusNotification(libraryId, hasBecomeSlow);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onResetLibrarySequenceNumber(int libraryId, long sessionId) {
        if (libraryId == this.libraryId) {
            for (SessionSubscriber subscriber : this.connectionIdToSession.values()) {
                InternalSession session = subscriber.session();
                if (session.id() != sessionId) continue;
                return Pressure.apply(session.tryResetSequenceNumbers());
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onReplayComplete(int libraryId, long connection) {
        if (libraryId == this.libraryId) {
            ILink3Subscription subscription = (ILink3Subscription)this.connectionIdToILink3Subscription.get(connection);
            if (subscription != null) {
                subscription.onReplayComplete();
            }
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void createSessionSubscriber(long connectionId, InternalSession session, InitiateSessionReply reply, FixDictionary fixDictionary, OnMessageInfo messageInfo, CompositeKey compositeKey) {
        MessageValidationStrategy validationStrategy = this.configuration.messageValidationStrategy();
        SessionParser parser = new SessionParser(session, validationStrategy, THROW_ERRORS, this.configuration.validateCompIdsOnEveryMessage(), this.configuration.validateTimeStrictly(), messageInfo, this.sessionIdStrategy);
        parser.sessionKey(compositeKey);
        parser.fixDictionary(fixDictionary);
        SessionSubscriber subscriber = new SessionSubscriber(messageInfo, parser, session, this.receiveTimer, this.sessionTimer, this);
        subscriber.reply(reply);
        subscriber.handler(this.configuration.sessionAcquireHandler().onSessionAcquired(session, this.sessionAcquiredInfo));
        this.connectionIdToSession.put(connectionId, (Object)subscriber);
    }

    private InitiatorSession newInitiatorSession(long connectionId, int initialSentSequenceNumber, int initialReceivedSequenceNumber, SessionState state, int sequenceIndex, boolean enableLastMsgSeqNumProcessed, FixDictionary fixDictionary, boolean resetSeqNum, OnMessageInfo messageInfo) {
        int defaultInterval = this.configuration.defaultHeartbeatIntervalInS();
        MutableAsciiBuffer asciiBuffer = this.sessionBuffer();
        SessionProxy sessionProxy = this.sessionProxy(connectionId);
        InitiatorSession session = new InitiatorSession(defaultInterval, connectionId, this.epochClock, this.configuration.epochNanoClock(), sessionProxy, this.inboundPublication, this.outboundPublication, this.sessionIdStrategy, this.configuration.sendingTimeWindowInMs(), this.fixCounters.receivedMsgSeqNo(connectionId), this.fixCounters.sentMsgSeqNo(connectionId), this.libraryId, initialSentSequenceNumber, sequenceIndex, state, resetSeqNum, this.configuration.reasonableTransmissionTimeInMs(), asciiBuffer, enableLastMsgSeqNumProcessed, this.configuration.sessionCustomisationStrategy(), messageInfo, this.epochFractionClock);
        session.fixDictionary(fixDictionary);
        session.initialLastReceivedMsgSeqNum(initialReceivedSequenceNumber - 1);
        return session;
    }

    private MutableAsciiBuffer sessionBuffer() {
        return new MutableAsciiBuffer(new byte[this.configuration.sessionBufferSize()]);
    }

    private int initiatorNewSequenceNumber(SessionConfiguration sessionConfiguration, ToIntFunction<SessionConfiguration> initialSequenceNumberGetter, int lastSequenceNumber) {
        int newSequenceNumber = lastSequenceNumber + 1;
        if (sessionConfiguration == null) {
            return newSequenceNumber;
        }
        int initialSequenceNumber = initialSequenceNumberGetter.applyAsInt(sessionConfiguration);
        if (initialSequenceNumber != -1) {
            return initialSequenceNumber;
        }
        if (sessionConfiguration.sequenceNumbersPersistent() && lastSequenceNumber != -1) {
            return newSequenceNumber;
        }
        return 1;
    }

    private InternalSession acceptSession(long connectionId, String address, SessionState state, int heartbeatIntervalInS, int sequenceIndex, boolean enableLastMsgSeqNumProcessed, FixDictionary fixDictionary, OnMessageInfo messageInfo) {
        long sendingTimeWindow = this.configuration.sendingTimeWindowInMs();
        AtomicCounter receivedMsgSeqNo = this.fixCounters.receivedMsgSeqNo(connectionId);
        AtomicCounter sentMsgSeqNo = this.fixCounters.sentMsgSeqNo(connectionId);
        MutableAsciiBuffer asciiBuffer = this.sessionBuffer();
        AcceptorSession session = new AcceptorSession(heartbeatIntervalInS, connectionId, this.epochClock, this.configuration.epochNanoClock(), this.sessionProxy(connectionId), this.inboundPublication, this.outboundPublication, this.sessionIdStrategy, sendingTimeWindow, receivedMsgSeqNo, sentMsgSeqNo, this.libraryId, 1, sequenceIndex, state, this.configuration.reasonableTransmissionTimeInMs(), asciiBuffer, enableLastMsgSeqNumProcessed, this.configuration.sessionCustomisationStrategy(), messageInfo, this.epochFractionClock);
        session.fixDictionary(fixDictionary);
        session.address(address);
        return session;
    }

    private SessionProxy sessionProxy(long connectionId) {
        return this.configuration.sessionProxyFactory().make(this.configuration.sessionBufferSize(), this.transport.outboundPublication(), this.sessionIdStrategy, this.configuration.sessionCustomisationStrategy(), (EpochClock)new SystemEpochClock(), connectionId, this.libraryId, LangUtil::rethrowUnchecked, this.configuration.sessionEpochFractionFormat());
    }

    private void checkState() {
        if (this.state != 0) {
            throw new IllegalStateException("Library has been closed or is performing end of day operation");
        }
    }

    private void closeWithParent() {
        try {
            this.fixLibrary.internalClose();
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.state != 4) {
            for (WeakReference ref : this.sessionIdToCachedSession.values()) {
                InternalSession session = (InternalSession)ref.get();
                if (session == null) continue;
                session.close();
            }
            if (this.configuration.gracefulShutdown()) {
                this.connectionIdToSession.values().forEach(subscriber -> subscriber.session().disable());
                this.state = 4;
            }
        }
    }

    public long saveInitiateILink(long correlationId, ILink3ConnectionConfiguration configuration) {
        return this.outboundPublication.saveInitiateILinkConnection(this.libraryId, configuration.port(), correlationId, configuration.reEstablishLastConnection(), configuration.host(), configuration.accessKeyId(), configuration.useBackupHost(), configuration.backupHost());
    }

    void enqueueTask(BooleanSupplier task) {
        this.tasks.add(task);
    }

    public List<ILink3Connection> iLink3Sessions() {
        return this.unmodifiableILink3Connections;
    }

    public void remove(ILink3Connection session) {
        this.iLink3Connections = (ILink3Connection[])ArrayUtil.remove((Object[])this.iLink3Connections, (Object)session);
        this.connectionIdToILink3Subscription.remove(session.connectionId());
    }
}

