/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.logbuffer.Header;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.engine.logger.FixArchiveScanner;
import uk.co.real_logic.artio.engine.logger.FixMessagePredicate;
import uk.co.real_logic.artio.engine.logger.FixMessagePredicates;
import uk.co.real_logic.artio.engine.logger.LazyILinkMessagePrinter;
import uk.co.real_logic.artio.messages.FixMessageDecoder;

public final class FixArchivePrinter {
    private String aeronDirectoryName = null;
    private String aeronChannel = null;
    private int queryStreamId = 2;
    private int archiveScannerStreamId = 5;
    private FixMessagePredicate predicate = FixMessagePredicates.alwaysTrue();
    private boolean follow = false;
    private boolean ilink = false;
    private Class<? extends FixDictionary> fixDictionaryType = null;
    private Predicate<SessionHeaderDecoder> headerPredicate = null;

    public static void main(String[] args) {
        new FixArchivePrinter().scan(args);
    }

    private void scan(String[] args) {
        this.parseArgs(args);
        this.validateArgs();
        FixArchivePrinter.scanArchive(this.aeronDirectoryName, this.aeronChannel, this.queryStreamId, this.predicate, this.follow, this.headerPredicate, this.archiveScannerStreamId, this.fixDictionaryType);
    }

    private void parseArgs(String[] args) {
        block42: for (String arg : args) {
            String optionName;
            int eqIndex = arg.indexOf(61);
            switch (optionName = eqIndex != -1 ? arg.substring(2, eqIndex) : arg.substring(2)) {
                case "help": {
                    FixArchivePrinter.printHelp();
                    System.exit(0);
                    break;
                }
                case "follow": {
                    this.follow = true;
                    break;
                }
                case "ilink": {
                    this.ilink = true;
                    break;
                }
                default: {
                    FixArchivePrinter.requiredArgument(eqIndex);
                }
            }
            String optionValue = arg.substring(eqIndex + 1);
            switch (optionName) {
                case "from": {
                    this.predicate = FixMessagePredicates.from(Long.parseLong(optionValue)).and(this.predicate);
                    continue block42;
                }
                case "to": {
                    this.predicate = FixMessagePredicates.to(Long.parseLong(optionValue)).and(this.predicate);
                    continue block42;
                }
                case "message-types": {
                    String[] messageTypes = optionValue.split(",");
                    this.predicate = FixMessagePredicates.messageTypeOf(messageTypes).and(this.predicate);
                    continue block42;
                }
                case "sender-comp-id": {
                    this.headerPredicate = FixArchivePrinter.safeAnd(this.headerPredicate, FixMessagePredicates.senderCompIdOf(optionValue));
                    continue block42;
                }
                case "target-comp-id": {
                    this.headerPredicate = FixArchivePrinter.safeAnd(this.headerPredicate, FixMessagePredicates.targetCompIdOf(optionValue));
                    continue block42;
                }
                case "sender-sub-id": {
                    this.headerPredicate = FixArchivePrinter.safeAnd(this.headerPredicate, FixMessagePredicates.senderSubIdOf(optionValue));
                    continue block42;
                }
                case "target-sub-id": {
                    this.headerPredicate = FixArchivePrinter.safeAnd(this.headerPredicate, FixMessagePredicates.targetSubIdOf(optionValue));
                    continue block42;
                }
                case "sender-location-id": {
                    this.headerPredicate = FixArchivePrinter.safeAnd(this.headerPredicate, FixMessagePredicates.senderLocationIdOf(optionValue));
                    continue block42;
                }
                case "target-location-id": {
                    this.headerPredicate = FixArchivePrinter.safeAnd(this.headerPredicate, FixMessagePredicates.targetLocationIdOf(optionValue));
                    continue block42;
                }
                case "query-stream-id": {
                    this.queryStreamId = Integer.parseInt(optionValue);
                    continue block42;
                }
                case "archive-scanner-stream-id": {
                    this.archiveScannerStreamId = Integer.parseInt(optionValue);
                    continue block42;
                }
                case "aeron-dir-name": {
                    this.aeronDirectoryName = optionValue;
                    continue block42;
                }
                case "aeron-channel": {
                    this.aeronChannel = optionValue;
                    continue block42;
                }
                case "fix-dictionary": {
                    this.fixDictionaryType = FixDictionary.find((String)optionValue);
                }
            }
        }
    }

    private void validateArgs() {
        if (this.fixDictionaryType == null && !this.ilink) {
            this.fixDictionaryType = FixDictionary.findDefault();
        }
        FixArchivePrinter.requiredArgument(this.aeronDirectoryName, "aeron-dir-name");
        FixArchivePrinter.requiredArgument(this.aeronChannel, "aeron-channel");
    }

    private static void requiredArgument(int eqIndex) {
        if (eqIndex == -1) {
            System.err.println("--ilink, --help and --follow are the only options that don't take a value");
            FixArchivePrinter.printHelp();
            System.exit(-1);
        }
    }

    private static void scanArchive(String aeronDirectoryName, String aeronChannel, int queryStreamId, FixMessagePredicate otherPredicate, boolean follow, Predicate<SessionHeaderDecoder> headerPredicate, int archiveScannerStreamId, Class<? extends FixDictionary> fixDictionaryType) {
        FixDictionary fixDictionary = fixDictionaryType == null ? null : FixDictionary.of(fixDictionaryType);
        FixMessagePredicate predicate = otherPredicate;
        if (headerPredicate != null) {
            predicate = FixMessagePredicates.whereHeader(fixDictionary, headerPredicate).and(predicate);
        }
        FixArchiveScanner.Context context = new FixArchiveScanner.Context().aeronDirectoryName(aeronDirectoryName).idleStrategy(CommonConfiguration.backoffIdleStrategy());
        try (FixArchiveScanner scanner = new FixArchiveScanner(context);){
            scanner.scan(aeronChannel, queryStreamId, FixMessagePredicates.filterBy(FixArchivePrinter::print, predicate), new LazyILinkMessagePrinter(queryStreamId), follow, archiveScannerStreamId);
        }
    }

    private static void requiredArgument(String argument, String description) {
        if (argument == null) {
            System.err.printf("Missing required --%s argument%n", description);
            FixArchivePrinter.printHelp();
            System.exit(-1);
        }
    }

    private static void printHelp() {
        System.out.println("FixArchivePrinter Options");
        System.out.println("All options are specified in the form: --optionName=optionValue");
        FixArchivePrinter.printOption("aeron-dir-name", "Specifies the directory to use for archiving, should be the same as your aeronContext.aeronDirectoryName()", true);
        FixArchivePrinter.printOption("aeron-channel", "Specifies the aeron channel that was used to by the engine", true);
        FixArchivePrinter.printOption("fix-dictionary", "The class name of the Fix Dictionary to use, default is used if this is not provided", false);
        FixArchivePrinter.printOption("ilink", "Suppresses the need to provide a fix dictionary on the classpath - used for situations where only ilink3 messages will be printed out", false);
        FixArchivePrinter.printOption("from", "Time in precision of CommonConfiguration.clock() that messages are not earlier than", false);
        FixArchivePrinter.printOption("to", "Time in precision of CommonConfiguration.clock() that messages are not later than", false);
        FixArchivePrinter.printOption("message-types", "Comma separated list of the message types (35=) that are printed", false);
        FixArchivePrinter.printOption("sender-comp-id", "Only print messages where the header's sender comp id field matches this", false);
        FixArchivePrinter.printOption("target-comp-id", "Only print messages where the header's sender comp id field matches this", false);
        FixArchivePrinter.printOption("sender-sub-id", "Only print messages where the header's sender comp id field matches this", false);
        FixArchivePrinter.printOption("target-sub-id", "Only print messages where the header's sender comp id field matches this", false);
        FixArchivePrinter.printOption("sender-location-id", "Only print messages where the header's sender comp id field matches this", false);
        FixArchivePrinter.printOption("target-location-id", "Only print messages where the header's sender comp id field matches this", false);
        FixArchivePrinter.printOption("query-stream-id", "Only print messages where the query-stream-id matches this. This should be your configuration.inboundLibraryStream() or configuration.outboundLibraryStream() Defaults to sent.", false);
        FixArchivePrinter.printOption("follow", "Continue to print out archive messages for a recording that is still in flight. defaults to off", false);
        FixArchivePrinter.printOption("help", "Only prints this help message.", false);
    }

    private static void printOption(String name, String description, boolean required) {
        System.out.printf("  --%-20s [%s] - %s%n", name, required ? "required" : "optional", description);
    }

    private static <T> Predicate<T> safeAnd(Predicate<T> left, Predicate<T> right) {
        return left == null ? right : left.and(right);
    }

    private static void print(FixMessageDecoder message, DirectBuffer buffer, int offset, int length, Header header) {
        System.out.println(message.body());
    }
}

