/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.List;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.framer.Continuation;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.LiveLibraryInfo;
import uk.co.real_logic.artio.engine.framer.ReceiverEndPoints;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.InternalSession;

class DisconnectAllOperation
implements Continuation {
    private final GatewayPublication inboundPublication;
    private final List<LiveLibraryInfo> libraries;
    private final List<GatewaySession> gatewaySessions;
    private final ReceiverEndPoints receiverEndPoints;
    private final Runnable onSuccess;
    private Step step = Step.CLOSING_NOT_LOGGED_ON_RECEIVER_END_POINTS;
    private int libraryIndex = 0;
    private int gatewaySessionIndex = 0;

    DisconnectAllOperation(GatewayPublication inboundPublication, List<LiveLibraryInfo> libraries, List<GatewaySession> gatewaySessions, ReceiverEndPoints receiverEndPoints, Runnable onSuccess) {
        this.inboundPublication = inboundPublication;
        this.libraries = libraries;
        this.gatewaySessions = gatewaySessions;
        this.receiverEndPoints = receiverEndPoints;
        this.onSuccess = onSuccess;
    }

    @Override
    public long attempt() {
        switch (this.step) {
            case CLOSING_NOT_LOGGED_ON_RECEIVER_END_POINTS: {
                this.receiverEndPoints.closeRequiredPollingEndPoints();
                DebugLogger.log(LogTag.CLOSE, "Completed CLOSING_NOT_LOGGED_ON_RECEIVER_END_POINTS");
                this.step = Step.LOGGING_OUT_LIBRARIES;
                return -2L;
            }
            case LOGGING_OUT_LIBRARIES: {
                return this.logOutLibraries();
            }
            case LOGGING_OUT_GATEWAY_SESSIONS: {
                return this.logOutGatewaySessions();
            }
            case AWAITING_DISCONNECTS: {
                return this.awaitDisconnects();
            }
        }
        return 1L;
    }

    private long logOutLibraries() {
        GatewayPublication inboundPublication = this.inboundPublication;
        List<LiveLibraryInfo> libraries = this.libraries;
        int libraryCount = libraries.size();
        while (this.libraryIndex < libraryCount) {
            LiveLibraryInfo library = libraries.get(this.libraryIndex);
            long position = inboundPublication.saveEndOfDay(library.libraryId());
            if (position < 0L) {
                return position;
            }
            ++this.libraryIndex;
        }
        DebugLogger.log(LogTag.CLOSE, "Completed LOGGING_OUT_LIBRARIES");
        this.step = Step.LOGGING_OUT_GATEWAY_SESSIONS;
        return -2L;
    }

    private long logOutGatewaySessions() {
        List<GatewaySession> gatewaySessions = this.gatewaySessions;
        int gatewaySessionCount = gatewaySessions.size();
        while (this.gatewaySessionIndex < gatewaySessionCount) {
            GatewaySession gatewaySession = gatewaySessions.get(this.gatewaySessionIndex);
            InternalSession session = gatewaySession.session();
            if (session != null) {
                SessionState state = session.state();
                switch (state) {
                    case SENT_LOGON: 
                    case ACTIVE: 
                    case AWAITING_LOGOUT: 
                    case LOGGING_OUT_AND_DISCONNECTING: 
                    case LOGGING_OUT: {
                        long position = session.logoutAndDisconnect();
                        if (position >= 0L) break;
                        return position;
                    }
                    case CONNECTED: 
                    case CONNECTING: 
                    case DISCONNECTING: {
                        long position = session.requestDisconnect();
                        if (position >= 0L) break;
                        return position;
                    }
                }
            }
            ++this.gatewaySessionIndex;
        }
        DebugLogger.log(LogTag.CLOSE, "Completed LOGGING_OUT_GATEWAY_SESSIONS");
        this.step = Step.AWAITING_DISCONNECTS;
        return -2L;
    }

    private long awaitDisconnects() {
        if (this.receiverEndPoints.size() > 0) {
            return -2L;
        }
        DebugLogger.log(LogTag.CLOSE, "Completed AWAITING_DISCONNECTS");
        this.onSuccess.run();
        return 1L;
    }

    private static enum Step {
        CLOSING_NOT_LOGGED_ON_RECEIVER_END_POINTS,
        LOGGING_OUT_LIBRARIES,
        LOGGING_OUT_GATEWAY_SESSIONS,
        AWAITING_DISCONNECTS;

    }
}

