/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import io.aeron.Aeron;
import io.aeron.archive.client.AeronArchive;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.List;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.CompositeAgent;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.errors.DistinctErrorLog;
import uk.co.real_logic.artio.CloseChecker;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.ErrorPrinter;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.MonitoringFile;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.FixEngine;
import uk.co.real_logic.artio.timing.HistogramLogAgent;
import uk.co.real_logic.artio.timing.Timer;

public abstract class GatewayProcess
implements AutoCloseable {
    public static final long NO_CORRELATION_ID = 0L;
    public static final long NO_CONNECTION_ID = -1L;
    private static final long START_TIME_IN_MS = System.currentTimeMillis();
    private DistinctErrorLog distinctErrorLog;
    protected CommonConfiguration configuration;
    protected MonitoringFile monitoringFile;
    protected FixCounters fixCounters;
    protected ErrorHandler errorHandler;
    protected Aeron aeron;
    protected Agent monitoringAgent;

    protected void init(CommonConfiguration configuration) {
        this.configuration = configuration;
        this.initMonitoring(configuration);
        this.initAeron(configuration);
    }

    protected abstract boolean shouldRethrowExceptionInErrorHandler();

    protected void initMonitoring(CommonConfiguration configuration) {
        this.monitoringFile = new MonitoringFile(true, configuration);
        SystemEpochClock clock = new SystemEpochClock();
        this.distinctErrorLog = new DistinctErrorLog(this.monitoringFile.errorBuffer(), (EpochClock)clock);
        this.errorHandler = throwable -> {
            if (!this.distinctErrorLog.record(throwable)) {
                System.err.println("Error Log is full, consider increasing aeron.error.buffer.length");
                throwable.printStackTrace();
            }
        };
    }

    protected void initAeron(CommonConfiguration configuration) {
        Aeron.Context context = this.configureAeronContext(configuration);
        this.aeron = Aeron.connect((Aeron.Context)context);
        CloseChecker.onOpen(context.aeronDirectoryName(), this.aeron);
        this.fixCounters = new FixCounters(this.aeron, this instanceof FixEngine);
    }

    public Agent conductorAgent() {
        AgentInvoker invoker = this.aeron.conductorAgentInvoker();
        if (invoker == null) {
            return null;
        }
        final Agent invokerAgent = invoker.agent();
        if (this.configuration.gracefulShutdown()) {
            return invokerAgent;
        }
        return new Agent(){

            public void onStart() {
                invokerAgent.onStart();
            }

            public int doWork() throws Exception {
                return invokerAgent.doWork();
            }

            public String roleName() {
                return invokerAgent.roleName();
            }

            public void onClose() {
            }
        };
    }

    protected Aeron.Context configureAeronContext(CommonConfiguration configuration) {
        Aeron.Context ctx = configuration.aeronContext();
        ctx.errorHandler(throwable -> {
            if (this.shouldRethrowExceptionInErrorHandler()) {
                LangUtil.rethrowUnchecked((Throwable)throwable);
            }
            if (!(throwable instanceof ClosedByInterruptException)) {
                this.errorHandler.onError(throwable);
            }
        });
        return ctx;
    }

    protected void initMonitoringAgent(List<Timer> timers, CommonConfiguration configuration, AeronArchive aeronArchive, Agent agent) {
        ArrayList<Object> agents = new ArrayList<Object>();
        if (CommonConfiguration.TIME_MESSAGES) {
            agents.add(new HistogramLogAgent(timers, configuration.histogramLoggingFile(), configuration.histogramPollPeriodInMs(), this.errorHandler, (EpochClock)new SystemEpochClock(), configuration.histogramHandler(), configuration.agentNamePrefix()));
        }
        if (configuration.printErrorMessages()) {
            agents.add(new ErrorPrinter(this.monitoringFile.errorBuffer(), configuration.agentNamePrefix(), START_TIME_IN_MS, aeronArchive, configuration.customErrorConsumer()));
        }
        if (agent != null) {
            agents.add(agent);
        }
        if (!agents.isEmpty()) {
            this.monitoringAgent = new CompositeAgent(agents);
        }
    }

    @Override
    public void close() {
        if (this.configuration.gracefulShutdown()) {
            Exceptions.closeAll((AutoCloseable[])new AutoCloseable[]{this.fixCounters, () -> {
                this.aeron.close();
                CloseChecker.onClose(this.configuration.aeronContext().aeronDirectoryName(), this.aeron);
            }, this.monitoringFile});
        } else {
            this.aeron.close();
            CloseChecker.onClose(this.configuration.aeronContext().aeronDirectoryName(), this.aeron);
            Exceptions.closeAll((AutoCloseable[])new AutoCloseable[]{this.monitoringFile});
        }
    }
}

