/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import io.aeron.Aeron;
import io.aeron.Counter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.agrona.collections.IntHashSet;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;

public class FixCounters
implements AutoCloseable {
    private static final int MINIMUM_ARTIO_TYPE_ID = 10000;
    private final List<Counter> counters = new CopyOnWriteArrayList<Counter>();
    private final AtomicCounter failedInboundPublications;
    private final AtomicCounter failedOutboundPublications;
    private final AtomicCounter failedReplayPublications;
    private final AtomicCounter currentReplayCount;
    private final Aeron aeron;

    public static IntHashSet lookupCounterIds(FixCountersId counterTypeId, CountersReader countersReader) {
        int requiredTypeId = counterTypeId.id();
        IntHashSet counterIds = new IntHashSet();
        countersReader.forEach((counterId, typeId, keyBuffer, label) -> {
            if (typeId == requiredTypeId) {
                counterIds.add(counterId);
            }
        });
        return counterIds;
    }

    FixCounters(Aeron aeron, boolean isEngine) {
        this.aeron = aeron;
        aeron.addUnavailableCounterHandler((countersReader, registrationId, counterId) -> this.counters.removeIf(counter -> counter.id() == counterId));
        this.failedInboundPublications = this.newCounter(FixCountersId.FAILED_INBOUND_TYPE_ID.id(), "Failed offer to inbound publication");
        this.failedOutboundPublications = this.newCounter(FixCountersId.FAILED_OUTBOUND_TYPE_ID.id(), "Failed offer to outbound publication");
        this.failedReplayPublications = this.newCounter(FixCountersId.FAILED_REPLAY_TYPE_ID.id(), "Failed offer to replay publication");
        this.currentReplayCount = isEngine ? this.newCounter(FixCountersId.CURRENT_REPLAY_COUNT_TYPE_ID.id(), "Current Replay Count") : null;
    }

    public AtomicCounter failedInboundPublications() {
        return this.failedInboundPublications;
    }

    public AtomicCounter failedOutboundPublications() {
        return this.failedOutboundPublications;
    }

    public AtomicCounter failedReplayPublications() {
        return this.failedReplayPublications;
    }

    public AtomicCounter currentReplayCount() {
        return this.currentReplayCount;
    }

    public AtomicCounter messagesRead(long connectionId, String address) {
        return this.newCounter(FixCountersId.MESSAGES_READ_TYPE_ID.id(), "Messages Read from " + address + " id = " + connectionId);
    }

    public AtomicCounter bytesInBuffer(long connectionId, String address) {
        return this.newCounter(FixCountersId.BYTES_IN_BUFFER_TYPE_ID.id(), "Quarantined bytes for " + address + " id = " + connectionId);
    }

    public AtomicCounter invalidLibraryAttempts(long connectionId, String address) {
        return this.newCounter(FixCountersId.INVALID_LIBRARY_ATTEMPTS_TYPE_ID.id(), "Invalid Library Attempts for " + address + " id = " + connectionId);
    }

    public AtomicCounter sentMsgSeqNo(long connectionId) {
        return this.newCounter(FixCountersId.SENT_MSG_SEQ_NO_TYPE_ID.id(), "Last Sent MsgSeqNo for " + connectionId);
    }

    public AtomicCounter receivedMsgSeqNo(long connectionId) {
        return this.newCounter(FixCountersId.RECV_MSG_SEQ_NO_TYPE_ID.id(), "Last Received MsgSeqNo for " + connectionId);
    }

    private AtomicCounter newCounter(int typeId, String label) {
        Counter counter = this.aeron.addCounter(typeId, label);
        this.counters.add(counter);
        return counter;
    }

    @Override
    public void close() {
        Exceptions.closeAll(this.counters);
    }

    public static enum FixCountersId {
        FAILED_INBOUND_TYPE_ID(10000),
        FAILED_OUTBOUND_TYPE_ID(10001),
        FAILED_REPLAY_TYPE_ID(10002),
        MESSAGES_READ_TYPE_ID(10003),
        BYTES_IN_BUFFER_TYPE_ID(10004),
        INVALID_LIBRARY_ATTEMPTS_TYPE_ID(10005),
        SENT_MSG_SEQ_NO_TYPE_ID(10006),
        RECV_MSG_SEQ_NO_TYPE_ID(10007),
        CURRENT_REPLAY_COUNT_TYPE_ID(10008);

        final int id;

        private FixCountersId(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }
}

