/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import io.aeron.Aeron;
import io.aeron.ExclusivePublication;
import io.aeron.Subscription;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.Clock;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.StreamInformation;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.protocol.Streams;

class LibraryTransport {
    private static final String OUTBOUND_PUBLICATION = "outboundPublication";
    private final LibraryConfiguration configuration;
    private final FixCounters fixCounters;
    private final Aeron aeron;
    private final Clock clock;
    private Streams outboundLibraryStreams;
    private Subscription inboundSubscription;
    private GatewayPublication outboundPublication;
    private GatewayPublication inboundPublication;

    LibraryTransport(LibraryConfiguration configuration, FixCounters fixCounters, Aeron aeron) {
        this.configuration = configuration;
        this.fixCounters = fixCounters;
        this.aeron = aeron;
        this.clock = configuration.clock();
    }

    void initStreams(String aeronChannel) {
        DebugLogger.log(LogTag.LIBRARY_CONNECT, "Directed streams at ", aeronChannel);
        int inboundLibraryStream = this.configuration.inboundLibraryStream();
        int outboundLibraryStream = this.configuration.outboundLibraryStream();
        boolean printAeronStreamIdentifiers = this.configuration.printAeronStreamIdentifiers();
        IdleStrategy idleStrategy = this.configuration.libraryIdleStrategy();
        this.outboundLibraryStreams = new Streams(this.aeron, aeronChannel, printAeronStreamIdentifiers, this.fixCounters.failedOutboundPublications(), outboundLibraryStream, this.clock, this.configuration.outboundMaxClaimAttempts(), null);
        if (this.isReconnect()) {
            this.inboundSubscription.close();
            this.outboundPublication.close();
            this.inboundPublication.close();
        }
        this.inboundSubscription = this.aeron.addSubscription(aeronChannel, inboundLibraryStream);
        StreamInformation.print("library " + this.configuration.libraryId() + " inboundSubscription", this.inboundSubscription, this.configuration);
        this.outboundPublication = this.outboundLibraryStreams.gatewayPublication(idleStrategy, this.outboundDataPublication(aeronChannel));
        ExclusivePublication publication = this.aeron.addExclusivePublication(aeronChannel, inboundLibraryStream);
        StreamInformation.print("inboundPublication", publication, printAeronStreamIdentifiers);
        this.inboundPublication = new GatewayPublication(publication, this.fixCounters.failedInboundPublications(), idleStrategy, this.clock, this.configuration.inboundMaxClaimAttempts());
    }

    void newOutboundPublication(String aeronChannel) {
        this.outboundPublication.dataPublication(this.outboundDataPublication(aeronChannel));
    }

    private ExclusivePublication outboundDataPublication(String aeronChannel) {
        int outboundLibraryStream = this.configuration.outboundLibraryStream();
        boolean printAeronStreamIdentifiers = this.configuration.printAeronStreamIdentifiers();
        ExclusivePublication outboundData = this.aeron.addExclusivePublication(aeronChannel, outboundLibraryStream);
        StreamInformation.print(OUTBOUND_PUBLICATION, outboundData, printAeronStreamIdentifiers);
        return outboundData;
    }

    Subscription inboundSubscription() {
        return this.inboundSubscription;
    }

    GatewayPublication outboundPublication() {
        return this.outboundPublication;
    }

    GatewayPublication inboundPublication() {
        return this.inboundPublication;
    }

    boolean isReconnect() {
        return this.inboundSubscription != null;
    }
}

