/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.engine.logger.FixMessageConsumer;
import uk.co.real_logic.artio.ilink.ILinkMessageConsumer;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;

class LogEntryHandler
implements FragmentHandler {
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final FixMessageDecoder fixMessage = new FixMessageDecoder();
    private final FixMessageConsumer fixHandler;
    private final ILinkMessageConsumer iLinkHandler;

    LogEntryHandler(FixMessageConsumer fixHandler, ILinkMessageConsumer iLinkHandler) {
        this.fixHandler = fixHandler;
        this.iLinkHandler = iLinkHandler;
    }

    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeader.wrap(buffer, offset);
        int templateId = this.messageHeader.templateId();
        if (templateId == 1) {
            int version = this.messageHeader.version();
            this.fixMessage.wrap(buffer, offset += 8, this.messageHeader.blockLength(), version);
            if (version >= FixMessageDecoder.metaDataSinceVersion()) {
                offset += FixMessageDecoder.metaDataHeaderLength() + this.fixMessage.metaDataLength();
                this.fixMessage.skipMetaData();
            }
            this.fixHandler.onMessage(this.fixMessage, buffer, offset, length, header);
        } else if (templateId == 58) {
            offset += 8;
            this.iLinkHandler.onBusinessMessage(buffer, offset += 8, header);
        }
    }
}

