/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.logbuffer.Header;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.collections.Long2LongHashMap;
import uk.co.real_logic.artio.engine.logger.ILinkSequenceNumberHandler;
import uk.co.real_logic.artio.ilink.AbstractILink3Offsets;
import uk.co.real_logic.artio.ilink.AbstractILink3Parser;
import uk.co.real_logic.artio.messages.ILinkConnectDecoder;
import uk.co.real_logic.artio.messages.ILinkMessageDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;

class ILinkSequenceNumberExtractor {
    private final Long2LongHashMap connectionIdToILinkUuid;
    private final ErrorHandler errorHandler;
    private final ILinkSequenceNumberHandler handler;
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final ILinkMessageDecoder iLinkMessage = new ILinkMessageDecoder();
    private final ILinkConnectDecoder iLinkConnect = new ILinkConnectDecoder();
    private AbstractILink3Offsets offsets;
    private AbstractILink3Parser parser;
    private boolean attemptedILinkInit = false;

    ILinkSequenceNumberExtractor(Long2LongHashMap connectionIdToILinkUuid, ErrorHandler errorHandler, ILinkSequenceNumberHandler handler) {
        this.connectionIdToILinkUuid = connectionIdToILinkUuid;
        this.errorHandler = errorHandler;
        this.handler = handler;
    }

    public void onFragment(DirectBuffer buffer, int srcOffset, int srcLength, Header header) {
        long endPosition = header.position();
        if ((header.flags() & 0xC0) == 192) {
            int offset = srcOffset;
            this.messageHeader.wrap(buffer, offset);
            offset += this.messageHeader.encodedLength();
            int actingBlockLength = this.messageHeader.blockLength();
            int version = this.messageHeader.version();
            int templateId = this.messageHeader.templateId();
            switch (templateId) {
                case 58: {
                    int totalLength = BitUtil.align((int)srcLength, (int)32);
                    this.onILinkMessage(buffer, endPosition, offset, actingBlockLength, version, totalLength, header.sessionId());
                    break;
                }
                case 57: {
                    this.iLinkConnect.wrap(buffer, offset, actingBlockLength, version);
                    this.connectionIdToILinkUuid.put(this.iLinkConnect.connection(), this.iLinkConnect.uuid());
                }
            }
        }
    }

    private void onILinkMessage(DirectBuffer buffer, long endPosition, int offset, int actingBlockLength, int version, int totalLength, int aeronSessionId) {
        long uuid;
        if (!this.attemptedILinkInit) {
            this.attemptedILinkInit = true;
            this.parser = AbstractILink3Parser.make(null, (ErrorHandler)this.errorHandler);
            this.offsets = AbstractILink3Offsets.make((ErrorHandler)this.errorHandler);
            if (this.parser == null || this.offsets == null) {
                this.errorHandler.onError((Throwable)new IllegalStateException("Configuration Issue: could not find ILink3Codes on the Engine classpath, despite ILink3 message requiring processing. Sequence Index update ignored"));
                return;
            }
        }
        this.iLinkMessage.wrap(buffer, offset, actingBlockLength, version);
        long connectionId = this.iLinkMessage.connection();
        int sofhOffset = offset + 8;
        int headerOffset = sofhOffset + 4;
        int templateId = this.parser.templateId(buffer, headerOffset);
        int messageOffset = headerOffset + 8;
        int possRetrans = this.offsets.possRetrans(templateId, buffer, messageOffset);
        if (possRetrans == 1) {
            return;
        }
        int seqNum = this.offsets.seqNum(templateId, buffer, messageOffset);
        if (seqNum != -1 && (uuid = this.connectionIdToILinkUuid.get(connectionId)) != -1L) {
            this.handler.onSequenceNumber(seqNum, uuid, totalLength, endPosition, aeronSessionId);
        }
    }
}

