/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Aeron;
import io.aeron.FragmentAssembler;
import io.aeron.Subscription;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.engine.logger.FixMessageConsumer;
import uk.co.real_logic.artio.engine.logger.LazyILinkMessagePrinter;
import uk.co.real_logic.artio.engine.logger.LogEntryHandler;
import uk.co.real_logic.artio.messages.FixMessageDecoder;

public class FixMessageLogger
implements Agent {
    private final Aeron aeron;
    private final Subscription outboundSubscription;
    private final Subscription inboundSubscription;
    private final Subscription replaySubscription;
    private final FragmentAssembler fragmentAssembler;

    public static void main(String[] args) {
        FixMessageLogger logger = new FixMessageLogger(FixMessageLogger::print, new Aeron.Context(), "aeron:ipc", 1, 2, 3);
        AgentRunner runner = new AgentRunner(CommonConfiguration.backoffIdleStrategy(), Throwable::printStackTrace, null, (Agent)logger);
        AgentRunner.startOnThread((AgentRunner)runner);
    }

    private static void print(FixMessageDecoder fixMessageDecoder, DirectBuffer buffer, int offset, int length, Header header) {
        System.out.printf("%s: %s%n", fixMessageDecoder.status(), fixMessageDecoder.body());
    }

    public FixMessageLogger(FixMessageConsumer fixMessageConsumer, Aeron.Context context, String libraryAeronChannel, int inboundStreamId, int outboundStreamId, int outboundReplayStreamId) {
        this.aeron = Aeron.connect((Aeron.Context)context);
        this.inboundSubscription = this.aeron.addSubscription(libraryAeronChannel, inboundStreamId);
        this.outboundSubscription = this.aeron.addSubscription(libraryAeronChannel, outboundStreamId);
        this.replaySubscription = this.aeron.addSubscription(libraryAeronChannel, outboundReplayStreamId);
        LogEntryHandler logEntryHandler = new LogEntryHandler(fixMessageConsumer, new LazyILinkMessagePrinter(inboundStreamId));
        this.fragmentAssembler = new FragmentAssembler((FragmentHandler)logEntryHandler);
    }

    public int doWork() {
        return this.inboundSubscription.poll((FragmentHandler)this.fragmentAssembler, 10) + this.outboundSubscription.poll((FragmentHandler)this.fragmentAssembler, 10) + this.replaySubscription.poll((FragmentHandler)this.fragmentAssembler, 10);
    }

    public void onClose() {
        this.aeron.close();
    }

    public String roleName() {
        return "FixMessageLogger";
    }
}

