/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Aeron;
import io.aeron.FragmentAssembler;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.logbuffer.FragmentHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.engine.logger.FixMessageConsumer;
import uk.co.real_logic.artio.engine.logger.LogEntryHandler;
import uk.co.real_logic.artio.ilink.ILinkMessageConsumer;

public class FixArchiveScanner
implements AutoCloseable {
    private final Aeron aeron;
    private final AeronArchive aeronArchive;
    private final IdleStrategy idleStrategy;

    public FixArchiveScanner(Context context) {
        this.idleStrategy = context.idleStrategy();
        Aeron.Context aeronContext = new Aeron.Context().aeronDirectoryName(context.aeronDirectoryName());
        this.aeron = Aeron.connect((Aeron.Context)aeronContext);
        this.aeronArchive = AeronArchive.connect((AeronArchive.Context)new AeronArchive.Context().aeron(this.aeron).ownsAeronClient(true));
    }

    public void scan(String aeronChannel, int queryStreamId, FixMessageConsumer fixHandler, ILinkMessageConsumer iLinkHandler, boolean follow, int archiveScannerStreamId) {
        LogEntryHandler logEntryHandler = new LogEntryHandler(fixHandler, iLinkHandler);
        FragmentAssembler fragmentAssembler = new FragmentAssembler((FragmentHandler)logEntryHandler);
        List<ArchiveLocation> archiveLocations = this.lookupArchiveLocations(aeronChannel, queryStreamId);
        try (Subscription replaySubscription = this.aeron.addSubscription("aeron:ipc", archiveScannerStreamId);){
            archiveLocations.forEach(archiveLocation -> {
                long stopPosition;
                long length;
                boolean stillArchiving;
                long recordingId = archiveLocation.recordingId;
                boolean bl = stillArchiving = archiveLocation.stopPosition == -1L;
                if (stillArchiving) {
                    if (follow) {
                        length = -1L;
                        stopPosition = -1L;
                    } else {
                        stopPosition = this.aeronArchive.getRecordingPosition(recordingId);
                        length = stopPosition - archiveLocation.startPosition;
                    }
                } else {
                    stopPosition = archiveLocation.stopPosition;
                    length = stopPosition - archiveLocation.startPosition;
                }
                if (length != 0L) {
                    int sessionId = (int)this.aeronArchive.startReplay(recordingId, archiveLocation.startPosition, length, "aeron:ipc", archiveScannerStreamId);
                    Image image = this.lookupImage(replaySubscription, sessionId);
                    while (stopPosition == -1L || image.position() < stopPosition) {
                        this.idleStrategy.idle(image.poll((FragmentHandler)fragmentAssembler, 10));
                    }
                }
            });
        }
    }

    public void scan(String aeronChannel, int queryStreamId, FixMessageConsumer handler, boolean follow, int archiveScannerStreamId) {
        this.scan(aeronChannel, queryStreamId, handler, null, follow, archiveScannerStreamId);
    }

    private Image lookupImage(Subscription replaySubscription, int sessionId) {
        Image image = null;
        while (image == null) {
            this.idleStrategy.idle();
            image = replaySubscription.imageBySessionId(sessionId);
        }
        this.idleStrategy.reset();
        return image;
    }

    private List<ArchiveLocation> lookupArchiveLocations(String aeronChannel, int queryStreamId) {
        ArrayList<ArchiveLocation> archiveLocations = new ArrayList<ArchiveLocation>();
        this.aeronArchive.listRecordingsForUri(0L, Integer.MAX_VALUE, aeronChannel, queryStreamId, (controlSessionId, correlationId, recordingId, startTimestamp, stopTimestamp, startPosition, stopPosition, initialTermId, segmentFileLength, termBufferLength, mtuLength, sessionId, streamId, strippedChannel, originalChannel, sourceIdentity) -> archiveLocations.add(new ArchiveLocation(recordingId, startPosition, stopPosition)));
        archiveLocations.sort(Comparator.comparingLong(ArchiveLocation::stopPosition).reversed());
        return archiveLocations;
    }

    @Override
    public void close() {
        this.aeronArchive.close();
    }

    static class ArchiveLocation {
        final long recordingId;
        final long startPosition;
        final long stopPosition;

        ArchiveLocation(long recordingId, long startPosition, long stopPosition) {
            this.recordingId = recordingId;
            this.startPosition = startPosition;
            this.stopPosition = stopPosition;
        }

        public long stopPosition() {
            return this.stopPosition;
        }

        public String toString() {
            return "ArchiveReplayInfo{recordingId=" + this.recordingId + ", startPosition=" + this.startPosition + ", stopPosition=" + this.stopPosition + '}';
        }
    }

    public static class Context {
        private String aeronDirectoryName;
        private IdleStrategy idleStrategy;

        public Context aeronDirectoryName(String aeronDirectoryName) {
            this.aeronDirectoryName = aeronDirectoryName;
            return this;
        }

        public String aeronDirectoryName() {
            return this.aeronDirectoryName;
        }

        public Context idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }
    }
}

