/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.function.LongToIntFunction;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.collections.Long2ObjectHashMap;
import uk.co.real_logic.artio.engine.framer.SenderEndPoint;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;

class SenderEndPoints
implements AutoCloseable,
ControlledFragmentHandler {
    private static final int HEADER_LENGTH = 8;
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final FixMessageDecoder fixMessage = new FixMessageDecoder();
    private final Long2ObjectHashMap<SenderEndPoint> connectionIdToSenderEndpoint = new Long2ObjectHashMap();
    private final ErrorHandler errorHandler;
    private final LongToIntFunction libraryLookup = this::libraryLookup;
    private long timeInMs;

    private int libraryLookup(long sessionId) {
        for (SenderEndPoint senderEndPoint : this.connectionIdToSenderEndpoint.values()) {
            if (senderEndPoint.sessionId() != sessionId) continue;
            return senderEndPoint.libraryId();
        }
        return 0;
    }

    SenderEndPoints(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void add(SenderEndPoint senderEndPoint) {
        this.connectionIdToSenderEndpoint.put(senderEndPoint.connectionId(), (Object)senderEndPoint);
    }

    void removeConnection(long connectionId) {
        SenderEndPoint senderEndPoint = (SenderEndPoint)this.connectionIdToSenderEndpoint.remove(connectionId);
        if (senderEndPoint != null) {
            senderEndPoint.close();
        }
    }

    boolean onMessage(int libraryId, long connectionId, DirectBuffer buffer, int offset, int length, int sequenceNumber, long position) {
        SenderEndPoint endPoint = (SenderEndPoint)this.connectionIdToSenderEndpoint.get(connectionId);
        if (endPoint != null) {
            endPoint.onOutboundMessage(libraryId, buffer, offset, length, sequenceNumber, position, this.timeInMs);
            return true;
        }
        return false;
    }

    ControlledFragmentHandler.Action onReplayMessage(long connectionId, DirectBuffer buffer, int offset, int length, long position) {
        SenderEndPoint endPoint = (SenderEndPoint)this.connectionIdToSenderEndpoint.get(connectionId);
        if (endPoint != null) {
            return endPoint.onReplayMessage(buffer, offset, length, this.timeInMs, position);
        }
        this.logReplayError(connectionId, buffer, offset, length);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    ControlledFragmentHandler.Action onSlowReplayMessage(long connectionId, DirectBuffer buffer, int offset, int length, long position, int metaDataLength) {
        SenderEndPoint endPoint = (SenderEndPoint)this.connectionIdToSenderEndpoint.get(connectionId);
        if (endPoint != null) {
            return endPoint.onSlowReplayMessage(buffer, offset, length, this.timeInMs, position, metaDataLength);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void logReplayError(long connectionId, DirectBuffer buffer, int offset, int length) {
        this.errorHandler.onError((Throwable)new IllegalArgumentException(String.format("Failed to replay message on conn=%1$d [%2$s], this probably indicates the connection has disconnected from Artio whilst this message was in the process of being replayed", connectionId, buffer.getStringWithoutLengthUtf8(offset, length))));
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        return this.onSlowConsumerMessageFragment(buffer, offset, length, header.position());
    }

    private ControlledFragmentHandler.Action onSlowConsumerMessageFragment(DirectBuffer buffer, int offset, int length, long position) {
        this.messageHeader.wrap(buffer, offset);
        if (this.messageHeader.templateId() == 1) {
            int version = this.messageHeader.version();
            this.fixMessage.wrap(buffer, offset += 8, this.messageHeader.blockLength(), version);
            long connectionId = this.fixMessage.connection();
            SenderEndPoint senderEndPoint = (SenderEndPoint)this.connectionIdToSenderEndpoint.get(connectionId);
            if (senderEndPoint != null) {
                int metaDataLength = this.fixMessage.skipMetaData();
                int bodyLength = this.fixMessage.bodyLength();
                int libraryId = this.fixMessage.libraryId();
                int sequenceNumber = this.fixMessage.sequenceNumber();
                return senderEndPoint.onSlowOutboundMessage(buffer, offset, length - 8, position, bodyLength, libraryId, this.timeInMs, metaDataLength, sequenceNumber);
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    ControlledFragmentHandler.Action onReplayComplete(long connectionId) {
        SenderEndPoint senderEndPoint = (SenderEndPoint)this.connectionIdToSenderEndpoint.get(connectionId);
        if (senderEndPoint != null) {
            return senderEndPoint.onReplayComplete();
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public void close() {
        this.connectionIdToSenderEndpoint.values().forEach(SenderEndPoint::close);
    }

    void timeInMs(long timeInMs) {
        this.timeInMs = timeInMs;
    }

    int checkTimeouts(long timeInMs) {
        int count = 0;
        for (SenderEndPoint senderEndPoint : this.connectionIdToSenderEndpoint.values()) {
            if (!senderEndPoint.checkTimeouts(timeInMs)) continue;
            ++count;
        }
        return count;
    }

    public LongToIntFunction libraryLookup() {
        return this.libraryLookup;
    }
}

