/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.ExclusivePublication;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.ByteBufferUtil;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.ILink3Context;
import uk.co.real_logic.artio.engine.framer.ReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.ilink.SimpleOpenFramingHeader;
import uk.co.real_logic.artio.messages.ILinkMessageEncoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.protocol.GatewayPublication;

class ILink3ReceiverEndPoint
extends ReceiverEndPoint {
    public static final int ARTIO_HEADER_LENGTH = 16;
    private final UnsafeBuffer headerBuffer = new UnsafeBuffer(new byte[16]);
    private final ExclusivePublication inboundPublication;
    private final boolean isBackup;
    private final ILink3Context context;

    ILink3ReceiverEndPoint(long connectionId, TcpChannel channel, int bufferSize, ErrorHandler errorHandler, Framer framer, GatewayPublication publication, int libraryId, boolean isBackup, ILink3Context context) {
        super(publication, channel, connectionId, bufferSize, errorHandler, framer, libraryId);
        this.inboundPublication = publication.dataPublication();
        this.isBackup = isBackup;
        this.context = context;
        this.makeHeader();
    }

    private void makeHeader() {
        ILinkMessageEncoder iLinkMessage = new ILinkMessageEncoder();
        MessageHeaderEncoder header = new MessageHeaderEncoder();
        iLinkMessage.wrapAndApplyHeader((MutableDirectBuffer)this.headerBuffer, 0, header).connection(this.connectionId);
    }

    @Override
    void removeEndpointFromFramer() {
        this.trackDisconnect();
        this.framer.onILink3Disconnect(this.connectionId, null);
    }

    private void trackDisconnect() {
        if (this.isBackup) {
            this.context.backupConnected(false);
        } else {
            this.context.primaryConnected(false);
        }
    }

    @Override
    void disconnectContext() {
    }

    @Override
    boolean retryFrameMessages() {
        return this.frameMessages();
    }

    private int readData() throws IOException {
        int dataRead = this.channel.read(this.byteBuffer);
        if (dataRead != -1) {
            if (dataRead > 0) {
                DebugLogger.logBytes(LogTag.FIX_MESSAGE_TCP, "Read     ", this.byteBuffer, this.usedBufferData, dataRead);
            }
            this.usedBufferData += dataRead;
        } else {
            this.onDisconnectDetected();
        }
        return dataRead;
    }

    @Override
    int poll() {
        try {
            int bytesRead = this.readData();
            if (bytesRead > 0 && !this.frameMessages()) {
                return -bytesRead;
            }
            return bytesRead;
        }
        catch (ClosedChannelException ex) {
            this.onDisconnectDetected();
            return 1;
        }
        catch (Exception ex) {
            if (!Exceptions.isJustDisconnect((Exception)ex)) {
                this.errorHandler.onError((Throwable)ex);
            }
            this.onDisconnectDetected();
            return 1;
        }
    }

    private boolean frameMessages() {
        int offset = 0;
        while (this.usedBufferData > 4) {
            int messageSize = SimpleOpenFramingHeader.readSofh((DirectBuffer)this.buffer, (int)offset);
            if (messageSize > this.usedBufferData) {
                this.moveRemainingDataToBufferStart(offset);
                return true;
            }
            long position = this.inboundPublication.offer((DirectBuffer)this.headerBuffer, 0, 16, (DirectBuffer)this.buffer, offset, messageSize);
            if (position < 0L) {
                this.moveRemainingDataToBufferStart(offset);
                return false;
            }
            this.usedBufferData -= messageSize;
            offset += messageSize;
        }
        this.moveRemainingDataToBufferStart(offset);
        return true;
    }

    private void moveRemainingDataToBufferStart(int offset) {
        if (this.usedBufferData > 0) {
            this.buffer.putBytes(0, (DirectBuffer)this.buffer, offset, this.usedBufferData);
        }
        ByteBufferUtil.position(this.byteBuffer, this.usedBufferData);
    }

    @Override
    boolean requiresAuthentication() {
        return false;
    }

    @Override
    void closeResources() {
        this.trackDisconnect();
        try {
            this.channel.close();
        }
        catch (Exception ex) {
            this.errorHandler.onError((Throwable)ex);
        }
    }
}

