/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import org.agrona.ErrorHandler;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.MessageTimingHandler;
import uk.co.real_logic.artio.engine.SenderSequenceNumbers;
import uk.co.real_logic.artio.engine.framer.BlockablePosition;
import uk.co.real_logic.artio.engine.framer.FixReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.GatewaySessions;
import uk.co.real_logic.artio.engine.framer.SenderEndPoint;
import uk.co.real_logic.artio.engine.framer.SessionContexts;
import uk.co.real_logic.artio.engine.framer.SlowPeeker;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.protocol.GatewayPublication;

class EndPointFactory {
    private final FixReceiverEndPoint.FixReceiverEndPointFormatters formatters = new FixReceiverEndPoint.FixReceiverEndPointFormatters();
    private final EngineConfiguration configuration;
    private final SessionContexts sessionContexts;
    private final GatewayPublication inboundLibraryPublication;
    private final FixCounters fixCounters;
    private final ErrorHandler errorHandler;
    private final GatewaySessions gatewaySessions;
    private final SenderSequenceNumbers senderSequenceNumbers;
    private final MessageTimingHandler messageTimingHandler;
    private SlowPeeker replaySlowPeeker;

    EndPointFactory(EngineConfiguration configuration, SessionContexts sessionContexts, GatewayPublication inboundLibraryPublication, FixCounters fixCounters, ErrorHandler errorHandler, GatewaySessions gatewaySessions, SenderSequenceNumbers senderSequenceNumbers, MessageTimingHandler messageTimingHandler) {
        this.configuration = configuration;
        this.sessionContexts = sessionContexts;
        this.inboundLibraryPublication = inboundLibraryPublication;
        this.fixCounters = fixCounters;
        this.errorHandler = errorHandler;
        this.gatewaySessions = gatewaySessions;
        this.senderSequenceNumbers = senderSequenceNumbers;
        this.messageTimingHandler = messageTimingHandler;
    }

    FixReceiverEndPoint receiverEndPoint(TcpChannel channel, long connectionId, long sessionId, int sequenceIndex, int libraryId, Framer framer) {
        return new FixReceiverEndPoint(channel, this.configuration.receiverBufferSize(), this.inboundLibraryPublication, connectionId, sessionId, sequenceIndex, this.sessionContexts, this.fixCounters.messagesRead(connectionId, channel.remoteAddress()), framer, this.errorHandler, libraryId, this.gatewaySessions, this.configuration.clock(), framer.acceptorFixDictionaryLookup(), this.formatters);
    }

    SenderEndPoint senderEndPoint(TcpChannel channel, long connectionId, int libraryId, BlockablePosition libraryBlockablePosition, Framer framer) {
        String remoteAddress = channel.remoteAddress();
        AtomicCounter bytesInBuffer = this.fixCounters.bytesInBuffer(connectionId, remoteAddress);
        return new SenderEndPoint(connectionId, libraryId, libraryBlockablePosition, this.replaySlowPeeker, channel, bytesInBuffer, this.fixCounters.invalidLibraryAttempts(connectionId, remoteAddress), this.errorHandler, framer, this.configuration.senderMaxBytesInBuffer(), this.configuration.slowConsumerTimeoutInMs(), System.currentTimeMillis(), this.senderSequenceNumbers.onNewSender(connectionId, bytesInBuffer), this.messageTimingHandler);
    }

    void replaySlowPeeker(SlowPeeker replaySlowPeeker) {
        this.replaySlowPeeker = replaySlowPeeker;
    }
}

