/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import uk.co.real_logic.artio.FixGatewayException;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.library.LibraryPoller;
import uk.co.real_logic.artio.messages.GatewayError;

abstract class LibraryReply<T>
implements Reply<T> {
    final LibraryPoller libraryPoller;
    private final long latestReplyArrivalTimeInMs;
    boolean requiresResend;
    long correlationId;
    private Exception error;
    private T result;
    private Reply.State state = Reply.State.EXECUTING;

    LibraryReply(LibraryPoller libraryPoller, long latestReplyArrivalTimeInMs) {
        this.libraryPoller = libraryPoller;
        this.latestReplyArrivalTimeInMs = latestReplyArrivalTimeInMs;
        if (libraryPoller.isConnected()) {
            this.register();
        } else {
            this.onError(new FixGatewayException("Not connected to the Gateway"));
        }
    }

    protected abstract void sendMessage();

    protected void register() {
        this.correlationId = this.libraryPoller.register(this);
    }

    @Override
    public Exception error() {
        return this.error;
    }

    @Override
    public T resultIfPresent() {
        return this.result;
    }

    @Override
    public Reply.State state() {
        return this.state;
    }

    void onComplete(T result) {
        this.result = result;
        this.state = Reply.State.COMPLETED;
    }

    void onError(Exception error) {
        this.error = error;
        this.state = Reply.State.ERRORED;
    }

    void onError(GatewayError errorType, String errorMessage) {
    }

    protected boolean onTimeout() {
        this.state = Reply.State.TIMED_OUT;
        return true;
    }

    boolean poll(long timeInMs) {
        if (this.requiresResend) {
            this.sendMessage();
        }
        if (timeInMs >= this.latestReplyArrivalTimeInMs) {
            return this.onTimeout();
        }
        if (!this.isExecuting()) {
            return false;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{latestReplyArrivalTimeInMs=" + this.latestReplyArrivalTimeInMs + ", error=" + this.error + ", result=" + this.result + ", state=" + (Object)((Object)this.state) + '}';
    }
}

