/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import java.util.ArrayList;
import java.util.List;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.SessionExistsHandler;
import uk.co.real_logic.artio.messages.SessionReplyStatus;

public class AcquiringSessionExistsHandler
implements SessionExistsHandler {
    private final List<RequestInfo> requests = new ArrayList<RequestInfo>();
    private final boolean printRequests;

    public AcquiringSessionExistsHandler() {
        this(false);
    }

    public AcquiringSessionExistsHandler(boolean printRequests) {
        this.printRequests = printRequests;
    }

    public List<RequestInfo> requests() {
        return this.requests;
    }

    @Override
    public void onSessionExists(FixLibrary library, long surrogateSessionId, String localCompId, String localSubId, String localLocationId, String remoteCompId, String remoteSubId, String remoteLocationId) {
        Reply<SessionReplyStatus> reply = library.requestSession(surrogateSessionId, -1, -1, 10000L);
        RequestInfo requestInfo = new RequestInfo(surrogateSessionId, reply, localCompId, localSubId, localLocationId, remoteCompId);
        if (this.printRequests) {
            System.out.println(requestInfo);
        }
        this.requests.add(requestInfo);
    }

    public static final class RequestInfo {
        private final long connectionId;
        private final Reply<SessionReplyStatus> reply;
        private final String senderCompId;
        private final String senderSubId;
        private final String senderLocationId;
        private final String targetCompId;

        private RequestInfo(long connectionId, Reply<SessionReplyStatus> reply, String senderCompId, String senderSubId, String senderLocationId, String targetCompId) {
            this.connectionId = connectionId;
            this.reply = reply;
            this.senderCompId = senderCompId;
            this.senderSubId = senderSubId;
            this.senderLocationId = senderLocationId;
            this.targetCompId = targetCompId;
        }

        public Reply<SessionReplyStatus> reply() {
            return this.reply;
        }

        public long connectionId() {
            return this.connectionId;
        }

        public String senderCompId() {
            return this.senderCompId;
        }

        public String senderSubId() {
            return this.senderSubId;
        }

        public String senderLocationId() {
            return this.senderLocationId;
        }

        public String targetCompId() {
            return this.targetCompId;
        }

        public String toString() {
            return "RequestInfo{connectionId=" + this.connectionId + ", reply=" + this.reply + ", senderCompId='" + this.senderCompId + '\'' + ", senderSubId='" + this.senderSubId + '\'' + ", senderLocationId='" + this.senderLocationId + '\'' + ", targetCompId='" + this.targetCompId + '\'' + '}';
        }
    }
}

