/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.logbuffer.Header;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import uk.co.real_logic.artio.engine.ChecksumFramer;
import uk.co.real_logic.artio.engine.MappedFile;
import uk.co.real_logic.artio.engine.SequenceNumberExtractor;
import uk.co.real_logic.artio.engine.logger.Index;
import uk.co.real_logic.artio.engine.logger.IndexedPositionConsumer;
import uk.co.real_logic.artio.engine.logger.IndexedPositionReader;
import uk.co.real_logic.artio.engine.logger.IndexedPositionWriter;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;
import uk.co.real_logic.artio.engine.logger.RecordingIdLookup;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexDescriptor;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.messages.ResetSequenceNumberDecoder;
import uk.co.real_logic.artio.storage.messages.LastKnownSequenceNumberDecoder;
import uk.co.real_logic.artio.storage.messages.LastKnownSequenceNumberEncoder;

public class SequenceNumberIndexWriter
implements Index {
    private static final boolean RUNNING_ON_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static final long MISSING_RECORD = -1L;
    private static final long UNINITIALISED = -1L;
    static final int SEQUENCE_NUMBER_OFFSET = 8;
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final FixMessageDecoder messageFrame = new FixMessageDecoder();
    private final ResetSequenceNumberDecoder resetSequenceNumber = new ResetSequenceNumberDecoder();
    private final MessageHeaderDecoder fileHeaderDecoder = new MessageHeaderDecoder();
    private final MessageHeaderEncoder fileHeaderEncoder = new MessageHeaderEncoder();
    private final LastKnownSequenceNumberEncoder lastKnownEncoder = new LastKnownSequenceNumberEncoder();
    private final LastKnownSequenceNumberDecoder lastKnownDecoder = new LastKnownSequenceNumberDecoder();
    private final Long2LongHashMap recordOffsets = new Long2LongHashMap(-1L);
    private final SequenceNumberExtractor sequenceNumberExtractor;
    private final ChecksumFramer checksumFramer;
    private final AtomicBuffer inMemoryBuffer;
    private final ErrorHandler errorHandler;
    private final Path indexPath;
    private final Path writablePath;
    private final Path passingPlacePath;
    private final int fileCapacity;
    private final RecordingIdLookup recordingIdLookup;
    private final int streamId;
    private final int indexedPositionsOffset;
    private final IndexedPositionWriter positions;
    private MappedFile writableFile;
    private MappedFile indexFile;
    private long nextRollPosition = -1L;
    private final EpochClock clock;
    private final long indexFileStateFlushTimeoutInMs;
    private long lastUpdatedFileTimeInMs;
    private boolean hasSavedRecordSinceFileUpdate = false;

    public SequenceNumberIndexWriter(AtomicBuffer inMemoryBuffer, MappedFile indexFile, ErrorHandler errorHandler, int streamId, RecordingIdLookup recordingIdLookup, long indexFileStateFlushTimeoutInMs, EpochClock clock) {
        this.inMemoryBuffer = inMemoryBuffer;
        this.indexFile = indexFile;
        this.errorHandler = errorHandler;
        this.streamId = streamId;
        this.fileCapacity = indexFile.buffer().capacity();
        this.recordingIdLookup = recordingIdLookup;
        this.indexFileStateFlushTimeoutInMs = indexFileStateFlushTimeoutInMs;
        this.clock = clock;
        String indexFilePath = indexFile.file().getAbsolutePath();
        this.indexPath = indexFile.file().toPath();
        File writeableFile = SequenceNumberIndexDescriptor.writableFile(indexFilePath);
        this.writablePath = writeableFile.toPath();
        this.passingPlacePath = SequenceNumberIndexDescriptor.passingFile(indexFilePath).toPath();
        this.writableFile = MappedFile.map(writeableFile, this.fileCapacity);
        this.sequenceNumberExtractor = new SequenceNumberExtractor(errorHandler);
        this.indexedPositionsOffset = SequenceNumberIndexDescriptor.positionTableOffset(this.fileCapacity);
        this.checksumFramer = new ChecksumFramer(inMemoryBuffer, this.indexedPositionsOffset, errorHandler, 0, "SequenceNumberIndex");
        try {
            this.initialiseBuffer();
            this.positions = new IndexedPositionWriter(SequenceNumberIndexDescriptor.positionsBuffer(inMemoryBuffer, this.indexedPositionsOffset), errorHandler, this.indexedPositionsOffset, "SequenceNumberIndex");
        }
        catch (Exception e) {
            CloseHelper.close((AutoCloseable)this.writableFile);
            indexFile.close();
            throw e;
        }
    }

    public void onFragment(DirectBuffer buffer, int srcOffset, int length, Header header) {
        int streamId = header.streamId();
        long endPosition = header.position();
        int aeronSessionId = header.sessionId();
        if (streamId != this.streamId) {
            return;
        }
        if ((header.flags() & 0x80) == 128) {
            int offset = srcOffset;
            this.messageHeader.wrap(buffer, offset);
            offset += this.messageHeader.encodedLength();
            int actingBlockLength = this.messageHeader.blockLength();
            int version = this.messageHeader.version();
            switch (this.messageHeader.templateId()) {
                case 1: {
                    this.messageFrame.wrap(buffer, offset, actingBlockLength, version);
                    if (this.messageFrame.status() != MessageStatus.OK) {
                        return;
                    }
                    long sessionId = this.messageFrame.session();
                    int msgSeqNum = this.sequenceNumberExtractor.extract(buffer, offset += actingBlockLength + 2, this.messageFrame.bodyLength());
                    if (msgSeqNum == -1) break;
                    this.saveRecord(msgSeqNum, sessionId);
                    break;
                }
                case 36: {
                    this.resetSequenceNumbers();
                    break;
                }
                case 42: {
                    this.resetSequenceNumber.wrap(buffer, offset, actingBlockLength, version);
                    this.saveRecord(0, this.resetSequenceNumber.session());
                }
            }
        }
        this.checkTermRoll(buffer, srcOffset, endPosition, length);
        long recordingId = this.recordingIdLookup.getRecordingId(aeronSessionId);
        this.positions.indexedUpTo(aeronSessionId, recordingId, endPosition);
    }

    @Override
    public int doWork() {
        long requiredUpdateTimeInMs;
        if (this.hasSavedRecordSinceFileUpdate && (requiredUpdateTimeInMs = this.lastUpdatedFileTimeInMs + this.indexFileStateFlushTimeoutInMs) < this.clock.time()) {
            this.updateFile();
            return 1;
        }
        return 0;
    }

    void resetSequenceNumbers() {
        this.inMemoryBuffer.setMemory(0, this.indexedPositionsOffset, (byte)0);
        this.initialiseBlankBuffer();
    }

    private void checkTermRoll(DirectBuffer buffer, int offset, long endPosition, int length) {
        long termBufferLength = buffer.capacity();
        if (this.nextRollPosition == -1L) {
            long startPosition = endPosition - (long)(length + 32);
            this.nextRollPosition = startPosition + termBufferLength - (long)offset;
        } else if (endPosition > this.nextRollPosition) {
            this.nextRollPosition += termBufferLength;
            this.updateFile();
        }
    }

    private void updateFile() {
        this.checksumFramer.updateChecksums();
        this.positions.updateChecksums();
        this.saveFile();
        this.flipFiles();
        this.hasSavedRecordSinceFileUpdate = false;
        this.lastUpdatedFileTimeInMs = this.clock.time();
    }

    private void saveFile() {
        this.writableFile.buffer().putBytes(0, (DirectBuffer)this.inMemoryBuffer, 0, this.fileCapacity);
        this.writableFile.force();
    }

    private void flipFiles() {
        boolean flipsFiles;
        if (RUNNING_ON_WINDOWS) {
            this.writableFile.close();
            this.indexFile.close();
        }
        boolean bl = flipsFiles = this.rename(this.indexPath, this.passingPlacePath) && this.rename(this.writablePath, this.indexPath) && this.rename(this.passingPlacePath, this.writablePath);
        if (RUNNING_ON_WINDOWS) {
            this.writableFile.map();
            this.indexFile.map();
        } else if (flipsFiles) {
            MappedFile file = this.writableFile;
            this.writableFile = this.indexFile;
            this.indexFile = file;
        }
    }

    private boolean rename(Path src, Path dest) {
        try {
            Files.move(src, dest, StandardCopyOption.ATOMIC_MOVE);
            return true;
        }
        catch (IOException e) {
            this.errorHandler.onError((Throwable)e);
            return false;
        }
    }

    public Path passingPlace() {
        return this.passingPlacePath;
    }

    public boolean isOpen() {
        return this.writableFile.isOpen();
    }

    @Override
    public void close() {
        try {
            if (this.isOpen() && this.hasSavedRecordSinceFileUpdate) {
                this.updateFile();
            }
        }
        finally {
            this.indexFile.close();
            this.writableFile.close();
        }
    }

    @Override
    public void readLastPosition(IndexedPositionConsumer consumer) {
        new IndexedPositionReader(this.positions.buffer()).readLastPosition(consumer);
    }

    private void saveRecord(int newSequenceNumber, long sessionId) {
        int position = (int)this.recordOffsets.get(sessionId);
        if ((long)position == -1L) {
            position = 8;
            while (true) {
                if ((position = this.checksumFramer.claim(position, 16)) == -1) {
                    this.errorHandler.onError((Throwable)new IllegalStateException("Sequence Number Index out of space, can't claim slot for " + sessionId));
                    return;
                }
                this.lastKnownDecoder.wrap((DirectBuffer)this.inMemoryBuffer, position, 16, 0);
                if (this.lastKnownDecoder.sequenceNumber() == 0) {
                    this.createNewRecord(newSequenceNumber, sessionId, position);
                    this.hasSavedRecordSinceFileUpdate = true;
                    return;
                }
                if (this.lastKnownDecoder.sessionId() == sessionId) {
                    this.updateSequenceNumber(position, newSequenceNumber);
                    this.hasSavedRecordSinceFileUpdate = true;
                    return;
                }
                position += 16;
            }
        }
        this.updateSequenceNumber(position, newSequenceNumber);
        this.hasSavedRecordSinceFileUpdate = true;
    }

    private void createNewRecord(int sequenceNumber, long sessionId, int position) {
        this.recordOffsets.put(sessionId, (long)position);
        this.lastKnownEncoder.wrap((MutableDirectBuffer)this.inMemoryBuffer, position).sessionId(sessionId);
        this.updateSequenceNumber(position, sequenceNumber);
    }

    private void initialiseBuffer() {
        this.validateBufferSizes();
        AtomicBuffer fileBuffer = this.indexFile.buffer();
        if (this.fileHasBeenInitialized(fileBuffer)) {
            this.readFile(fileBuffer);
        } else if (Files.exists(this.passingPlacePath, new LinkOption[0])) {
            if (this.rename(this.passingPlacePath, this.indexPath)) {
                this.indexFile.remap();
                this.initialiseBuffer();
            } else {
                this.errorHandler.onError((Throwable)new IllegalStateException(String.format("Unable to recover index file from %s to %s due to rename failure", this.passingPlacePath, this.indexPath)));
            }
        } else {
            this.initialiseBlankBuffer();
        }
    }

    private void initialiseBlankBuffer() {
        LoggerUtil.initialiseBuffer(this.inMemoryBuffer, this.fileHeaderEncoder, this.fileHeaderDecoder, this.lastKnownEncoder.sbeSchemaId(), this.lastKnownEncoder.sbeTemplateId(), this.lastKnownEncoder.sbeSchemaVersion(), this.lastKnownEncoder.sbeBlockLength(), this.errorHandler);
    }

    private boolean fileHasBeenInitialized(AtomicBuffer fileBuffer) {
        return fileBuffer.getShort(0) != 0 || fileBuffer.getInt(4092) != 0;
    }

    private void validateBufferSizes() {
        int inMemoryCapacity = this.inMemoryBuffer.capacity();
        if (this.fileCapacity != inMemoryCapacity) {
            throw new IllegalStateException(String.format("In memory buffer and disk file don't have the same size, disk: %d, memory: %d", this.fileCapacity, inMemoryCapacity));
        }
        if (this.fileCapacity < 4096) {
            throw new IllegalStateException(String.format("Cannot create sequence number of size < 1 sector: %d", this.fileCapacity));
        }
    }

    private void readFile(AtomicBuffer fileBuffer) {
        this.loadBuffer(fileBuffer);
        this.checksumFramer.validateCheckSums();
    }

    private void loadBuffer(AtomicBuffer fileBuffer) {
        this.inMemoryBuffer.putBytes(0, (DirectBuffer)fileBuffer, 0, this.fileCapacity);
    }

    private void updateSequenceNumber(int recordOffset, int value) {
        this.inMemoryBuffer.putIntOrdered(recordOffset + 8, value);
    }
}

