/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.HashMap;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.engine.logger.FixSessionCodecs;
import uk.co.real_logic.artio.messages.ManageSessionDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;

public class FixSessionCodecsFactory
implements ControlledFragmentHandler {
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final ManageSessionDecoder manageSession = new ManageSessionDecoder();
    private final Map<String, FixSessionCodecs> fixDictionaryClassToIndex = new HashMap<String, FixSessionCodecs>();
    private final Long2ObjectHashMap<FixSessionCodecs> sessionIdToFixDictionaryIndex = new Long2ObjectHashMap();

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeader.wrap(buffer, offset);
        int blockLength = this.messageHeader.blockLength();
        int version = this.messageHeader.version();
        if (this.messageHeader.templateId() == 8) {
            this.manageSession.wrap(buffer, offset + 8, blockLength, version);
            this.manageSession.localCompId();
            this.manageSession.localSubId();
            this.manageSession.localLocationId();
            this.manageSession.remoteCompId();
            this.manageSession.remoteSubId();
            this.manageSession.remoteLocationId();
            this.manageSession.address();
            this.manageSession.username();
            this.manageSession.password();
            this.onDictionary(this.manageSession.session(), this.manageSession.fixDictionary());
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void onDictionary(long sessionId, String fixDictionaryClassName) {
        FixSessionCodecs fixSessionCodecs = this.fixDictionaryClassToIndex.computeIfAbsent(fixDictionaryClassName, fixDictionaryName -> new FixSessionCodecs(FixDictionary.find((String)fixDictionaryName)));
        FixSessionCodecs previousIndex = (FixSessionCodecs)this.sessionIdToFixDictionaryIndex.get(sessionId);
        if (previousIndex != fixSessionCodecs) {
            this.sessionIdToFixDictionaryIndex.put(sessionId, (Object)fixSessionCodecs);
        }
    }

    FixSessionCodecs get(long sessionId) {
        return (FixSessionCodecs)this.sessionIdToFixDictionaryIndex.get(sessionId);
    }
}

