/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.function.LongToIntFunction;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.engine.framer.AdminCommand;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.GatewaySessions;
import uk.co.real_logic.artio.engine.framer.SessionContexts;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.Session;

class ResetSequenceNumberCommand
implements Reply<Void>,
AdminCommand {
    private volatile Reply.State state = Reply.State.EXECUTING;
    private Exception error;
    private final long sessionId;
    private final GatewaySessions gatewaySessions;
    private final SessionContexts sessionContexts;
    private final SequenceNumberIndexReader receivedSequenceNumberIndex;
    private final SequenceNumberIndexReader sentSequenceNumberIndex;
    private final GatewayPublication inboundPublication;
    private final GatewayPublication outboundPublication;
    private Session session;
    private LongToIntFunction libraryLookup;
    private long waitSequence = 1L;
    private Step step = Step.START;

    void libraryLookup(LongToIntFunction libraryLookup) {
        this.libraryLookup = libraryLookup;
    }

    ResetSequenceNumberCommand(long sessionId, GatewaySessions gatewaySessions, SessionContexts sessionContexts, SequenceNumberIndexReader receivedSequenceNumberIndex, SequenceNumberIndexReader sentSequenceNumberIndex, GatewayPublication inboundPublication, GatewayPublication outboundPublication) {
        this.sessionId = sessionId;
        this.gatewaySessions = gatewaySessions;
        this.sessionContexts = sessionContexts;
        this.receivedSequenceNumberIndex = receivedSequenceNumberIndex;
        this.sentSequenceNumberIndex = sentSequenceNumberIndex;
        this.inboundPublication = inboundPublication;
        this.outboundPublication = outboundPublication;
    }

    @Override
    public Exception error() {
        return this.error;
    }

    private void onError(Exception error) {
        this.error = error;
        this.state = Reply.State.ERRORED;
    }

    @Override
    public Void resultIfPresent() {
        return null;
    }

    @Override
    public Reply.State state() {
        return this.state;
    }

    @Override
    public void execute(Framer framer) {
        framer.onResetSequenceNumber(this);
    }

    boolean poll() {
        switch (this.step) {
            case START: {
                if (this.sessionIsUnknown()) {
                    this.onError(new IllegalArgumentException(String.format("Unknown sessionId: %d", this.sessionId)));
                    return true;
                }
                GatewaySession gatewaySession = this.gatewaySessions.sessionById(this.sessionId);
                if (gatewaySession != null) {
                    this.session = gatewaySession.session();
                    this.step = Step.RESET_ENGINE_SESSION;
                } else if (this.isAuthenticated()) {
                    this.step = Step.RESET_LIBRARY_SESSION;
                } else {
                    this.sessionContexts.sequenceReset(this.sessionId);
                    this.step = Step.RESET_RECV;
                }
                return false;
            }
            case RESET_ENGINE_SESSION: {
                long position = this.session.resetSequenceNumbers();
                if (!Pressure.isBackPressured(position)) {
                    this.waitSequence = 1L;
                    this.step = Step.AWAIT_RECV;
                }
                return false;
            }
            case RESET_LIBRARY_SESSION: {
                if (this.isAuthenticated()) {
                    int libraryId = this.libraryLookup.applyAsInt(this.sessionId);
                    if (!Pressure.isBackPressured(this.inboundPublication.saveResetLibrarySequenceNumber(libraryId, this.sessionId))) {
                        this.waitSequence = 1L;
                        this.step = Step.AWAIT_RECV;
                    }
                } else {
                    this.step = Step.START;
                }
                return false;
            }
            case RESET_RECV: {
                this.waitSequence = 0L;
                return this.reset(this.inboundPublication, Step.RESET_SENT);
            }
            case RESET_SENT: {
                this.waitSequence = 0L;
                return this.reset(this.outboundPublication, Step.AWAIT_RECV);
            }
            case AWAIT_RECV: {
                return this.await(this.receivedSequenceNumberIndex);
            }
            case AWAIT_SENT: {
                return this.await(this.sentSequenceNumberIndex);
            }
            case DONE: {
                return true;
            }
        }
        return false;
    }

    private boolean isAuthenticated() {
        return this.sessionContexts.isAuthenticated(this.sessionId);
    }

    private boolean reset(GatewayPublication publication, Step nextStep) {
        if (!Pressure.isBackPressured(publication.saveResetSequenceNumber(this.sessionId))) {
            this.step = nextStep;
        }
        return false;
    }

    private boolean await(SequenceNumberIndexReader sequenceNumberIndex) {
        boolean done;
        boolean bl = done = (long)sequenceNumberIndex.lastKnownSequenceNumber(this.sessionId) <= this.waitSequence;
        if (done) {
            this.step = Step.DONE;
            this.state = Reply.State.COMPLETED;
        }
        return done;
    }

    private boolean sessionIsUnknown() {
        return !this.sessionContexts.isKnownSessionId(this.sessionId);
    }

    public String toString() {
        return "ResetSequenceNumberReply{state=" + (Object)((Object)this.state) + ", error=" + this.error + ", sessionId=" + this.sessionId + ", step=" + (Object)((Object)this.step) + '}';
    }

    private static enum Step {
        START,
        RESET_ENGINE_SESSION,
        RESET_LIBRARY_SESSION,
        RESET_SENT,
        RESET_RECV,
        AWAIT_RECV,
        AWAIT_SENT,
        DONE;

    }
}

