/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.validation;

import uk.co.real_logic.artio.decoder.AbstractLogonDecoder;
import uk.co.real_logic.artio.validation.PersistenceLevel;

@FunctionalInterface
public interface SessionPersistenceStrategy {
    public static SessionPersistenceStrategy alwaysIndexed() {
        return logon -> PersistenceLevel.INDEXED;
    }

    public static SessionPersistenceStrategy alwaysUnindexed() {
        return logon -> PersistenceLevel.UNINDEXED;
    }

    public static boolean resetSequenceNumbersUponLogon(PersistenceLevel persistenceLevel) {
        switch (persistenceLevel) {
            case INDEXED: {
                return false;
            }
            case UNINDEXED: {
                return true;
            }
        }
        throw new IllegalArgumentException("persistenceLevel=" + (Object)((Object)persistenceLevel));
    }

    public PersistenceLevel getPersistenceLevel(AbstractLogonDecoder var1);
}

