/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.session;

import io.aeron.logbuffer.ControlledFragmentHandler;
import org.agrona.AsciiNumberFormatException;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import uk.co.real_logic.artio.FixGatewayException;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.decoder.AbstractHeartbeatDecoder;
import uk.co.real_logic.artio.decoder.AbstractLogonDecoder;
import uk.co.real_logic.artio.decoder.AbstractLogoutDecoder;
import uk.co.real_logic.artio.decoder.AbstractRejectDecoder;
import uk.co.real_logic.artio.decoder.AbstractSequenceResetDecoder;
import uk.co.real_logic.artio.decoder.AbstractTestRequestDecoder;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.fields.UtcTimestampDecoder;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.validation.MessageValidationStrategy;

public class SessionParser {
    private final AsciiBuffer asciiBuffer = new MutableAsciiBuffer();
    private final UtcTimestampDecoder timestampDecoder = new UtcTimestampDecoder();
    private final AbstractLogonDecoder logon;
    private final AbstractLogoutDecoder logout;
    private final AbstractRejectDecoder reject;
    private final AbstractTestRequestDecoder testRequest;
    private final SessionHeaderDecoder header;
    private final AbstractSequenceResetDecoder sequenceReset;
    private final AbstractHeartbeatDecoder heartbeat;
    private final Session session;
    private final MessageValidationStrategy validationStrategy;
    private ErrorHandler errorHandler;

    public SessionParser(Session session, MessageValidationStrategy validationStrategy, ErrorHandler errorHandler, FixDictionary fixDictionary) {
        this.session = session;
        this.validationStrategy = validationStrategy;
        this.errorHandler = errorHandler;
        this.logon = fixDictionary.makeLogonDecoder();
        this.logout = fixDictionary.makeLogoutDecoder();
        this.reject = fixDictionary.makeRejectDecoder();
        this.testRequest = fixDictionary.makeTestRequestDecoder();
        this.header = fixDictionary.makeHeaderDecoder();
        this.sequenceReset = fixDictionary.makeSequenceResetDecoder();
        this.heartbeat = fixDictionary.makeHeartbeatDecoder();
    }

    public static String username(AbstractLogonDecoder logon) {
        return logon.supportsUsername() ? logon.usernameAsString() : null;
    }

    public static String password(AbstractLogonDecoder logon) {
        return logon.supportsPassword() ? logon.passwordAsString() : null;
    }

    public ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, int messageType, long sessionId) {
        this.asciiBuffer.wrap(buffer);
        try {
            ControlledFragmentHandler.Action action;
            switch (messageType) {
                case 65: {
                    action = this.onLogon(offset, length);
                    break;
                }
                case 53: {
                    action = this.onLogout(offset, length);
                    break;
                }
                case 48: {
                    action = this.onHeartbeat(offset, length);
                    break;
                }
                case 51: {
                    action = this.onReject(offset, length);
                    break;
                }
                case 49: {
                    action = this.onTestRequest(offset, length);
                    break;
                }
                case 52: {
                    action = this.onSequenceReset(offset, length);
                    break;
                }
                default: {
                    action = this.onAnyOtherMessage(offset, length);
                }
            }
            this.session.updateLastMessageProcessed();
            return action;
        }
        catch (AsciiNumberFormatException e) {
            if (e.getMessage().contains("'^' is not a valid digit")) {
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            this.errorHandler.onError((Throwable)e);
            return this.rejectExceptionalMessage(messageType);
        }
        catch (Exception e) {
            this.errorHandler.onError((Throwable)e);
            return this.rejectExceptionalMessage(messageType);
        }
    }

    private ControlledFragmentHandler.Action rejectExceptionalMessage(int messageType) {
        switch (messageType) {
            case 65: {
                return this.onExceptionalMessage(this.logon.header());
            }
            case 53: {
                return this.onExceptionalMessage(this.logout.header());
            }
            case 48: {
                return this.onExceptionalMessage(this.heartbeat.header());
            }
            case 51: {
                return this.onExceptionalMessage(this.reject.header());
            }
            case 49: {
                return this.onExceptionalMessage(this.testRequest.header());
            }
            case 52: {
                return this.onExceptionalMessage(this.sequenceReset.header());
            }
        }
        return this.onExceptionalMessage(this.header);
    }

    private ControlledFragmentHandler.Action onExceptionalMessage(SessionHeaderDecoder header) {
        int msgSeqNum = header.msgSeqNum();
        this.session.onInvalidMessage(msgSeqNum, Integer.MIN_VALUE, header.msgType(), header.msgTypeLength(), 6);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onHeartbeat(int offset, int length) {
        AbstractHeartbeatDecoder heartbeat = this.heartbeat;
        heartbeat.reset();
        heartbeat.decode(this.asciiBuffer, offset, length);
        SessionHeaderDecoder header = heartbeat.header();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || heartbeat.validate() && this.validateHeader(header))) {
            return this.onCodecInvalidMessage((Decoder)heartbeat, header, false);
        }
        if (heartbeat.hasTestReqID()) {
            long origSendingTime = this.origSendingTime(header);
            long sendingTime = this.sendingTime(header);
            int testReqIDLength = heartbeat.testReqIDLength();
            char[] testReqID = heartbeat.testReqID();
            int msgSeqNum = header.msgSeqNum();
            boolean possDup = this.isPossDup(header);
            return this.session.onHeartbeat(msgSeqNum, testReqID, testReqIDLength, sendingTime, origSendingTime, this.isPossDupOrResend(possDup, header), possDup);
        }
        return this.onMessage(header);
    }

    private long sendingTime(SessionHeaderDecoder header) {
        byte[] sendingTime = header.sendingTime();
        return this.decodeTimestamp(sendingTime);
    }

    private long decodeTimestamp(byte[] sendingTime) {
        return Validation.CODEC_VALIDATION_ENABLED ? this.timestampDecoder.decode(sendingTime, sendingTime.length) : Long.MIN_VALUE;
    }

    private ControlledFragmentHandler.Action onAnyOtherMessage(int offset, int length) {
        SessionHeaderDecoder header = this.header;
        header.reset();
        header.decode(this.asciiBuffer, offset, length);
        char[] msgType = header.msgType();
        int msgTypeLength = header.msgTypeLength();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || Validation.isValidMsgType((char[])msgType, (int)msgTypeLength) && this.validateHeader(header))) {
            int msgSeqNum = header.msgSeqNum();
            if (!this.isDisconnectedOrAwaitingLogout()) {
                return this.session.onInvalidMessageType(msgSeqNum, msgType, msgTypeLength);
            }
        } else {
            return this.onMessage(header);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onMessage(SessionHeaderDecoder header) {
        long origSendingTime = this.origSendingTime(header);
        long sendingTime = this.sendingTime(header);
        boolean possDup = this.isPossDup(header);
        return this.session.onMessage(header.msgSeqNum(), header.msgType(), header.msgTypeLength(), sendingTime, origSendingTime, this.isPossDupOrResend(possDup, header), possDup);
    }

    private long origSendingTime(SessionHeaderDecoder header) {
        return header.hasOrigSendingTime() ? this.decodeTimestamp(header.origSendingTime()) : -1L;
    }

    private ControlledFragmentHandler.Action onSequenceReset(int offset, int length) {
        AbstractSequenceResetDecoder sequenceReset = this.sequenceReset;
        sequenceReset.reset();
        sequenceReset.decode(this.asciiBuffer, offset, length);
        SessionHeaderDecoder header = sequenceReset.header();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || sequenceReset.validate() && this.validateHeader(header))) {
            return this.onCodecInvalidMessage((Decoder)sequenceReset, header, false);
        }
        boolean gapFillFlag = sequenceReset.hasGapFillFlag() && sequenceReset.gapFillFlag();
        boolean possDup = this.isPossDup(header);
        return this.session.onSequenceReset(header.msgSeqNum(), sequenceReset.newSeqNo(), gapFillFlag, this.isPossDupOrResend(possDup, header));
    }

    private ControlledFragmentHandler.Action onTestRequest(int offset, int length) {
        AbstractTestRequestDecoder testRequest = this.testRequest;
        testRequest.reset();
        testRequest.decode(this.asciiBuffer, offset, length);
        SessionHeaderDecoder header = testRequest.header();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || testRequest.validate() && this.validateHeader(header))) {
            return this.onCodecInvalidMessage((Decoder)testRequest, header, false);
        }
        int msgSeqNo = header.msgSeqNum();
        long origSendingTime = this.origSendingTime(header);
        long sendingTime = this.sendingTime(header);
        boolean possDup = this.isPossDup(header);
        return this.session.onTestRequest(msgSeqNo, testRequest.testReqID(), testRequest.testReqIDLength(), sendingTime, origSendingTime, this.isPossDupOrResend(possDup, header), possDup);
    }

    private ControlledFragmentHandler.Action onReject(int offset, int length) {
        AbstractRejectDecoder reject = this.reject;
        reject.reset();
        reject.decode(this.asciiBuffer, offset, length);
        SessionHeaderDecoder header = reject.header();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || reject.validate() && this.validateHeader(header))) {
            return this.onCodecInvalidMessage((Decoder)reject, header, false);
        }
        long origSendingTime = this.origSendingTime(header);
        long sendingTime = this.sendingTime(header);
        boolean possDup = this.isPossDup(header);
        return this.session.onReject(header.msgSeqNum(), sendingTime, origSendingTime, this.isPossDupOrResend(possDup, header), possDup);
    }

    private ControlledFragmentHandler.Action onLogout(int offset, int length) {
        AbstractLogoutDecoder logout = this.logout;
        logout.reset();
        logout.decode(this.asciiBuffer, offset, length);
        SessionHeaderDecoder header = logout.header();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || logout.validate() && this.validateHeader(header))) {
            return this.onCodecInvalidMessage((Decoder)logout, header, false);
        }
        long origSendingTime = this.origSendingTime(header);
        long sendingTime = this.sendingTime(header);
        boolean possDup = this.isPossDup(header);
        return this.session.onLogout(header.msgSeqNum(), sendingTime, origSendingTime, possDup);
    }

    private ControlledFragmentHandler.Action onLogon(int offset, int length) {
        AbstractLogonDecoder logon = this.logon;
        Session session = this.session;
        logon.reset();
        logon.decode(this.asciiBuffer, offset, length);
        SessionHeaderDecoder header = logon.header();
        char[] beginString = header.beginString();
        int beginStringLength = header.beginStringLength();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || logon.validate() && session.onBeginString(beginString, beginStringLength, true))) {
            return this.onCodecInvalidMessage((Decoder)logon, header, true);
        }
        long origSendingTime = this.origSendingTime(header);
        String username = SessionParser.username(logon);
        String password = SessionParser.password(logon);
        boolean possDup = this.isPossDup(header);
        return session.onLogon(logon.heartBtInt(), header.msgSeqNum(), this.sendingTime(header), origSendingTime, username, password, this.isPossDupOrResend(possDup, header), this.resetSeqNumFlag(logon), possDup);
    }

    private void onStrategyError(String strategyName, Throwable throwable, String fixMessage) {
        String message = String.format("Exception thrown by %s strategy for connectionId=%d, [%s], defaulted to false", strategyName, this.session.connectionId(), fixMessage);
        this.onError(new FixGatewayException(message, throwable));
    }

    private void onError(Throwable throwable) {
        if (this.errorHandler == null) {
            LangUtil.rethrowUnchecked((Throwable)throwable);
        } else {
            this.errorHandler.onError(throwable);
        }
    }

    private boolean resetSeqNumFlag(AbstractLogonDecoder logon) {
        return logon.hasResetSeqNumFlag() && logon.resetSeqNumFlag();
    }

    private boolean validateHeader(SessionHeaderDecoder header) {
        boolean validated;
        if (!this.session.onBeginString(header.beginString(), header.beginStringLength(), false)) {
            return false;
        }
        try {
            validated = this.validationStrategy.validate(header);
        }
        catch (Throwable throwable) {
            this.onStrategyError("validation", throwable, header.toString());
            validated = false;
        }
        if (!validated) {
            this.session.onInvalidMessage(header.msgSeqNum(), this.validationStrategy.invalidTagId(), header.msgType(), header.msgTypeLength(), this.validationStrategy.rejectReason());
            this.session.logoutRejectReason(this.validationStrategy.rejectReason());
            this.session.startLogout();
            return false;
        }
        return true;
    }

    private ControlledFragmentHandler.Action onCodecInvalidMessage(Decoder decoder, SessionHeaderDecoder header, boolean requestDisconnect) {
        if (!this.isDisconnectedOrAwaitingLogout()) {
            int msgTypeLength = header.msgTypeLength();
            if (header.msgSeqNum() == Integer.MIN_VALUE) {
                long origSendingTime = this.origSendingTime(header);
                long sendingTime = this.sendingTime(header);
                char[] msgType = header.msgType();
                return this.session.onMessage(Integer.MIN_VALUE, msgType, msgTypeLength, sendingTime, origSendingTime, false, false);
            }
            ControlledFragmentHandler.Action action = this.session.onInvalidMessage(header.msgSeqNum(), decoder.invalidTagId(), header.msgType(), msgTypeLength, decoder.rejectReason());
            if (action == ControlledFragmentHandler.Action.CONTINUE && requestDisconnect) {
                return this.session.onInvalidFixDisconnect();
            }
            return action;
        }
        if (requestDisconnect) {
            return this.session.onInvalidFixDisconnect();
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private boolean isDisconnectedOrAwaitingLogout() {
        SessionState state = this.session.state();
        return state == SessionState.DISCONNECTED || state == SessionState.AWAITING_LOGOUT;
    }

    private boolean isPossDupOrResend(boolean possDup, SessionHeaderDecoder header) {
        return possDup || header.hasPossResend() && header.possResend();
    }

    private boolean isPossDup(SessionHeaderDecoder header) {
        return header.hasPossDupFlag() && header.possDupFlag();
    }

    public Session session() {
        return this.session;
    }

    public void sequenceIndex(int sequenceIndex) {
        this.session.sequenceIndex(sequenceIndex);
    }
}

