/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.session;

import io.aeron.logbuffer.ControlledFragmentHandler;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.session.SessionProxy;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class InitiatorSession
extends InternalSession {
    private final boolean resetSeqNum;

    public InitiatorSession(int heartbeatInterval, long connectionId, EpochClock clock, SessionProxy proxy, GatewayPublication publication, SessionIdStrategy sessionIdStrategy, long sendingTimeWindow, AtomicCounter receivedMsgSeqNo, AtomicCounter sentMsgSeqNo, int libraryId, int initialSentSequenceNumber, int sequenceIndex, SessionState state, boolean resetSeqNum, long reasonableTransmissionTimeInMs, MutableAsciiBuffer asciiBuffer, boolean enableLastMsgSeqNumProcessed, String beginString) {
        super(heartbeatInterval, connectionId, clock, state, proxy, publication, sessionIdStrategy, sendingTimeWindow, receivedMsgSeqNo, sentMsgSeqNo, libraryId, initialSentSequenceNumber, sequenceIndex, reasonableTransmissionTimeInMs, asciiBuffer, enableLastMsgSeqNumProcessed, beginString);
        this.resetSeqNum = resetSeqNum;
    }

    @Override
    protected SessionState initialState() {
        return SessionState.SENT_LOGON;
    }

    @Override
    protected ControlledFragmentHandler.Action respondToLogon(int heartbeatInterval) {
        return null;
    }

    @Override
    public int poll(long time) {
        int actions = 0;
        if (this.state() == SessionState.CONNECTED && this.id() != -1L) {
            this.state(SessionState.SENT_LOGON);
            int heartbeatIntervalInS = (int)(this.heartbeatIntervalInMs() / 1000L);
            int sentSeqNum = this.resetSeqNum ? 1 : this.newSentSeqNum();
            long position = this.proxy.sendLogon(sentSeqNum, heartbeatIntervalInS, this.username(), this.password(), this.resetSeqNum, this.sequenceIndex(), this.lastMsgSeqNumProcessed());
            if (position >= 0L) {
                this.lastSentMsgSeqNum(sentSeqNum);
            }
            ++actions;
        }
        return actions + super.poll(time);
    }
}

