/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.protocol;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.protocol.NotConnectedException;

class ClaimablePublication
implements AutoCloseable {
    static final int HEADER_LENGTH = 8;
    private final long maxClaimAttempts;
    private final AtomicCounter fails;
    protected final MessageHeaderEncoder header = new MessageHeaderEncoder();
    protected final BufferClaim bufferClaim = new BufferClaim();
    protected final ExclusivePublication dataPublication;
    protected final IdleStrategy idleStrategy;

    ClaimablePublication(int maxClaimAttempts, IdleStrategy idleStrategy, AtomicCounter fails, ExclusivePublication dataPublication) {
        this.maxClaimAttempts = maxClaimAttempts;
        this.idleStrategy = idleStrategy;
        this.fails = fails;
        this.dataPublication = dataPublication;
    }

    protected long claim(int framedLength) {
        return this.claim(framedLength, this.bufferClaim);
    }

    public long claim(int framedLength, BufferClaim bufferClaim) {
        long position;
        long i = 0L;
        do {
            if ((position = this.dataPublication.tryClaim(framedLength, bufferClaim)) > 0L) {
                return position;
            }
            this.idleStrategy.idle();
            this.fails.increment();
        } while (++i <= this.maxClaimAttempts);
        this.idleStrategy.reset();
        if (position == -4L || position == -5L) {
            throw new NotConnectedException(position);
        }
        return position;
    }

    @Override
    public void close() {
        this.dataPublication.close();
    }
}

