/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import io.aeron.logbuffer.ControlledFragmentHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.agrona.Verify;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.library.DefaultLibraryScheduler;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.GatewayErrorHandler;
import uk.co.real_logic.artio.library.LibraryConnectHandler;
import uk.co.real_logic.artio.library.LibraryScheduler;
import uk.co.real_logic.artio.library.SentPositionHandler;
import uk.co.real_logic.artio.library.SessionAcquireHandler;
import uk.co.real_logic.artio.library.SessionExistsHandler;
import uk.co.real_logic.artio.session.DirectSessionProxy;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.session.SessionProxyFactory;

public final class LibraryConfiguration
extends CommonConfiguration {
    public static final GatewayErrorHandler DEFAULT_GATEWAY_ERROR_HANDLER = (errorType, libraryId, message) -> ControlledFragmentHandler.Action.CONTINUE;
    public static final SentPositionHandler DEFAULT_SENT_POSITION_HANDLER = position -> ControlledFragmentHandler.Action.CONTINUE;
    public static final SessionExistsHandler DEFAULT_SESSION_EXISTS_HANDLER = (library, sessionId, senderCompId, senderSubId, senderLocationId, targetCompId, remoteSubId, remoteLocationId) -> {};
    public static final LibraryConnectHandler DEFAULT_LIBRARY_CONNECT_HANDLER = new LibraryConnectHandler(){

        @Override
        public void onConnect(FixLibrary library) {
        }

        @Override
        public void onDisconnect(FixLibrary library) {
        }
    };
    public static final SessionProxyFactory DEFAULT_SESSION_PROXY_FACTORY = DirectSessionProxy::new;
    private final int libraryId;
    private SessionAcquireHandler sessionAcquireHandler;
    private IdleStrategy libraryIdleStrategy;
    private SessionExistsHandler sessionExistsHandler;
    private GatewayErrorHandler gatewayErrorHandler;
    private SentPositionHandler sentPositionHandler;
    private List<String> libraryAeronChannels;
    private LibraryConnectHandler libraryConnectHandler;
    private LibraryScheduler scheduler;
    private String libraryName;
    private SessionProxyFactory sessionProxyFactory;

    public LibraryConfiguration() {
        int libraryId;
        while ((libraryId = ThreadLocalRandom.current().nextInt()) == 0) {
        }
        this.libraryId = libraryId;
        this.libraryIdleStrategy = LibraryConfiguration.backoffIdleStrategy();
        this.sessionExistsHandler = DEFAULT_SESSION_EXISTS_HANDLER;
        this.gatewayErrorHandler = DEFAULT_GATEWAY_ERROR_HANDLER;
        this.sentPositionHandler = DEFAULT_SENT_POSITION_HANDLER;
        this.libraryAeronChannels = new ArrayList<String>();
        this.libraryConnectHandler = DEFAULT_LIBRARY_CONNECT_HANDLER;
        this.scheduler = new DefaultLibraryScheduler();
        this.libraryName = "";
        this.sessionProxyFactory = DEFAULT_SESSION_PROXY_FACTORY;
    }

    public LibraryConfiguration sessionAcquireHandler(SessionAcquireHandler sessionAcquireHandler) {
        this.sessionAcquireHandler = sessionAcquireHandler;
        return this;
    }

    public LibraryConfiguration libraryIdleStrategy(IdleStrategy libraryIdleStrategy) {
        this.libraryIdleStrategy = libraryIdleStrategy;
        return this;
    }

    public LibraryConfiguration sessionExistsHandler(SessionExistsHandler sessionExistsHandler) {
        this.sessionExistsHandler = sessionExistsHandler;
        return this;
    }

    public LibraryConfiguration gatewayErrorHandler(GatewayErrorHandler gatewayErrorHandler) {
        this.gatewayErrorHandler = gatewayErrorHandler;
        return this;
    }

    public LibraryConfiguration sentPositionHandler(SentPositionHandler sentPositionHandler) {
        this.sentPositionHandler = sentPositionHandler;
        return this;
    }

    public LibraryConfiguration libraryConnectHandler(LibraryConnectHandler libraryConnectHandler) {
        this.libraryConnectHandler = libraryConnectHandler;
        return this;
    }

    public LibraryConfiguration scheduler(LibraryScheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public SessionAcquireHandler sessionAcquireHandler() {
        return this.sessionAcquireHandler;
    }

    public int libraryId() {
        return this.libraryId;
    }

    public IdleStrategy libraryIdleStrategy() {
        return this.libraryIdleStrategy;
    }

    public GatewayErrorHandler gatewayErrorHandler() {
        return this.gatewayErrorHandler;
    }

    public SentPositionHandler sentPositionHandler() {
        return this.sentPositionHandler;
    }

    public LibraryConnectHandler libraryConnectHandler() {
        return this.libraryConnectHandler;
    }

    public LibraryScheduler scheduler() {
        return this.scheduler;
    }

    public SessionProxyFactory sessionProxyFactory() {
        return this.sessionProxyFactory;
    }

    @Override
    public LibraryConfiguration sessionIdStrategy(SessionIdStrategy sessionIdStrategy) {
        super.sessionIdStrategy(sessionIdStrategy);
        return this;
    }

    @Override
    public LibraryConfiguration monitoringBuffersLength(Integer monitoringBuffersLength) {
        super.monitoringBuffersLength(monitoringBuffersLength);
        return this;
    }

    @Override
    public LibraryConfiguration monitoringFile(String monitoringFile) {
        super.monitoringFile(monitoringFile);
        return this;
    }

    public LibraryConfiguration libraryAeronChannels(List<String> libraryAeronChannels) {
        this.libraryAeronChannels = libraryAeronChannels;
        return this;
    }

    public LibraryConfiguration sessionProxyFactory(SessionProxyFactory sessionProxyFactory) {
        this.sessionProxyFactory = sessionProxyFactory;
        return this;
    }

    @Override
    public LibraryConfiguration replyTimeoutInMs(long replyTimeoutInMs) {
        super.replyTimeoutInMs(replyTimeoutInMs);
        return this;
    }

    void conclude() {
        super.conclude("library-" + this.libraryId());
        Verify.notNull((Object)this.sessionAcquireHandler, (String)"sessionAcquireHandler");
        if (this.libraryAeronChannels.isEmpty()) {
            throw new IllegalArgumentException("You must specify at least one channel to connect to");
        }
    }

    SessionExistsHandler sessionExistsHandler() {
        return this.sessionExistsHandler;
    }

    public List<String> libraryAeronChannels() {
        return this.libraryAeronChannels;
    }

    String libraryName() {
        return this.libraryName;
    }

    public LibraryConfiguration libraryName(String libraryName) {
        this.libraryName = libraryName;
        return this;
    }
}

