/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.IntHashSet;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.engine.PossDupEnabler;
import uk.co.real_logic.artio.engine.ReplayHandler;
import uk.co.real_logic.artio.engine.SenderSequenceNumbers;
import uk.co.real_logic.artio.engine.SequenceNumberExtractor;
import uk.co.real_logic.artio.engine.logger.GapFillEncoder;
import uk.co.real_logic.artio.engine.logger.ReplayOperation;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;
import uk.co.real_logic.artio.engine.logger.Replayer;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.FixMessageEncoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.messages.ReplayCompleteEncoder;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

class ReplayerSession
implements ControlledFragmentHandler {
    private static final int NONE = -1;
    private static final FixMessageEncoder FIX_MESSAGE_ENCODER = new FixMessageEncoder();
    private static final MessageHeaderDecoder MESSAGE_HEADER = new MessageHeaderDecoder();
    private static final FixMessageDecoder FIX_MESSAGE = new FixMessageDecoder();
    private static final MessageHeaderEncoder MESSAGE_HEADER_ENCODER = new MessageHeaderEncoder();
    private static final AsciiBuffer ASCII_BUFFER = new MutableAsciiBuffer();
    private static final ReplayCompleteEncoder REPLAY_COMPLETE_ENCODER = new ReplayCompleteEncoder();
    private final GapFillEncoder gapFillEncoder;
    private final BufferClaim bufferClaim;
    private final PossDupEnabler possDupEnabler;
    private final String message;
    private final IdleStrategy idleStrategy;
    private final ReplayHandler replayHandler;
    private final int maxClaimAttempts;
    private final IntHashSet gapFillMessageTypes;
    private final SenderSequenceNumbers senderSequenceNumbers;
    private final ExclusivePublication publication;
    private final ReplayQuery replayQuery;
    private final ErrorHandler errorHandler;
    private final SequenceNumberExtractor sequenceNumberExtractor;
    private int beginSeqNo;
    private int endSeqNo;
    private boolean upToMostRecent;
    private long connectionId;
    private long sessionId;
    private int sequenceIndex;
    private int lastSeqNo;
    private int beginGapFillSeqNum = -1;
    private ReplayOperation replayOperation;
    private State state;

    ReplayerSession(BufferClaim bufferClaim, IdleStrategy idleStrategy, ReplayHandler replayHandler, int maxClaimAttempts, IntHashSet gapFillMessageTypes, SenderSequenceNumbers senderSequenceNumbers, ExclusivePublication publication, EpochClock clock, int beginSeqNo, int endSeqNo, boolean upToMostRecent, long connectionId, long sessionId, int sequenceIndex, ReplayQuery replayQuery, String message, ErrorHandler errorHandler, GapFillEncoder gapFillEncoder) {
        this.bufferClaim = bufferClaim;
        this.idleStrategy = idleStrategy;
        this.replayHandler = replayHandler;
        this.maxClaimAttempts = maxClaimAttempts;
        this.gapFillMessageTypes = gapFillMessageTypes;
        this.senderSequenceNumbers = senderSequenceNumbers;
        this.publication = publication;
        this.beginSeqNo = beginSeqNo;
        this.endSeqNo = endSeqNo;
        this.upToMostRecent = upToMostRecent;
        this.connectionId = connectionId;
        this.sessionId = sessionId;
        this.sequenceIndex = sequenceIndex;
        this.message = message;
        this.errorHandler = errorHandler;
        this.replayQuery = replayQuery;
        this.gapFillEncoder = gapFillEncoder;
        this.sequenceNumberExtractor = new SequenceNumberExtractor(errorHandler);
        this.lastSeqNo = beginSeqNo - 1;
        this.possDupEnabler = new PossDupEnabler(bufferClaim, this::claimBuffer, this::onPreCommit, x$0 -> this.onIllegalState((String)x$0, new Object[0]), this::onException, clock, publication.maxPayloadLength(), LogTag.FIX_MESSAGE);
        this.state = State.REPLAYING;
    }

    private void onPreCommit(MutableDirectBuffer buffer, int offset) {
        int frameOffset = offset + 8;
        FIX_MESSAGE_ENCODER.wrap(buffer, frameOffset).connection(this.connectionId);
    }

    private void onException(Throwable e) {
        String exMessage = String.format("[%s] Error replying to message", this.message);
        this.errorHandler.onError((Throwable)new IllegalArgumentException(exMessage, e));
    }

    private void onIllegalState(String message, Object ... arguments) {
        this.errorHandler.onError((Throwable)new IllegalStateException(String.format(message, arguments)));
    }

    void query() {
        this.replayOperation = this.replayQuery.query(this, this.sessionId, this.beginSeqNo, this.sequenceIndex, this.endSeqNo, this.sequenceIndex, LogTag.CATCHUP);
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer srcBuffer, int srcOffset, int srcLength, Header header) {
        MESSAGE_HEADER.wrap(srcBuffer, srcOffset);
        int actingBlockLength = MESSAGE_HEADER.blockLength();
        int offset = srcOffset + 8;
        FIX_MESSAGE.wrap(srcBuffer, offset, actingBlockLength, MESSAGE_HEADER.version());
        int messageOffset = srcOffset + Replayer.MESSAGE_FRAME_BLOCK_LENGTH;
        int messageLength = srcLength - Replayer.MESSAGE_FRAME_BLOCK_LENGTH;
        int msgSeqNum = this.sequenceNumberExtractor.extract(srcBuffer, messageOffset, messageLength);
        int messageType = FIX_MESSAGE.messageType();
        ASCII_BUFFER.wrap(srcBuffer);
        this.replayHandler.onReplayedMessage((DirectBuffer)ASCII_BUFFER, messageOffset, messageLength, FIX_MESSAGE.libraryId(), FIX_MESSAGE.session(), FIX_MESSAGE.sequenceIndex(), messageType);
        if (this.gapFillMessageTypes.contains(messageType)) {
            if (this.beginGapFillSeqNum == -1) {
                this.beginGapFillSeqNum = this.lastSeqNo + 1;
            }
            this.lastSeqNo = msgSeqNum;
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        if (this.beginGapFillSeqNum != -1) {
            this.sendGapFill(this.beginGapFillSeqNum, msgSeqNum);
        } else if (msgSeqNum > this.lastSeqNo + 1) {
            this.sendGapFill(this.lastSeqNo, msgSeqNum);
        }
        ControlledFragmentHandler.Action action = this.possDupEnabler.enablePossDupFlag(srcBuffer, messageOffset, messageLength, srcOffset, srcLength);
        if (action != ControlledFragmentHandler.Action.ABORT) {
            this.lastSeqNo = msgSeqNum;
        }
        return action;
    }

    private ControlledFragmentHandler.Action sendGapFill(int msgSeqNo, int newSeqNo) {
        long result = this.gapFillEncoder.encode(msgSeqNo, newSeqNo);
        int gapFillLength = Encoder.length((long)result);
        int gapFillOffset = Encoder.offset((long)result);
        if (this.claimBuffer(Replayer.MESSAGE_FRAME_BLOCK_LENGTH + gapFillLength)) {
            int destOffset = this.bufferClaim.offset();
            MutableDirectBuffer destBuffer = this.bufferClaim.buffer();
            MutableAsciiBuffer gapFillBuffer = this.gapFillEncoder.buffer();
            FIX_MESSAGE_ENCODER.wrapAndApplyHeader(destBuffer, destOffset, MESSAGE_HEADER_ENCODER).libraryId(0).messageType(52).session(this.sessionId).sequenceIndex(this.sequenceIndex).connection(this.connectionId).timestamp(0L).status(MessageStatus.OK).putBody((DirectBuffer)gapFillBuffer, gapFillOffset, gapFillLength);
            this.bufferClaim.commit();
            DebugLogger.log(LogTag.FIX_MESSAGE, "Replayed: %s%n", (DirectBuffer)gapFillBuffer, gapFillOffset, gapFillLength);
            this.beginGapFillSeqNum = -1;
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        DebugLogger.log(LogTag.REPLAY, "Back pressured trying to sendGapFill");
        return ControlledFragmentHandler.Action.ABORT;
    }

    private boolean claimBuffer(int newLength) {
        for (int i = 0; i < this.maxClaimAttempts; ++i) {
            long position = this.publication.tryClaim(newLength, this.bufferClaim);
            if (position > 0L) {
                this.idleStrategy.reset();
                return true;
            }
            if (!Pressure.isBackPressured(position)) {
                return false;
            }
            this.idleStrategy.idle();
        }
        return false;
    }

    boolean attempReplay() {
        switch (this.state) {
            case REPLAYING: {
                DebugLogger.log(LogTag.REPLAY, "ReplayerSession: REPLAYING step");
                if (this.replayOperation.attemptReplay()) {
                    this.state = State.CHECK_REPLAY;
                    return this.attempReplay();
                }
                return false;
            }
            case CHECK_REPLAY: {
                DebugLogger.log(LogTag.REPLAY, "ReplayerSession: CHECK_REPLAY step");
                if (this.completeReplay()) {
                    this.state = State.SEND_COMPLETE_MESSAGE;
                }
                return false;
            }
            case SEND_COMPLETE_MESSAGE: {
                return this.sendCompleteMessage();
            }
        }
        return false;
    }

    private boolean completeReplay() {
        int replayedMessages = this.replayOperation.replayedMessages();
        if (this.beginGapFillSeqNum != -1) {
            int newSequenceNumber = this.upToMostRecent ? this.newSeqNo(this.connectionId) : this.endSeqNo + 1;
            ControlledFragmentHandler.Action action = this.sendGapFill(this.beginGapFillSeqNum, newSequenceNumber);
            DebugLogger.log(LogTag.REPLAY, "ReplayerSession: completeReplay-sendGapFill action=%s, replayedMessages=%d, beginGapFillSeqNum=%d, newSequenceNumber=%d%n", action, (long)replayedMessages, (long)this.beginGapFillSeqNum, (long)newSequenceNumber);
            return action != ControlledFragmentHandler.Action.ABORT;
        }
        if (!this.upToMostRecent) {
            int expectedCount = this.endSeqNo - this.beginSeqNo + 1;
            DebugLogger.log(LogTag.REPLAY, "ReplayerSession: completeReplay-!upToMostRecent replayedMessages=%d endSeqNo=%d beginSeqNo=%d expectedCount=%d%n", (long)replayedMessages, (long)this.endSeqNo, (long)this.beginSeqNo, (long)expectedCount);
            if (replayedMessages != expectedCount) {
                ControlledFragmentHandler.Action action;
                if (replayedMessages == 0 && (action = this.sendGapFill(this.beginSeqNo, this.endSeqNo + 1)) == ControlledFragmentHandler.Action.ABORT) {
                    return false;
                }
                this.onIllegalState("[%s] Error in resend request, count(%d) < expectedCount (%d)", this.message, replayedMessages, expectedCount);
            }
        } else {
            DebugLogger.log(LogTag.REPLAY, "ReplayerSession: completeReplay-upToMostRecent replayedMessages=%d%n", replayedMessages);
        }
        return true;
    }

    private boolean sendCompleteMessage() {
        if (this.claimBuffer(16)) {
            REPLAY_COMPLETE_ENCODER.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), MESSAGE_HEADER_ENCODER).connection(this.connectionId);
            this.bufferClaim.commit();
            return true;
        }
        return false;
    }

    private int newSeqNo(long connectionId) {
        return this.senderSequenceNumbers.lastSentSequenceNumber(connectionId) + 1;
    }

    public void close() {
        if (this.replayOperation != null) {
            this.replayOperation.close();
        }
    }

    private static enum State {
        REPLAYING,
        CHECK_REPLAY,
        SEND_COMPLETE_MESSAGE;

    }
}

