/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Aeron;
import io.aeron.ControlledFragmentAssembler;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.status.RecordingPos;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.status.CountersReader;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.logger.RecordingRange;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;

public class ReplayOperation {
    private final MessageTracker messageTracker;
    private final ControlledFragmentAssembler assembler;
    private final List<RecordingRange> ranges;
    private final AeronArchive aeronArchive;
    private final ErrorHandler errorHandler;
    private final int archiveReplayStream;
    private final LogTag logTag;
    private final CountersReader countersReader;
    private final Subscription subscription;
    private int replayedMessages = 0;
    private RecordingRange recordingRange;
    private int aeronSessionId;
    private Image image;

    ReplayOperation(ControlledFragmentHandler handler, List<RecordingRange> ranges, AeronArchive aeronArchive, ErrorHandler errorHandler, Subscription subscription, int archiveReplayStream, LogTag logTag) {
        this.messageTracker = new MessageTracker(logTag, handler);
        this.assembler = new ControlledFragmentAssembler((ControlledFragmentHandler)this.messageTracker);
        this.ranges = ranges;
        this.aeronArchive = aeronArchive;
        this.errorHandler = errorHandler;
        this.archiveReplayStream = archiveReplayStream;
        this.logTag = logTag;
        Aeron aeron = aeronArchive.context().aeron();
        this.countersReader = aeron.countersReader();
        this.subscription = subscription;
    }

    public boolean attemptReplay() {
        if (this.recordingRange == null) {
            DebugLogger.log(this.logTag, "Acquiring Recording Range");
            if (this.ranges.isEmpty()) {
                return true;
            }
            this.recordingRange = this.ranges.get(0);
            DebugLogger.log(this.logTag, "ReplayOperation : Attempting Recording Range: %s%n", this.recordingRange);
            this.messageTracker.sessionId = this.recordingRange.sessionId;
            long beginPosition = this.recordingRange.position;
            long length = this.recordingRange.length;
            long endPosition = beginPosition + length;
            long recordingId = this.recordingRange.recordingId;
            if (this.archivingNotComplete(endPosition, recordingId)) {
                DebugLogger.log(this.logTag, "Archiving not complete");
                this.recordingRange = null;
                return false;
            }
            this.ranges.remove(0);
            try {
                this.aeronSessionId = (int)this.aeronArchive.startReplay(recordingId, beginPosition, length, "aeron:ipc", this.archiveReplayStream);
                this.messageTracker.reset();
                if (this.image != null && this.aeronSessionId != this.image.sessionId()) {
                    this.image = null;
                }
            }
            catch (Throwable exception) {
                this.errorHandler.onError(exception);
                return true;
            }
        }
        if (this.image == null) {
            DebugLogger.log(this.logTag, "Acquiring Replay Image");
            this.image = this.subscription.imageBySessionId(this.aeronSessionId);
            return false;
        }
        DebugLogger.log(this.logTag, "Polling Replay Image pos=%d%n", this.image.position());
        this.image.controlledPoll((ControlledFragmentHandler)this.assembler, Integer.MAX_VALUE);
        int messageTrackerCount = this.messageTracker.count;
        int recordingRangeCount = this.recordingRange.count;
        boolean closed = this.image.isClosed();
        boolean endOfStream = this.image.isEndOfStream();
        if (closed || endOfStream) {
            return this.onEndOfImage(recordingRangeCount, closed, endOfStream);
        }
        if (messageTrackerCount < recordingRangeCount) {
            return false;
        }
        return this.onReachedMessageReplayCount(messageTrackerCount, recordingRangeCount);
    }

    private boolean onReachedMessageReplayCount(int messageTrackerCount, int recordingRangeCount) {
        DebugLogger.log(this.logTag, "Finished with messageTrackerCount=%d, recordingRangeCount=%d%n", (long)messageTrackerCount, (long)recordingRangeCount);
        this.replayedMessages += recordingRangeCount;
        this.recordingRange = null;
        return this.ranges.isEmpty();
    }

    private boolean onEndOfImage(int recordingRangeCount, boolean closed, boolean endOfStream) {
        DebugLogger.log(this.logTag, "Finished with Image @ pos=%d, closed=%s, eos=%s%n", this.image.position(), closed, endOfStream);
        this.aeronSessionId = 0;
        this.replayedMessages += recordingRangeCount;
        this.recordingRange = null;
        this.image = null;
        return this.ranges.isEmpty();
    }

    int replayedMessages() {
        return this.replayedMessages;
    }

    private boolean archivingNotComplete(long endPosition, long recordingId) {
        int counterId = RecordingPos.findCounterIdByRecording((CountersReader)this.countersReader, (long)recordingId);
        if (counterId != -1) {
            return this.countersReader.getCounterValue(counterId) < endPosition;
        }
        return false;
    }

    public void close() {
        if (this.aeronSessionId != 0) {
            this.aeronArchive.stopReplay((long)this.aeronSessionId);
        }
    }

    private static class MessageTracker
    implements ControlledFragmentHandler {
        private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
        private final FixMessageDecoder messageDecoder = new FixMessageDecoder();
        private final LogTag logTag;
        private final ControlledFragmentHandler messageHandler;
        int count;
        long sessionId;

        MessageTracker(LogTag logTag, ControlledFragmentHandler messageHandler) {
            this.logTag = logTag;
            this.messageHandler = messageHandler;
        }

        public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
            this.messageHeaderDecoder.wrap(buffer, offset);
            if (this.messageHeaderDecoder.templateId() == 1) {
                ControlledFragmentHandler.Action action;
                int messageOffset = offset + 8;
                if (this.sessionId != -1L) {
                    this.messageDecoder.wrap(buffer, messageOffset, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                    if (this.messageDecoder.session() != this.sessionId) {
                        return ControlledFragmentHandler.Action.CONTINUE;
                    }
                }
                if (DebugLogger.isEnabled(this.logTag)) {
                    DebugLogger.log(this.logTag, "Found Replay Message [%s]%n", this.messageDecoder.body());
                }
                if ((action = this.messageHandler.onFragment(buffer, offset, length, header)) != ControlledFragmentHandler.Action.ABORT) {
                    ++this.count;
                }
                return action;
            }
            return ControlledFragmentHandler.Action.CONTINUE;
        }

        void reset() {
            this.count = 0;
        }
    }
}

