/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.engine.logger.FixMessageConsumer;
import uk.co.real_logic.artio.engine.logger.FixMessagePredicate;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.BufferAsciiSequence;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public final class FixMessagePredicates {
    private FixMessagePredicates() {
    }

    public static FixMessageConsumer filterBy(FixMessageConsumer consumer, FixMessagePredicate predicate) {
        return (message, buffer, offset, length, header) -> {
            int actingVersion = message.sbeSchemaVersion();
            int actingBlockLength = message.sbeBlockLength();
            if (predicate.test(message)) {
                message.wrap(buffer, offset, actingBlockLength, actingVersion);
                consumer.onMessage(message, buffer, offset, length, header);
            }
        };
    }

    public static FixMessagePredicate between(long beginTimestampInclusive, long endTimestampExclusive) {
        return FixMessagePredicates.from(beginTimestampInclusive).and(FixMessagePredicates.to(endTimestampExclusive));
    }

    public static FixMessagePredicate from(long beginTimestampInclusive) {
        return message -> message.timestamp() >= beginTimestampInclusive;
    }

    public static FixMessagePredicate to(long endTimestampExclusive) {
        return message -> message.timestamp() < endTimestampExclusive;
    }

    public static FixMessagePredicate messageTypeOf(String ... messageTypes) {
        IntHashSet hashSet = new IntHashSet();
        Stream.of(messageTypes).mapToInt(GenerationUtil::packMessageType).forEach(arg_0 -> ((IntHashSet)hashSet).add(arg_0));
        return FixMessagePredicates.messageTypeOf(hashSet);
    }

    public static FixMessagePredicate messageTypeOf(int ... messageTypes) {
        IntHashSet hashSet = new IntHashSet();
        IntStream.of(messageTypes).forEach(arg_0 -> ((IntHashSet)hashSet).add(arg_0));
        return FixMessagePredicates.messageTypeOf(hashSet);
    }

    private static FixMessagePredicate messageTypeOf(IntHashSet hashSet) {
        return message -> hashSet.contains(message.messageType());
    }

    public static FixMessagePredicate sessionOf(FixDictionary fixDictionary, String senderCompId, String targetCompId) {
        return FixMessagePredicates.whereHeader(fixDictionary, FixMessagePredicates.senderCompIdOf(senderCompId).and(FixMessagePredicates.targetCompIdOf(targetCompId)));
    }

    public static Predicate<SessionHeaderDecoder> senderCompIdOf(String senderCompId) {
        return FixMessagePredicates.headerMatches(senderCompId, SessionHeaderDecoder::senderCompID, SessionHeaderDecoder::senderCompIDLength);
    }

    public static Predicate<SessionHeaderDecoder> targetCompIdOf(String targetCompId) {
        return FixMessagePredicates.headerMatches(targetCompId, SessionHeaderDecoder::targetCompID, SessionHeaderDecoder::targetCompIDLength);
    }

    public static Predicate<SessionHeaderDecoder> senderSubIdOf(String senderSubId) {
        return FixMessagePredicates.headerMatches(senderSubId, SessionHeaderDecoder::senderSubID, SessionHeaderDecoder::senderSubIDLength);
    }

    public static Predicate<SessionHeaderDecoder> targetSubIdOf(String targetSubId) {
        return FixMessagePredicates.headerMatches(targetSubId, SessionHeaderDecoder::targetSubID, SessionHeaderDecoder::targetSubIDLength);
    }

    public static Predicate<SessionHeaderDecoder> senderLocationIdOf(String senderLocationId) {
        return FixMessagePredicates.headerMatches(senderLocationId, SessionHeaderDecoder::senderLocationID, SessionHeaderDecoder::senderLocationIDLength);
    }

    public static Predicate<SessionHeaderDecoder> targetLocationIdOf(String targetLocationId) {
        return FixMessagePredicates.headerMatches(targetLocationId, SessionHeaderDecoder::targetLocationID, SessionHeaderDecoder::targetLocationIDLength);
    }

    public static Predicate<SessionHeaderDecoder> headerMatches(String value, Function<SessionHeaderDecoder, char[]> charExtractor, ToIntFunction<SessionHeaderDecoder> lengthExtractor) {
        char[] expectedChars = value.toCharArray();
        return header -> {
            char[] actualChars = (char[])charExtractor.apply((SessionHeaderDecoder)header);
            int length = lengthExtractor.applyAsInt((SessionHeaderDecoder)header);
            return CodecUtil.equals((char[])actualChars, (char[])expectedChars, (int)length);
        };
    }

    public static FixMessagePredicate whereHeader(FixDictionary fixDictionary, Predicate<SessionHeaderDecoder> matches) {
        SessionHeaderDecoder header = fixDictionary.makeHeaderDecoder();
        ExpandableArrayBuffer buffer = new ExpandableArrayBuffer(1024);
        MutableAsciiBuffer asciiBuffer = new MutableAsciiBuffer();
        return arg_0 -> FixMessagePredicates.lambda$whereHeader$5(buffer, (AsciiBuffer)asciiBuffer, header, matches, arg_0);
    }

    public static FixMessagePredicate sessionOf(long sessionId) {
        return message -> message.session() == sessionId;
    }

    public static FixMessagePredicate bodyMatches(Pattern pattern) {
        ExpandableArrayBuffer buffer = new ExpandableArrayBuffer(1024);
        BufferAsciiSequence sequence = new BufferAsciiSequence();
        return message -> {
            int length = message.bodyLength();
            buffer.checkLimit(length);
            message.getBody((MutableDirectBuffer)buffer, 0, length);
            sequence.wrap((DirectBuffer)buffer, 0, length);
            return pattern.matcher((CharSequence)sequence).matches();
        };
    }

    public static FixMessagePredicate alwaysTrue() {
        return message -> true;
    }

    private static /* synthetic */ boolean lambda$whereHeader$5(ExpandableArrayBuffer buffer, AsciiBuffer asciiBuffer, SessionHeaderDecoder header, Predicate matches, FixMessageDecoder message) {
        int length = message.bodyLength();
        buffer.checkLimit(length);
        message.getBody((MutableDirectBuffer)buffer, 0, length);
        asciiBuffer.wrap((DirectBuffer)buffer);
        header.decode(asciiBuffer, 0, length);
        return matches.test(header);
    }
}

