/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.logbuffer.Header;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.engine.logger.FixArchiveScanner;
import uk.co.real_logic.artio.engine.logger.FixMessagePredicate;
import uk.co.real_logic.artio.engine.logger.FixMessagePredicates;
import uk.co.real_logic.artio.messages.FixMessageDecoder;

public final class FixArchivePrinter {
    public static void main(String[] args) {
        String aeronDirectoryName = null;
        String aeronChannel = null;
        int queryStreamId = 2;
        int archiveScannerStreamId = 5;
        FixMessagePredicate predicate = FixMessagePredicates.alwaysTrue();
        boolean follow = false;
        Class fixDictionaryType = FixDictionary.findDefault();
        Predicate<SessionHeaderDecoder> headerPredicate = null;
        block40: for (String arg : args) {
            String optionName;
            int eqIndex = arg.indexOf(61);
            switch (optionName = eqIndex != -1 ? arg.substring(2, eqIndex) : arg) {
                case "help": {
                    FixArchivePrinter.printHelp();
                    return;
                }
                case "follow": {
                    follow = true;
                    break;
                }
                default: {
                    FixArchivePrinter.requiredArgument(eqIndex);
                }
            }
            String optionValue = arg.substring(eqIndex + 1);
            switch (optionName) {
                case "from": {
                    predicate = FixMessagePredicates.from(Long.parseLong(optionValue)).and(predicate);
                    continue block40;
                }
                case "to": {
                    predicate = FixMessagePredicates.to(Long.parseLong(optionValue)).and(predicate);
                    continue block40;
                }
                case "message-types": {
                    String[] messageTypes = optionValue.split(",");
                    predicate = FixMessagePredicates.messageTypeOf(messageTypes).and(predicate);
                    continue block40;
                }
                case "sender-comp-id": {
                    headerPredicate = FixArchivePrinter.safeAnd(headerPredicate, FixMessagePredicates.senderCompIdOf(optionValue));
                    continue block40;
                }
                case "target-comp-id": {
                    headerPredicate = FixArchivePrinter.safeAnd(headerPredicate, FixMessagePredicates.targetCompIdOf(optionValue));
                    continue block40;
                }
                case "sender-sub-id": {
                    headerPredicate = FixArchivePrinter.safeAnd(headerPredicate, FixMessagePredicates.senderSubIdOf(optionValue));
                    continue block40;
                }
                case "target-sub-id": {
                    headerPredicate = FixArchivePrinter.safeAnd(headerPredicate, FixMessagePredicates.targetSubIdOf(optionValue));
                    continue block40;
                }
                case "sender-location-id": {
                    headerPredicate = FixArchivePrinter.safeAnd(headerPredicate, FixMessagePredicates.senderLocationIdOf(optionValue));
                    continue block40;
                }
                case "target-location-id": {
                    headerPredicate = FixArchivePrinter.safeAnd(headerPredicate, FixMessagePredicates.targetLocationIdOf(optionValue));
                    continue block40;
                }
                case "query-stream-id": {
                    queryStreamId = Integer.parseInt(optionValue);
                    continue block40;
                }
                case "archive-scanner-stream-id": {
                    archiveScannerStreamId = Integer.parseInt(optionValue);
                    continue block40;
                }
                case "aeron-dir-name": {
                    aeronDirectoryName = optionValue;
                    continue block40;
                }
                case "aeron-channel": {
                    aeronChannel = optionValue;
                    continue block40;
                }
                case "fix-dictionary": {
                    fixDictionaryType = FixDictionary.find((String)optionValue);
                }
            }
        }
        FixArchivePrinter.requiredArgument(aeronDirectoryName, "aeron-dir-name");
        FixArchivePrinter.requiredArgument(aeronChannel, "aeron-channel");
        FixArchivePrinter.scanArchive(aeronDirectoryName, aeronChannel, queryStreamId, predicate, follow, headerPredicate, archiveScannerStreamId, fixDictionaryType);
    }

    private static void requiredArgument(int eqIndex) {
        if (eqIndex == -1) {
            System.err.println("--help and --follow are the only options that don't take a value");
            FixArchivePrinter.printHelp();
            System.exit(-1);
        }
    }

    private static void scanArchive(String aeronDirectoryName, String aeronChannel, int queryStreamId, FixMessagePredicate otherPredicate, boolean follow, Predicate<SessionHeaderDecoder> headerPredicate, int archiveScannerStreamId, Class<? extends FixDictionary> fixDictionaryType) {
        FixDictionary fixDictionary = FixDictionary.of(fixDictionaryType);
        FixMessagePredicate predicate = otherPredicate;
        if (headerPredicate != null) {
            predicate = FixMessagePredicates.whereHeader(fixDictionary, headerPredicate).and(predicate);
        }
        FixArchiveScanner.Context context = new FixArchiveScanner.Context().aeronDirectoryName(aeronDirectoryName).idleStrategy(CommonConfiguration.backoffIdleStrategy());
        FixArchiveScanner scanner = new FixArchiveScanner(context);
        scanner.scan(aeronChannel, queryStreamId, FixMessagePredicates.filterBy(FixArchivePrinter::print, predicate), follow, archiveScannerStreamId);
    }

    private static void requiredArgument(String argument, String description) {
        if (argument == null) {
            System.err.printf("Missing required --%s argument%n", description);
            FixArchivePrinter.printHelp();
            System.exit(-1);
        }
    }

    private static void printHelp() {
        System.out.println("FixArchivePrinter Options");
        System.out.println("All options are specified in the form: --optionName=optionValue");
        FixArchivePrinter.printOption("aeron-dir-name", "Specifies the directory to use for archiving, should be the same as your aeronContext.aeronDirectoryName()", true);
        FixArchivePrinter.printOption("aeron-channel", "Specifies the aeron channel that was used to by the engine", true);
        FixArchivePrinter.printOption("from", "Time in precision of CommonConfiguration.clock() that messages are not earlier than", false);
        FixArchivePrinter.printOption("to", "Time in precision of CommonConfiguration.clock() that messages are not later than", false);
        FixArchivePrinter.printOption("message-types", "Comma separated list of the message types (35=) that are printed", false);
        FixArchivePrinter.printOption("sender-comp-id", "Only print messages where the header's sender comp id field matches this", false);
        FixArchivePrinter.printOption("target-comp-id", "Only print messages where the header's sender comp id field matches this", false);
        FixArchivePrinter.printOption("sender-sub-id", "Only print messages where the header's sender comp id field matches this", false);
        FixArchivePrinter.printOption("target-sub-id", "Only print messages where the header's sender comp id field matches this", false);
        FixArchivePrinter.printOption("sender-location-id", "Only print messages where the header's sender comp id field matches this", false);
        FixArchivePrinter.printOption("target-location-id", "Only print messages where the header's sender comp id field matches this", false);
        FixArchivePrinter.printOption("query-stream-id", "Only print messages where the query-stream-id matches this. This should be your configuration.inboundLibraryStream() or configuration.outboundLibraryStream() Defaults to sent.", false);
        FixArchivePrinter.printOption("follow", "Continue to print out archive messages for a recording that is still in flight. defaults to off", false);
        FixArchivePrinter.printOption("help", "Only prints this help message.", false);
    }

    private static void printOption(String name, String description, boolean required) {
        System.out.printf("  --%-20s [%s] - %s%n", name, required ? "required" : "optional", description);
    }

    private static <T> Predicate<T> safeAnd(Predicate<T> left, Predicate<T> right) {
        return left == null ? right : left.and(right);
    }

    private static void print(FixMessageDecoder message, DirectBuffer buffer, int offset, int length, Header header) {
        System.out.println(message.body());
    }
}

