/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.logbuffer.ControlledFragmentHandler;
import java.util.function.IntFunction;
import org.agrona.collections.Int2ObjectHashMap;
import uk.co.real_logic.artio.engine.framer.SlowPeeker;

class SubscriptionSlowPeeker {
    private final Subscription peekSubscription;
    private final Subscription normalSubscription;
    private final Int2ObjectHashMap<LibrarySlowPeeker> sessionIdToImagePeeker = new Int2ObjectHashMap();
    private final IntFunction<LibrarySlowPeeker> newLibraryPeeker = this::newLibraryPeeker;

    SubscriptionSlowPeeker(Subscription peekSubscription, Subscription normalSubscription) {
        this.peekSubscription = peekSubscription;
        this.normalSubscription = normalSubscription;
    }

    int peek(ControlledFragmentHandler handler) {
        int bytesRead = 0;
        for (LibrarySlowPeeker slowPeeker : this.sessionIdToImagePeeker.values()) {
            bytesRead += slowPeeker.peek(handler);
        }
        return bytesRead;
    }

    LibrarySlowPeeker addLibrary(int aeronSessionId) {
        LibrarySlowPeeker imagePeeker = (LibrarySlowPeeker)this.sessionIdToImagePeeker.computeIfAbsent(aeronSessionId, this.newLibraryPeeker);
        if (imagePeeker == null) {
            return null;
        }
        imagePeeker.addLibrary();
        return imagePeeker;
    }

    private LibrarySlowPeeker newLibraryPeeker(int aeronSessionId) {
        Image peekImage = this.peekSubscription.imageBySessionId(aeronSessionId);
        Image normalImage = this.normalSubscription.imageBySessionId(aeronSessionId);
        if (peekImage == null || normalImage == null) {
            return null;
        }
        return new LibrarySlowPeeker(peekImage, normalImage);
    }

    class LibrarySlowPeeker
    extends SlowPeeker {
        private int libraries;

        LibrarySlowPeeker(Image peekImage, Image normalImage) {
            super(peekImage, normalImage);
        }

        void addLibrary() {
            ++this.libraries;
        }

        void removeLibrary() {
            --this.libraries;
            if (this.libraries == 0) {
                SubscriptionSlowPeeker.this.sessionIdToImagePeeker.remove(this.peekImage.sessionId());
            }
        }

        @Override
        int peek(ControlledFragmentHandler handler) {
            try {
                return super.peek(handler);
            }
            catch (IllegalStateException e) {
                if (this.peekImage.isClosed() || this.normalImage.isClosed()) {
                    this.removeLibrary();
                    return 1;
                }
                throw e;
            }
        }
    }
}

