/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.CRC32;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.engine.ByteBufferUtil;
import uk.co.real_logic.artio.engine.MappedFile;
import uk.co.real_logic.artio.engine.SectorFramer;
import uk.co.real_logic.artio.engine.framer.SessionContext;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.storage.messages.SessionIdDecoder;
import uk.co.real_logic.artio.storage.messages.SessionIdEncoder;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class SessionContexts {
    static final SessionContext DUPLICATE_SESSION = new SessionContext(-3L, -3, -1L, null, -1);
    static final SessionContext UNKNOWN_SESSION = new SessionContext(-1L, -1, -1L, null, -1);
    static final long LOWEST_VALID_SESSION_ID = 1L;
    private static final int HEADER_SIZE = 8;
    private static final int ENCODING_BUFFER_SIZE = 4092;
    private final UnsafeBuffer compositeKeyBuffer = new UnsafeBuffer(new byte[4092]);
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final SessionIdEncoder sessionIdEncoder = new SessionIdEncoder();
    private final AsciiBuffer asciiBuffer = new MutableAsciiBuffer();
    private final int actingBlockLength = this.sessionIdEncoder.sbeBlockLength();
    private final int actingVersion = this.sessionIdEncoder.sbeSchemaVersion();
    private final Function<CompositeKey, SessionContext> onNewLogonFunc = this::onNewLogon;
    private final LongHashSet currentlyAuthenticatedSessionIds = new LongHashSet();
    private final LongHashSet recordedSessions = new LongHashSet();
    private final Map<CompositeKey, SessionContext> compositeToContext = new HashMap<CompositeKey, SessionContext>();
    private final CRC32 crc32 = new CRC32();
    private final SectorFramer sectorFramer;
    private final ByteBuffer byteBuffer;
    private final AtomicBuffer buffer;
    private final SessionIdStrategy idStrategy;
    private final ErrorHandler errorHandler;
    private final MappedFile mappedFile;
    private int filePosition;
    private long counter = 1L;

    public SessionContexts(MappedFile mappedFile, SessionIdStrategy idStrategy, ErrorHandler errorHandler) {
        this.mappedFile = mappedFile;
        this.buffer = mappedFile.buffer();
        this.byteBuffer = this.buffer.byteBuffer();
        this.sectorFramer = new SectorFramer(this.buffer.capacity());
        this.idStrategy = idStrategy;
        this.errorHandler = errorHandler;
        this.loadBuffer();
    }

    private void loadBuffer() {
        this.checkByteBuffer();
        this.initialiseBuffer();
        SessionIdDecoder sessionIdDecoder = new SessionIdDecoder();
        int sectorEnd = 0;
        this.filePosition = 8;
        int lastRecordStart = this.buffer.capacity() - 24;
        while (this.filePosition < lastRecordStart) {
            sectorEnd = this.validateSectorChecksum(this.filePosition, sectorEnd);
            long sessionId = this.wrap(sessionIdDecoder, this.filePosition);
            if (sessionId == 0L) {
                int nextSectorPeekPosition = sectorEnd;
                if (nextSectorPeekPosition > lastRecordStart) {
                    return;
                }
                sessionId = this.wrap(sessionIdDecoder, nextSectorPeekPosition);
                if (sessionId == 0L) {
                    return;
                }
                this.filePosition = nextSectorPeekPosition;
            }
            int sequenceIndex = sessionIdDecoder.sequenceIndex();
            long logonTime = sessionIdDecoder.logonTime();
            int compositeKeyLength = sessionIdDecoder.compositeKeyLength();
            CompositeKey compositeKey = this.idStrategy.load((DirectBuffer)this.buffer, this.filePosition + 24, compositeKeyLength);
            if (compositeKey == null) {
                return;
            }
            this.compositeToContext.put(compositeKey, new SessionContext(sessionId, sequenceIndex, logonTime, this, this.filePosition));
            this.recordedSessions.add(sessionId);
            this.counter = Math.max(this.counter, sessionId + 1L);
            this.filePosition += 24 + compositeKeyLength;
        }
    }

    private long wrap(SessionIdDecoder sessionIdDecoder, int nextSectorPeekPosition) {
        sessionIdDecoder.wrap((DirectBuffer)this.buffer, nextSectorPeekPosition, this.actingBlockLength, this.actingVersion);
        return sessionIdDecoder.sessionId();
    }

    private void checkByteBuffer() {
        if (this.byteBuffer == null) {
            throw new IllegalStateException("Must use atomic buffer backed by a byte buffer");
        }
    }

    private void initialiseBuffer() {
        if (LoggerUtil.initialiseBuffer(this.buffer, this.headerEncoder, this.headerDecoder, this.sessionIdEncoder.sbeSchemaId(), this.sessionIdEncoder.sbeTemplateId(), this.actingVersion, this.actingBlockLength, this.errorHandler)) {
            this.updateChecksum(0, 4092);
            this.mappedFile.force();
        }
    }

    private int validateSectorChecksum(int position, int sectorEnd) {
        if (position > sectorEnd) {
            int nextSectorEnd = sectorEnd + 4096;
            int nextChecksum = nextSectorEnd - 4;
            this.crc32.reset();
            this.byteBuffer.clear();
            ByteBufferUtil.position(this.byteBuffer, sectorEnd);
            ByteBufferUtil.limit(this.byteBuffer, nextChecksum);
            this.crc32.update(this.byteBuffer);
            int calculatedChecksum = (int)this.crc32.getValue();
            int savedChecksum = this.buffer.getInt(nextChecksum);
            SectorFramer.validateCheckSum("session ids", sectorEnd, nextSectorEnd, savedChecksum, calculatedChecksum, this.errorHandler);
            return nextSectorEnd;
        }
        return sectorEnd;
    }

    public SessionContext onLogon(CompositeKey compositeKey) {
        SessionContext sessionContext = this.newSessionContext(compositeKey);
        if (!this.currentlyAuthenticatedSessionIds.add(sessionContext.sessionId())) {
            return DUPLICATE_SESSION;
        }
        this.recordedSessions.add(sessionContext.sessionId());
        return sessionContext;
    }

    SessionContext newSessionContext(CompositeKey compositeKey) {
        return this.compositeToContext.computeIfAbsent(compositeKey, this.onNewLogonFunc);
    }

    private SessionContext onNewLogon(CompositeKey compositeKey) {
        long sessionId = this.counter++;
        return this.assignSessionId(compositeKey, sessionId, -1);
    }

    private SessionContext assignSessionId(CompositeKey compositeKey, long sessionId, int sequenceIndex) {
        int keyPosition = -1;
        int compositeKeyLength = this.idStrategy.save(compositeKey, (MutableDirectBuffer)this.compositeKeyBuffer, 0);
        if (compositeKeyLength == -1) {
            this.errorHandler.onError((Throwable)new IllegalStateException(String.format("Unable to save record session id %d for %s, because the buffer is too small", sessionId, compositeKey)));
            return new SessionContext(sessionId, sequenceIndex, -1L, this, -1);
        }
        if (this.filePosition != -1) {
            keyPosition = this.filePosition = this.sectorFramer.claim(this.filePosition, 24 + compositeKeyLength);
            if (this.filePosition == -1) {
                this.errorHandler.onError((Throwable)new IllegalStateException("Run out of space when storing: " + compositeKey));
            } else {
                this.sessionIdEncoder.wrap((MutableDirectBuffer)this.buffer, this.filePosition).sessionId(sessionId).sequenceIndex(sequenceIndex).logonTime(-1L).compositeKeyLength(compositeKeyLength);
                this.filePosition += 24;
                this.buffer.putBytes(this.filePosition, (DirectBuffer)this.compositeKeyBuffer, 0, compositeKeyLength);
                this.filePosition += compositeKeyLength;
                this.updateChecksum(this.sectorFramer.sectorStart(), this.sectorFramer.checksumOffset());
                this.mappedFile.force();
            }
        }
        return new SessionContext(sessionId, sequenceIndex, -1L, this, keyPosition);
    }

    void sequenceReset(long sessionId) {
        this.compositeToContext.values().stream().filter(context -> context.sessionId() == sessionId).forEach(SessionContext::onSequenceReset);
    }

    private void updateChecksum(int start, int checksumOffset) {
        int endOfData = checksumOffset;
        this.byteBuffer.clear();
        ByteBufferUtil.position(this.byteBuffer, start);
        ByteBufferUtil.limit(this.byteBuffer, endOfData);
        this.crc32.reset();
        this.crc32.update(this.byteBuffer);
        int checksumValue = (int)this.crc32.getValue();
        this.buffer.putInt(checksumOffset, checksumValue);
    }

    public void onDisconnect(long sessionId) {
        this.currentlyAuthenticatedSessionIds.remove(sessionId);
    }

    public void reset(File backupLocation) {
        if (!this.currentlyAuthenticatedSessionIds.isEmpty()) {
            throw new IllegalStateException("There are currently authenticated sessions: " + this.currentlyAuthenticatedSessionIds);
        }
        this.counter = 1L;
        this.currentlyAuthenticatedSessionIds.clear();
        this.compositeToContext.clear();
        if (backupLocation != null) {
            this.mappedFile.transferTo(backupLocation);
        }
        this.buffer.setMemory(0, this.buffer.capacity(), (byte)0);
        this.initialiseBuffer();
    }

    void updateSavedData(int filePosition, int sequenceIndex, long logonTime) {
        this.sessionIdEncoder.wrap((MutableDirectBuffer)this.buffer, filePosition).sequenceIndex(sequenceIndex).logonTime(logonTime);
        int start = SectorFramer.nextSectorStart(filePosition) - 4096;
        int checksumOffset = start + 4092;
        this.updateChecksum(start, checksumOffset);
        this.mappedFile.force();
    }

    long lookupSessionId(CompositeKey compositeKey) {
        SessionContext sessionContext = this.compositeToContext.get(compositeKey);
        if (sessionContext == null) {
            return -1L;
        }
        return sessionContext.sessionId();
    }

    boolean isAuthenticated(long sessionId) {
        return this.currentlyAuthenticatedSessionIds.contains(sessionId);
    }

    boolean isKnownSessionId(long sessionId) {
        return this.compositeToContext.values().stream().anyMatch(context -> context.sessionId() == sessionId);
    }
}

