/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.logbuffer.ControlledFragmentHandler;
import java.util.ArrayList;
import java.util.List;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Long2ObjectHashMap;
import uk.co.real_logic.artio.engine.framer.Continuation;

class RetryManager
implements AutoCloseable {
    private final Long2ObjectHashMap<Continuation> correlationIdToTransactions = new Long2ObjectHashMap();
    private final List<Continuation> continuations = new ArrayList<Continuation>();

    RetryManager() {
    }

    ControlledFragmentHandler.Action retry(long correlationId) {
        Continuation continuation = (Continuation)this.correlationIdToTransactions.get(correlationId);
        if (continuation == null) {
            return null;
        }
        return this.attempt(correlationId, continuation);
    }

    ControlledFragmentHandler.Action firstAttempt(long correlationId, Continuation continuation) {
        this.correlationIdToTransactions.put(correlationId, (Object)continuation);
        return this.attempt(correlationId, continuation);
    }

    private ControlledFragmentHandler.Action attempt(long correlationId, Continuation continuation) {
        ControlledFragmentHandler.Action action = continuation.attemptToAction();
        if (action != ControlledFragmentHandler.Action.ABORT) {
            this.correlationIdToTransactions.remove(correlationId);
        }
        return action;
    }

    void schedule(Continuation continuation) {
        this.continuations.add(continuation);
    }

    int attemptSteps() {
        return CollectionUtil.removeIf(this.continuations, step -> step.attemptToAction() == ControlledFragmentHandler.Action.CONTINUE);
    }

    @Override
    public void close() {
        this.continuations.forEach(Continuation::close);
        this.correlationIdToTransactions.values().forEach(Continuation::close);
    }
}

