/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.Clock;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.decoder.AbstractLogonDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.dictionary.SessionConstants;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.ByteBufferUtil;
import uk.co.real_logic.artio.engine.framer.AcceptorLogonResult;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.GatewaySessions;
import uk.co.real_logic.artio.engine.framer.PasswordCleaner;
import uk.co.real_logic.artio.engine.framer.SessionContexts;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

class ReceiverEndPoint {
    private static final char INVALID_MESSAGE_TYPE = '-';
    private static final byte BODY_LENGTH_FIELD = 9;
    private static final byte BEGIN_STRING_FIELD = 8;
    private static final byte CHECKSUM0 = 1;
    private static final byte CHECKSUM1 = 49;
    private static final byte CHECKSUM2 = 48;
    private static final byte CHECKSUM3 = 61;
    private static final int MIN_CHECKSUM_SIZE = " 10=".length() + 1;
    private static final int CHECKSUM_TAG_SIZE = "10=".length();
    private static final int SOCKET_DISCONNECTED = -1;
    private static final int UNKNOWN_MESSAGE_TYPE = -1;
    private static final int BREAK = -1;
    private static final int UNKNOWN_INDEX_BACKPRESSURED = -2;
    private final AbstractLogonDecoder acceptorLogon;
    private final TcpChannel channel;
    private final GatewayPublication publication;
    private final long connectionId;
    private final SessionContexts sessionContexts;
    private final AtomicCounter messagesRead;
    private final Framer framer;
    private final ErrorHandler errorHandler;
    private final PasswordCleaner passwordCleaner = new PasswordCleaner();
    private final MutableAsciiBuffer buffer;
    private final ByteBuffer byteBuffer;
    private final GatewaySessions gatewaySessions;
    private final Clock clock;
    private int libraryId;
    private GatewaySession gatewaySession;
    private long sessionId;
    private int sequenceIndex;
    private int usedBufferData = 0;
    private boolean hasDisconnected = false;
    private SelectionKey selectionKey;
    private boolean isPaused = false;
    private AcceptorLogonResult pendingAcceptorLogon;
    private boolean hasNotifiedFramerOfLogonMessageReceived;
    private int pendingAcceptorLogonMsgOffset;
    private int pendingAcceptorLogonMsgLength;
    private long lastReadTimestamp;

    ReceiverEndPoint(TcpChannel channel, int bufferSize, GatewayPublication publication, long connectionId, long sessionId, int sequenceIndex, SessionContexts sessionContexts, AtomicCounter messagesRead, Framer framer, ErrorHandler errorHandler, int libraryId, GatewaySessions gatewaySessions, Clock clock, FixDictionary acceptorFixDictionary) {
        Objects.requireNonNull(publication, "publication");
        Objects.requireNonNull(sessionContexts, "sessionContexts");
        Objects.requireNonNull(gatewaySessions, "gatewaySessions");
        Objects.requireNonNull(clock, "clock");
        this.channel = channel;
        this.publication = publication;
        this.connectionId = connectionId;
        this.sessionId = sessionId;
        this.sequenceIndex = sequenceIndex;
        this.sessionContexts = sessionContexts;
        this.messagesRead = messagesRead;
        this.framer = framer;
        this.errorHandler = errorHandler;
        this.libraryId = libraryId;
        this.gatewaySessions = gatewaySessions;
        this.clock = clock;
        this.acceptorLogon = acceptorFixDictionary.makeLogonDecoder();
        this.byteBuffer = ByteBuffer.allocateDirect(bufferSize);
        this.buffer = new MutableAsciiBuffer(this.byteBuffer);
    }

    public long connectionId() {
        return this.connectionId;
    }

    int poll() {
        if (this.isPaused || this.hasDisconnected()) {
            return 0;
        }
        if (this.pendingAcceptorLogon != null) {
            return this.pollPendingLogon();
        }
        try {
            long latestReadTimestamp = this.clock.time();
            int bytesRead = this.readData();
            if (this.frameMessages(bytesRead == 0 ? this.lastReadTimestamp : latestReadTimestamp)) {
                this.lastReadTimestamp = latestReadTimestamp;
                return bytesRead;
            }
            this.lastReadTimestamp = latestReadTimestamp;
            return -bytesRead;
        }
        catch (ClosedChannelException ex) {
            this.onDisconnectDetected();
            return 1;
        }
        catch (Exception ex) {
            if (!Exceptions.isJustDisconnect((Exception)ex)) {
                this.errorHandler.onError((Throwable)ex);
            }
            this.onDisconnectDetected();
            return 1;
        }
    }

    private int pollPendingLogon() {
        if (this.pendingAcceptorLogon.poll()) {
            if (this.pendingAcceptorLogon.isAccepted()) {
                if (!this.hasNotifiedFramerOfLogonMessageReceived) {
                    this.framer.onLogonMessageReceived(this.gatewaySession);
                    this.hasNotifiedFramerOfLogonMessageReceived = true;
                }
                return this.sendInitialLoginMessage();
            }
            this.completeDisconnect(this.pendingAcceptorLogon.reason());
        }
        return 1;
    }

    private int sendInitialLoginMessage() {
        int sequenceIndex;
        int offset = this.pendingAcceptorLogonMsgOffset;
        int length = this.pendingAcceptorLogonMsgLength;
        if (this.isPaused) {
            this.moveRemainingDataToBufferStart(offset);
            return offset;
        }
        long sessionId = this.gatewaySession.sessionId();
        if (this.saveMessage(offset, 65, length, sessionId, sequenceIndex = this.gatewaySession.sequenceIndex(), this.lastReadTimestamp)) {
            this.sessionId = sessionId;
            this.sequenceIndex = sequenceIndex;
            this.pendingAcceptorLogon = null;
            this.framer.receiverEndPointPollingOptional(this.connectionId);
            this.moveRemainingDataToBufferStart(offset += length);
            return offset;
        }
        return offset;
    }

    private int readData() throws IOException {
        int dataRead = this.channel.read(this.byteBuffer);
        if (dataRead != -1) {
            if (dataRead > 0) {
                DebugLogger.log(LogTag.FIX_MESSAGE_TCP, "Read     %s%n", (DirectBuffer)this.buffer, 0, dataRead);
            }
            this.usedBufferData += dataRead;
        } else {
            this.onDisconnectDetected();
        }
        return dataRead;
    }

    boolean retryFrameMessages() {
        return this.frameMessages(this.lastReadTimestamp);
    }

    private boolean frameMessages(long readTimestamp) {
        int offset = 0;
        while (this.usedBufferData >= offset + SessionConstants.MIN_MESSAGE_SIZE) {
            try {
                int startOfChecksumTag;
                int endOfChecksumTag;
                int startOfBodyLength = this.scanForBodyLength(offset, readTimestamp);
                if (startOfBodyLength < 0) {
                    return startOfBodyLength == -1;
                }
                int endOfBodyLength = this.scanEndOfBodyLength(startOfBodyLength);
                if (endOfBodyLength == -1 || (endOfChecksumTag = (startOfChecksumTag = endOfBodyLength + this.getBodyLength(startOfBodyLength, endOfBodyLength)) + MIN_CHECKSUM_SIZE) >= this.usedBufferData) break;
                if (!this.validateBodyLength(startOfChecksumTag)) {
                    int endOfMessage = this.onInvalidBodyLength(offset, startOfChecksumTag, readTimestamp);
                    if (endOfMessage == -1) break;
                    return true;
                }
                int startOfChecksumValue = startOfChecksumTag + MIN_CHECKSUM_SIZE;
                int endOfMessage = this.scanEndOfMessage(startOfChecksumValue);
                if (endOfMessage == -1) break;
                int messageType = this.getMessageType(endOfBodyLength, endOfMessage);
                int length = endOfMessage + 1 - offset;
                if (!this.validateChecksum(endOfMessage, startOfChecksumValue, offset, startOfChecksumTag)) {
                    DebugLogger.log(LogTag.FIX_MESSAGE, "Invalidated: %s%n", (DirectBuffer)this.buffer, offset, length);
                    if (this.saveInvalidChecksumMessage(offset, messageType, length, readTimestamp)) {
                        return false;
                    }
                } else {
                    if (this.requiresAuthentication()) {
                        this.startAuthenticationFlow(offset, length, messageType);
                        return true;
                    }
                    this.messagesRead.incrementOrdered();
                    if (!this.saveMessage(offset, messageType, length, readTimestamp)) {
                        return false;
                    }
                }
                offset += length;
            }
            catch (IllegalArgumentException ex) {
                return !this.invalidateMessage(offset, readTimestamp);
            }
            catch (Exception ex) {
                this.errorHandler.onError((Throwable)ex);
                break;
            }
        }
        this.moveRemainingDataToBufferStart(offset);
        return true;
    }

    private int onInvalidBodyLength(int offset, int startOfChecksumTag, long readTimestamp) {
        int endOfScanPoint;
        int checksumTagScanPoint = startOfChecksumTag + 1;
        while (!this.isStartOfChecksum(checksumTagScanPoint)) {
            endOfScanPoint = checksumTagScanPoint + CHECKSUM_TAG_SIZE;
            if (endOfScanPoint >= this.usedBufferData) {
                return -1;
            }
            ++checksumTagScanPoint;
        }
        endOfScanPoint = checksumTagScanPoint + CHECKSUM_TAG_SIZE;
        int endOfMessage = this.buffer.scan(endOfScanPoint, this.usedBufferData, (byte)1) + 1;
        if (endOfMessage > this.usedBufferData) {
            return -1;
        }
        if (this.saveInvalidMessage(offset, endOfMessage, readTimestamp)) {
            DebugLogger.log(LogTag.FIX_MESSAGE, "Invalidated: %s%n", (DirectBuffer)this.buffer, offset, endOfMessage - offset);
            return offset;
        }
        this.moveRemainingDataToBufferStart(endOfMessage);
        return offset;
    }

    boolean requiresAuthentication() {
        return this.sessionId == -1L;
    }

    private boolean validateChecksum(int endOfMessage, int startOfChecksumValue, int offset, int startOfChecksumTag) {
        int computedChecksum;
        int expectedChecksum = this.buffer.getInt(startOfChecksumValue - 1, endOfMessage);
        return expectedChecksum == (computedChecksum = this.buffer.computeChecksum(offset, startOfChecksumTag + 1));
    }

    private int scanEndOfMessage(int startOfChecksumValue) {
        return this.buffer.scan(startOfChecksumValue, this.usedBufferData - 1, (byte)1);
    }

    private int scanForBodyLength(int offset, long readTimestamp) {
        if (this.invalidTag(offset, (byte)8)) {
            return this.invalidateMessageUnknownIndex(offset, readTimestamp);
        }
        int endOfCommonPrefix = this.scanNextField(offset + 2);
        if (endOfCommonPrefix == -1) {
            return this.invalidateMessageUnknownIndex(offset, readTimestamp);
        }
        int startOfBodyTag = endOfCommonPrefix + 1;
        if (this.invalidTag(startOfBodyTag, (byte)9)) {
            return this.invalidateMessageUnknownIndex(offset, readTimestamp);
        }
        return startOfBodyTag + 2;
    }

    private int invalidateMessageUnknownIndex(int offset, long readTimestamp) {
        return this.invalidateMessage(offset, readTimestamp) ? -2 : -1;
    }

    private int scanEndOfBodyLength(int startOfBodyLength) {
        return this.buffer.scan(startOfBodyLength + 1, this.usedBufferData - 1, (byte)1);
    }

    private int scanNextField(int startScan) {
        return this.buffer.scan(startScan + 1, this.usedBufferData - 1, (byte)1);
    }

    private void startAuthenticationFlow(int offset, int length, int messageType) {
        if (this.sessionId != -1L) {
            return;
        }
        if (messageType == 65) {
            this.acceptorLogon.decode((AsciiBuffer)this.buffer, offset, length);
            this.pendingAcceptorLogonMsgOffset = offset;
            this.pendingAcceptorLogonMsgLength = length;
            this.hasNotifiedFramerOfLogonMessageReceived = false;
            this.pendingAcceptorLogon = this.gatewaySessions.authenticate(this.acceptorLogon, this.connectionId(), this.gatewaySession, this.channel);
        } else {
            this.completeDisconnect(DisconnectReason.FIRST_MESSAGE_NOT_LOGON);
        }
    }

    private boolean stashIfBackPressured(int offset, long position) {
        boolean backPressured = Pressure.isBackPressured(position);
        if (backPressured) {
            this.moveRemainingDataToBufferStart(offset);
        }
        return backPressured;
    }

    private boolean saveMessage(int offset, int messageType, int length, long readTimestamp) {
        return this.saveMessage(offset, messageType, length, this.sessionId, this.sequenceIndex, readTimestamp);
    }

    private boolean saveMessage(int messageOffset, int messageType, int messageLength, long sessionId, int sequenceIndex, long readTimestamp) {
        long position;
        boolean isUserRequest;
        MutableAsciiBuffer buffer = this.buffer;
        int offset = messageOffset;
        int length = messageLength;
        boolean bl = isUserRequest = messageType == 17730;
        if (messageType == 65 || isUserRequest) {
            if (isUserRequest) {
                this.gatewaySessions.onUserRequest((DirectBuffer)buffer, offset, length, this.gatewaySession.fixDictionary(), this.connectionId, sessionId);
            }
            this.passwordCleaner.clean((DirectBuffer)buffer, offset, length);
            offset = 0;
            buffer = this.passwordCleaner.cleanedBuffer();
            length = this.passwordCleaner.cleanedLength();
        }
        if (Pressure.isBackPressured(position = this.publication.saveMessage((DirectBuffer)buffer, offset, length, this.libraryId, messageType, sessionId, sequenceIndex, this.connectionId, MessageStatus.OK, 0, readTimestamp))) {
            this.moveRemainingDataToBufferStart(offset);
            return false;
        }
        this.gatewaySession.onMessage((DirectBuffer)buffer, offset, length, messageType, sessionId);
        return true;
    }

    private boolean validateBodyLength(int startOfChecksumTag) {
        return this.isStartOfChecksum(startOfChecksumTag);
    }

    private boolean isStartOfChecksum(int startOfChecksumTag) {
        return this.buffer.getByte(startOfChecksumTag) == 1 && this.buffer.getByte(startOfChecksumTag + 1) == 49 && this.buffer.getByte(startOfChecksumTag + 2) == 48 && this.buffer.getByte(startOfChecksumTag + 3) == 61;
    }

    private int getMessageType(int endOfBodyLength, int indexOfLastByteOfMessage) {
        int start = this.buffer.scan(endOfBodyLength, indexOfLastByteOfMessage, '=');
        if (this.buffer.getByte(start + 2) == 1) {
            return this.buffer.getByte(start + 1);
        }
        return this.buffer.getMessageType(start + 1, 2);
    }

    private int getBodyLength(int startOfBodyLength, int endOfBodyLength) {
        return this.buffer.getNatural(startOfBodyLength, endOfBodyLength);
    }

    private boolean invalidTag(int startOfBodyTag, byte tagId) {
        try {
            return this.buffer.getDigit(startOfBodyTag) != tagId || this.buffer.getChar(startOfBodyTag + 1) != '=';
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    private void moveRemainingDataToBufferStart(int offset) {
        this.usedBufferData -= offset;
        this.buffer.putBytes(0, (DirectBuffer)this.buffer, offset, this.usedBufferData);
        ByteBufferUtil.position(this.byteBuffer, this.usedBufferData);
    }

    private boolean invalidateMessage(int offset, long readTimestamp) {
        DebugLogger.log(LogTag.FIX_MESSAGE, "Invalidated: %s%n", (DirectBuffer)this.buffer, offset, SessionConstants.MIN_MESSAGE_SIZE);
        return this.saveInvalidMessage(offset, readTimestamp);
    }

    private boolean saveInvalidMessage(int offset, int startOfChecksumTag, long readTimestamp) {
        long position = this.publication.saveMessage((DirectBuffer)this.buffer, offset, startOfChecksumTag, this.libraryId, -1, this.sessionId, this.sequenceIndex, this.connectionId, MessageStatus.INVALID_BODYLENGTH, 0, readTimestamp);
        return this.stashIfBackPressured(offset, position);
    }

    private boolean saveInvalidMessage(int offset, long readTimestamp) {
        long position = this.publication.saveMessage((DirectBuffer)this.buffer, offset, this.usedBufferData, this.libraryId, 45, this.sessionId, this.sequenceIndex, this.connectionId, MessageStatus.INVALID, 0, readTimestamp);
        boolean backPressured = this.stashIfBackPressured(offset, position);
        if (!backPressured) {
            this.clearBuffer();
        }
        return backPressured;
    }

    private void clearBuffer() {
        this.moveRemainingDataToBufferStart(this.usedBufferData);
    }

    private boolean saveInvalidChecksumMessage(int offset, int messageType, int length, long readTimestamp) {
        long position = this.publication.saveMessage((DirectBuffer)this.buffer, offset, length, this.libraryId, messageType, this.sessionId, this.sequenceIndex, this.connectionId, MessageStatus.INVALID_CHECKSUM, 0, readTimestamp);
        return this.stashIfBackPressured(offset, position);
    }

    public void close(DisconnectReason reason) {
        this.closeResources();
        if (!this.hasDisconnected) {
            this.disconnectEndpoint(reason);
        }
    }

    private void closeResources() {
        try {
            this.channel.close();
            this.messagesRead.close();
        }
        catch (Exception ex) {
            this.errorHandler.onError((Throwable)ex);
        }
    }

    private void removeEndpointFromFramer() {
        this.framer.onDisconnect(this.libraryId, this.connectionId, null);
    }

    private void onDisconnectDetected() {
        this.completeDisconnect(DisconnectReason.REMOTE_DISCONNECT);
    }

    void onNoLogonDisconnect() {
        this.completeDisconnect(DisconnectReason.NO_LOGON);
    }

    private void completeDisconnect(DisconnectReason reason) {
        this.disconnectEndpoint(reason);
        this.removeEndpointFromFramer();
    }

    private void disconnectEndpoint(DisconnectReason reason) {
        this.framer.schedule(() -> this.publication.saveDisconnect(this.libraryId, this.connectionId, reason));
        this.sessionContexts.onDisconnect(this.sessionId);
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
        }
        this.hasDisconnected = true;
    }

    boolean hasDisconnected() {
        return this.hasDisconnected;
    }

    public void register(Selector selector) throws IOException {
        this.selectionKey = this.channel.register(selector, 1, this);
    }

    public int libraryId() {
        return this.libraryId;
    }

    public void libraryId(int libraryId) {
        this.libraryId = libraryId;
    }

    void gatewaySession(GatewaySession gatewaySession) {
        this.gatewaySession = gatewaySession;
    }

    void pause() {
        this.isPaused = true;
    }

    void play() {
        this.isPaused = false;
    }

    public String toString() {
        return "ReceiverEndPoint: " + this.connectionId;
    }
}

