/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.Image;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import org.agrona.concurrent.QueuedPipe;
import org.agrona.concurrent.SystemEpochClock;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.EngineContext;
import uk.co.real_logic.artio.engine.RecordingCoordinator;
import uk.co.real_logic.artio.engine.framer.AdminCommand;
import uk.co.real_logic.artio.engine.framer.EndPointFactory;
import uk.co.real_logic.artio.engine.framer.FinalImagePositions;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.GatewaySessions;
import uk.co.real_logic.artio.engine.framer.LibraryInfo;
import uk.co.real_logic.artio.engine.framer.LookupSessionIdCommand;
import uk.co.real_logic.artio.engine.framer.QueryLibrariesCommand;
import uk.co.real_logic.artio.engine.framer.ResetSequenceNumberCommand;
import uk.co.real_logic.artio.engine.framer.ResetSessionIdsCommand;
import uk.co.real_logic.artio.engine.framer.SessionContexts;
import uk.co.real_logic.artio.engine.framer.StartCloseCommand;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.protocol.Streams;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.timing.EngineTimers;

public class FramerContext {
    private static final int ADMIN_COMMAND_CAPACITY = 16;
    private final QueuedPipe<AdminCommand> adminCommands = new ManyToOneConcurrentArrayQueue(16);
    private final Framer framer;
    private final GatewaySessions gatewaySessions;
    private final SequenceNumberIndexReader sentSequenceNumberIndex;
    private final SequenceNumberIndexReader receivedSequenceNumberIndex;
    private final GatewayPublication outboundPublication;
    private final GatewayPublication inboundPublication;
    private final SessionContexts sessionContexts;

    public FramerContext(EngineConfiguration configuration, FixCounters fixCounters, EngineContext engineContext, ErrorHandler errorHandler, Image replayImage, Image slowReplayImage, EngineTimers timers, AgentInvoker conductorAgentInvoker, RecordingCoordinator recordingCoordinator) {
        SessionIdStrategy sessionIdStrategy = configuration.sessionIdStrategy();
        IdleStrategy idleStrategy = configuration.framerIdleStrategy();
        Streams outboundLibraryStreams = engineContext.outboundLibraryStreams();
        SystemEpochClock epochClock = new SystemEpochClock();
        this.sessionContexts = new SessionContexts(configuration.sessionIdBuffer(), sessionIdStrategy, errorHandler);
        this.inboundPublication = engineContext.inboundPublication();
        this.outboundPublication = outboundLibraryStreams.gatewayPublication(idleStrategy, "outboundPublication");
        this.sentSequenceNumberIndex = new SequenceNumberIndexReader(configuration.sentSequenceNumberBuffer(), errorHandler);
        this.receivedSequenceNumberIndex = new SequenceNumberIndexReader(configuration.receivedSequenceNumberBuffer(), errorHandler);
        this.gatewaySessions = new GatewaySessions((EpochClock)epochClock, this.outboundPublication, sessionIdStrategy, configuration.sessionCustomisationStrategy(), fixCounters, configuration.authenticationStrategy(), configuration.messageValidationStrategy(), configuration.sessionBufferSize(), configuration.sendingTimeWindowInMs(), configuration.reasonableTransmissionTimeInMs(), configuration.logAllMessages(), errorHandler, this.sessionContexts, configuration.sessionPersistenceStrategy(), this.sentSequenceNumberIndex, this.receivedSequenceNumberIndex);
        EndPointFactory endPointFactory = new EndPointFactory(configuration, this.sessionContexts, this.inboundPublication, fixCounters, errorHandler, this.gatewaySessions, engineContext.senderSequenceNumbers());
        FinalImagePositions finalImagePositions = new FinalImagePositions();
        this.framer = new Framer((EpochClock)epochClock, timers.outboundTimer(), timers.sendTimer(), configuration, endPointFactory, engineContext.outboundLibrarySubscription("outboundLibrarySubscription", finalImagePositions), engineContext.outboundLibrarySubscription("outboundSlowSubscription", null), replayImage, slowReplayImage, engineContext.inboundReplayQuery(), this.outboundPublication, this.inboundPublication, this.adminCommands, sessionIdStrategy, this.sessionContexts, this.sentSequenceNumberIndex, this.receivedSequenceNumberIndex, this.gatewaySessions, errorHandler, configuration.agentNamePrefix(), engineContext.inboundCompletionPosition(), engineContext.outboundLibraryCompletionPosition(), finalImagePositions, conductorAgentInvoker, recordingCoordinator);
    }

    public Agent framer() {
        return this.framer;
    }

    public Reply<List<LibraryInfo>> libraries() {
        QueryLibrariesCommand reply = new QueryLibrariesCommand();
        if (this.adminCommands.offer((Object)reply)) {
            return reply;
        }
        return null;
    }

    public Reply<?> resetSequenceNumber(long sessionId) {
        ResetSequenceNumberCommand reply = new ResetSequenceNumberCommand(sessionId, this.gatewaySessions, this.sessionContexts, this.receivedSequenceNumberIndex, this.sentSequenceNumberIndex, this.inboundPublication, this.outboundPublication);
        if (this.adminCommands.offer((Object)reply)) {
            return reply;
        }
        return null;
    }

    public Reply<?> resetSessionIds(File backupLocation) {
        ResetSessionIdsCommand command;
        if (backupLocation != null && !backupLocation.exists()) {
            try {
                if (!backupLocation.createNewFile()) {
                    throw new IllegalStateException("Could not create: " + backupLocation);
                }
            }
            catch (IOException ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
        }
        if (this.adminCommands.offer((Object)(command = new ResetSessionIdsCommand(backupLocation)))) {
            return command;
        }
        return null;
    }

    public void startClose() {
        IdleStrategy idleStrategy = CommonConfiguration.backoffIdleStrategy();
        StartCloseCommand command = new StartCloseCommand();
        while (!this.adminCommands.offer((Object)command)) {
            idleStrategy.idle();
        }
        idleStrategy.reset();
        while (!command.hasCompleted()) {
            idleStrategy.idle();
        }
        idleStrategy.reset();
        if (command.hasErrored()) {
            LangUtil.rethrowUnchecked((Throwable)command.error());
        }
    }

    public Reply<Long> lookupSessionId(String localCompId, String remoteCompId, String localSubId, String remoteSubId, String localLocationId, String remoteLocationId) {
        LookupSessionIdCommand command = new LookupSessionIdCommand(localCompId, remoteCompId, localSubId, remoteSubId, localLocationId, remoteLocationId);
        if (this.adminCommands.offer((Object)command)) {
            return command;
        }
        return null;
    }
}

