/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.ControlledFragmentAssembler;
import io.aeron.Image;
import io.aeron.ImageControlledFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.QueuedPipe;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LivenessDetector;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.CompletionPosition;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.PositionSender;
import uk.co.real_logic.artio.engine.RecordingCoordinator;
import uk.co.real_logic.artio.engine.framer.AdminCommand;
import uk.co.real_logic.artio.engine.framer.BlockablePosition;
import uk.co.real_logic.artio.engine.framer.CatchupReplayer;
import uk.co.real_logic.artio.engine.framer.CloseOperation;
import uk.co.real_logic.artio.engine.framer.ConnectingSession;
import uk.co.real_logic.artio.engine.framer.Continuation;
import uk.co.real_logic.artio.engine.framer.EndPointFactory;
import uk.co.real_logic.artio.engine.framer.EngineLibraryInfo;
import uk.co.real_logic.artio.engine.framer.FinalImagePositions;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.GatewaySessions;
import uk.co.real_logic.artio.engine.framer.LibraryInfo;
import uk.co.real_logic.artio.engine.framer.LiveLibraryInfo;
import uk.co.real_logic.artio.engine.framer.LookupSessionIdCommand;
import uk.co.real_logic.artio.engine.framer.QueryLibrariesCommand;
import uk.co.real_logic.artio.engine.framer.ReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.ReceiverEndPoints;
import uk.co.real_logic.artio.engine.framer.ResetSequenceNumberCommand;
import uk.co.real_logic.artio.engine.framer.ResetSessionIdsCommand;
import uk.co.real_logic.artio.engine.framer.RetryManager;
import uk.co.real_logic.artio.engine.framer.SenderEndPoint;
import uk.co.real_logic.artio.engine.framer.SenderEndPoints;
import uk.co.real_logic.artio.engine.framer.SessionContext;
import uk.co.real_logic.artio.engine.framer.SessionContexts;
import uk.co.real_logic.artio.engine.framer.SlowPeeker;
import uk.co.real_logic.artio.engine.framer.StartCloseCommand;
import uk.co.real_logic.artio.engine.framer.SubscriptionSlowPeeker;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.engine.framer.TcpChannelSupplier;
import uk.co.real_logic.artio.engine.framer.UnitOfWork;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.messages.ConnectionType;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.GatewayError;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.messages.SequenceNumberType;
import uk.co.real_logic.artio.messages.SessionReplyStatus;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.messages.SessionStatus;
import uk.co.real_logic.artio.messages.SlowStatus;
import uk.co.real_logic.artio.protocol.EngineEndPointHandler;
import uk.co.real_logic.artio.protocol.EngineProtocolSubscription;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.protocol.ProtocolHandler;
import uk.co.real_logic.artio.protocol.ProtocolSubscription;
import uk.co.real_logic.artio.protocol.ReplayProtocolSubscription;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.timing.Timer;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

class Framer
implements Agent,
EngineEndPointHandler,
ProtocolHandler {
    private final RetryManager retryManager = new RetryManager();
    private final List<ResetSequenceNumberCommand> replies = new ArrayList<ResetSequenceNumberCommand>();
    private final Int2ObjectHashMap<LiveLibraryInfo> idToLibrary = new Int2ObjectHashMap();
    private final List<LiveLibraryInfo> librariesBeingAcquired = new ArrayList<LiveLibraryInfo>();
    private final Consumer<AdminCommand> onAdminCommand = command -> command.execute(this);
    private final TcpChannelSupplier.NewChannelHandler onNewConnectionFunc = this::onNewConnection;
    private final Predicate<LiveLibraryInfo> retryAcquireLibrarySessionsFunc = this::retryAcquireLibrarySessions;
    private final TcpChannelSupplier channelSupplier;
    private final EpochClock epochClock;
    private final Timer outboundTimer;
    private final Timer sendTimer;
    private final ControlledFragmentHandler librarySubscriber;
    private final ControlledFragmentHandler replaySubscriber;
    private final ControlledFragmentHandler replaySlowSubscriber;
    private final ReceiverEndPoints receiverEndPoints;
    private final ControlledFragmentAssembler senderEndPointAssembler;
    private final SenderEndPoints senderEndPoints;
    private final EngineConfiguration configuration;
    private final EndPointFactory endPointFactory;
    private final Subscription librarySubscription;
    private final SubscriptionSlowPeeker librarySlowPeeker;
    private final Image replayImage;
    private final SlowPeeker replaySlowPeeker;
    private final BlockablePosition engineBlockablePosition;
    private final GatewayPublication inboundPublication;
    private final String agentNamePrefix;
    private final CompletionPosition inboundCompletionPosition;
    private final CompletionPosition outboundLibraryCompletionPosition;
    private final FinalImagePositions finalImagePositions;
    private final SessionIdStrategy sessionIdStrategy;
    private final SessionContexts sessionContexts;
    private final QueuedPipe<AdminCommand> adminCommands;
    private final SequenceNumberIndexReader sentSequenceNumberIndex;
    private final SequenceNumberIndexReader receivedSequenceNumberIndex;
    private final int inboundBytesReceivedLimit;
    private final int outboundLibraryFragmentLimit;
    private final int replayFragmentLimit;
    private final GatewaySessions gatewaySessions;
    private final Consumer<GatewaySession> onSessionlogon = this::onSessionLogon;
    private final ReplayQuery inboundMessages;
    private final ErrorHandler errorHandler;
    private final GatewayPublication outboundPublication;
    private final Long2LongHashMap resendSlowStatus = new Long2LongHashMap(-1L);
    private final Long2LongHashMap resendNotSlowStatus = new Long2LongHashMap(-1L);
    private final AgentInvoker conductorAgentInvoker;
    private final RecordingCoordinator recordingCoordinator;
    private final PositionSender nonLoggingPositionSender;
    private final SessionHeaderDecoder acceptorHeaderDecoder;
    private final AsciiBuffer asciiBuffer = new MutableAsciiBuffer();
    private long nextConnectionId = (long)(Math.random() * 9.223372036854776E18);
    private boolean performingCloseOperation = false;

    Framer(EpochClock epochClock, Timer outboundTimer, Timer sendTimer, EngineConfiguration configuration, EndPointFactory endPointFactory, Subscription librarySubscription, Subscription slowSubscription, Image replayImage, Image replaySlowImage, ReplayQuery inboundMessages, GatewayPublication outboundPublication, GatewayPublication inboundPublication, QueuedPipe<AdminCommand> adminCommands, SessionIdStrategy sessionIdStrategy, SessionContexts sessionContexts, SequenceNumberIndexReader sentSequenceNumberIndex, SequenceNumberIndexReader receivedSequenceNumberIndex, GatewaySessions gatewaySessions, ErrorHandler errorHandler, String agentNamePrefix, CompletionPosition inboundCompletionPosition, CompletionPosition outboundLibraryCompletionPosition, FinalImagePositions finalImagePositions, AgentInvoker conductorAgentInvoker, RecordingCoordinator recordingCoordinator) {
        this.epochClock = epochClock;
        this.outboundTimer = outboundTimer;
        this.sendTimer = sendTimer;
        this.configuration = configuration;
        this.endPointFactory = endPointFactory;
        this.librarySubscription = librarySubscription;
        this.replayImage = replayImage;
        this.gatewaySessions = gatewaySessions;
        this.inboundMessages = inboundMessages;
        this.errorHandler = errorHandler;
        this.outboundPublication = outboundPublication;
        this.inboundPublication = inboundPublication;
        this.agentNamePrefix = agentNamePrefix;
        this.inboundCompletionPosition = inboundCompletionPosition;
        this.outboundLibraryCompletionPosition = outboundLibraryCompletionPosition;
        this.senderEndPoints = new SenderEndPoints(errorHandler);
        this.conductorAgentInvoker = conductorAgentInvoker;
        this.recordingCoordinator = recordingCoordinator;
        this.senderEndPointAssembler = new ControlledFragmentAssembler((ControlledFragmentHandler)this.senderEndPoints, 0, true);
        this.sessionIdStrategy = sessionIdStrategy;
        this.sessionContexts = sessionContexts;
        this.adminCommands = adminCommands;
        this.sentSequenceNumberIndex = sentSequenceNumberIndex;
        this.receivedSequenceNumberIndex = receivedSequenceNumberIndex;
        this.finalImagePositions = finalImagePositions;
        this.acceptorHeaderDecoder = configuration.acceptorfixDictionary().makeHeaderDecoder();
        this.receiverEndPoints = new ReceiverEndPoints(errorHandler);
        this.librarySlowPeeker = new SubscriptionSlowPeeker(slowSubscription, librarySubscription);
        this.outboundLibraryFragmentLimit = configuration.outboundLibraryFragmentLimit();
        this.replayFragmentLimit = configuration.replayFragmentLimit();
        this.inboundBytesReceivedLimit = configuration.inboundBytesReceivedLimit();
        this.replaySlowPeeker = new SlowPeeker(replaySlowImage, replayImage);
        endPointFactory.replaySlowPeeker(this.replaySlowPeeker);
        this.engineBlockablePosition = this.getOutboundSlowPeeker(outboundPublication);
        this.librarySubscriber = new ControlledFragmentAssembler(ProtocolSubscription.of(this, new EngineProtocolSubscription(this)), 0, true);
        this.nonLoggingPositionSender = configuration.logOutboundMessages() ? null : new PositionSender(inboundPublication);
        this.replaySubscriber = new ImageControlledFragmentAssembler(ProtocolSubscription.of(new ProtocolHandler(){

            @Override
            public ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, int libraryId, long connectionId, long sessionId, int sequenceIndex, int messageType, long timestamp, MessageStatus status, int sequenceNumber, long position) {
                return Framer.this.senderEndPoints.onReplayMessage(connectionId, buffer, offset, length, position);
            }

            @Override
            public ControlledFragmentHandler.Action onDisconnect(int libraryId, long connectionId, DisconnectReason reason) {
                return ControlledFragmentHandler.Action.CONTINUE;
            }
        }, new ReplayProtocolSubscription(this.senderEndPoints::onReplayComplete)), 0, true);
        this.replaySlowSubscriber = new ControlledFragmentAssembler(ProtocolSubscription.of(new ProtocolHandler(){

            @Override
            public ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, int libraryId, long connectionId, long sessionId, int sequenceIndex, int messageType, long timestamp, MessageStatus status, int sequenceNumber, long position) {
                return Framer.this.senderEndPoints.onSlowReplayMessage(connectionId, buffer, offset, length, position);
            }

            @Override
            public ControlledFragmentHandler.Action onDisconnect(int libraryId, long connectionId, DisconnectReason reason) {
                return ControlledFragmentHandler.Action.CONTINUE;
            }
        }, new ReplayProtocolSubscription(this.senderEndPoints::onReplayComplete)));
        this.channelSupplier = configuration.channelSupplier();
    }

    private SubscriptionSlowPeeker.LibrarySlowPeeker getOutboundSlowPeeker(GatewayPublication outboundPublication) {
        SubscriptionSlowPeeker.LibrarySlowPeeker outboundSlowPeeker;
        int outboundSessionId = outboundPublication.id();
        while ((outboundSlowPeeker = this.librarySlowPeeker.addLibrary(outboundSessionId)) == null) {
            if (this.conductorAgentInvoker != null) {
                this.conductorAgentInvoker.invoke();
            }
            Thread.yield();
        }
        return outboundSlowPeeker;
    }

    public int doWork() throws Exception {
        long timeInMs = this.epochClock.time();
        this.senderEndPoints.timeInMs(timeInMs);
        return this.retryManager.attemptSteps() + this.sendOutboundMessages() + this.sendReplayMessages() + this.pollEndPoints() + this.pollNewConnections(timeInMs) + this.pollLibraries(timeInMs) + this.gatewaySessions.pollSessions(timeInMs) + this.senderEndPoints.checkTimeouts(timeInMs) + this.adminCommands.drain(this.onAdminCommand) + this.checkDutyCycle();
    }

    private int checkDutyCycle() {
        return CollectionUtil.removeIf(this.replies, ResetSequenceNumberCommand::poll) + this.resendSaveNotifications(this.resendSlowStatus, SlowStatus.SLOW) + this.resendSaveNotifications(this.resendNotSlowStatus, SlowStatus.NOT_SLOW);
    }

    private int resendSaveNotifications(Long2LongHashMap resend, SlowStatus status) {
        int actions = 0;
        if (!resend.isEmpty()) {
            Long2LongHashMap.KeyIterator keyIterator = resend.keySet().iterator();
            while (keyIterator.hasNext()) {
                long connectionId = keyIterator.nextValue();
                int libraryId = (int)resend.get(connectionId);
                long position = this.inboundPublication.saveSlowStatusNotification(libraryId, connectionId, status);
                if (position <= 0L) continue;
                ++actions;
                keyIterator.remove();
            }
        }
        return actions;
    }

    private int sendReplayMessages() {
        return this.replayImage.controlledPoll(this.replaySubscriber, this.replayFragmentLimit) + this.replaySlowPeeker.peek(this.replaySlowSubscriber);
    }

    private int sendOutboundMessages() {
        int messagesRead = this.librarySubscription.controlledPoll(this.librarySubscriber, this.outboundLibraryFragmentLimit);
        messagesRead += this.librarySlowPeeker.peek((ControlledFragmentHandler)this.senderEndPointAssembler);
        if (this.nonLoggingPositionSender != null) {
            this.nonLoggingPositionSender.doWork();
        }
        return messagesRead;
    }

    private int pollLibraries(long timeInMs) {
        int total = 0;
        Int2ObjectHashMap.ValueIterator iterator = this.idToLibrary.values().iterator();
        while (iterator.hasNext()) {
            LiveLibraryInfo library = (LiveLibraryInfo)iterator.next();
            total += library.poll(timeInMs);
            if (library.isConnected()) continue;
            DebugLogger.log(LogTag.LIBRARY_MANAGEMENT, "Timing out connection to library %s%n", library.libraryId());
            iterator.remove();
            library.releaseSlowPeeker();
            this.tryAcquireLibrarySessions(library);
            this.saveLibraryTimeout(library);
        }
        return total += CollectionUtil.removeIf(this.librariesBeingAcquired, this.retryAcquireLibrarySessionsFunc);
    }

    private void tryAcquireLibrarySessions(LiveLibraryInfo library) {
        int librarySessionId = library.aeronSessionId();
        Image image = this.librarySubscription.imageBySessionId(librarySessionId);
        long libraryPosition = this.finalImagePositions.lookupPosition(librarySessionId);
        if (image != null) {
            libraryPosition = image.position();
        }
        boolean indexed = this.sentIndexedPosition(librarySessionId, libraryPosition);
        if (!this.configuration.logOutboundMessages() || indexed) {
            this.acquireLibrarySessions(library);
        } else {
            library.acquireAtPosition(libraryPosition);
            this.librariesBeingAcquired.add(library);
        }
    }

    private boolean retryAcquireLibrarySessions(LiveLibraryInfo library) {
        boolean indexed = this.sentIndexedPosition(library.aeronSessionId(), library.acquireAtPosition());
        if (!this.configuration.logOutboundMessages() || indexed) {
            this.acquireLibrarySessions(library);
        }
        return indexed;
    }

    private boolean sentIndexedPosition(int aeronSessionId, long position) {
        long indexedPosition = this.sentSequenceNumberIndex.indexedPosition(aeronSessionId);
        return indexedPosition >= position;
    }

    private void saveLibraryTimeout(LibraryInfo library) {
        int libraryId = library.libraryId();
        this.schedule(() -> this.inboundPublication.saveLibraryTimeout(libraryId, 0L));
        this.schedule(() -> this.outboundPublication.saveLibraryTimeout(libraryId, 0L));
    }

    private void acquireLibrarySessions(LiveLibraryInfo library) {
        List<GatewaySession> sessions = library.gatewaySessions();
        int size = sessions.size();
        for (int i = 0; i < size; ++i) {
            GatewaySession session = sessions.get(i);
            long sessionId = session.sessionId();
            int sentSequenceNumber = this.sentSequenceNumberIndex.lastKnownSequenceNumber(sessionId);
            int receivedSequenceNumber = this.receivedSequenceNumberIndex.lastKnownSequenceNumber(sessionId);
            boolean hasLoggedIn = receivedSequenceNumber != -1;
            SessionState state = hasLoggedIn ? SessionState.ACTIVE : SessionState.CONNECTED;
            DebugLogger.log(LogTag.LIBRARY_MANAGEMENT, "Acquiring session %s from library %s%n", session.sessionId(), (long)library.libraryId());
            this.gatewaySessions.acquire(session, state, false, session.heartbeatIntervalInS(), sentSequenceNumber, receivedSequenceNumber, session.username(), session.password(), this.engineBlockablePosition);
            this.schedule(() -> this.saveManageSession(0, session, sentSequenceNumber, receivedSequenceNumber, SessionStatus.LIBRARY_NOTIFICATION));
            if (!this.performingCloseOperation) continue;
            session.session().logoutAndDisconnect();
        }
        this.finalImagePositions.removePosition(library.aeronSessionId());
    }

    private int pollEndPoints() {
        int bytesReceived;
        int inboundBytesReceivedLimit = this.inboundBytesReceivedLimit;
        int totalBytesReceived = 0;
        while ((bytesReceived = this.receiverEndPoints.pollEndPoints()) > 0 && (totalBytesReceived += bytesReceived) < inboundBytesReceivedLimit) {
        }
        return totalBytesReceived;
    }

    private int pollNewConnections(long timeInMs) throws IOException {
        return this.channelSupplier.pollSelector(timeInMs, this.onNewConnectionFunc);
    }

    private void onNewConnection(long timeInMs, TcpChannel channel) {
        String address;
        long position;
        if (this.performingCloseOperation) {
            channel.close();
            return;
        }
        long connectionId = this.newConnectionId();
        GatewaySession gatewaySession = this.setupConnection(channel, connectionId, SessionContexts.UNKNOWN_SESSION, null, 0, ConnectionType.ACCEPTOR, this.configuration.acceptedSessionClosedResendInterval(), this.configuration.acceptedSessionResendRequestChunkSize(), this.configuration.acceptedSessionSendRedundantResendRequests(), this.configuration.acceptedEnableLastMsgSeqNumProcessed(), this.configuration.acceptorfixDictionary());
        gatewaySession.disconnectAt(timeInMs + (long)this.configuration.noLogonDisconnectTimeoutInMs());
        if (!this.configuration.soleLibraryMode()) {
            this.gatewaySessions.acquire(gatewaySession, SessionState.CONNECTED, false, this.configuration.defaultHeartbeatIntervalInS(), -1, -1, null, null, this.engineBlockablePosition);
        }
        if (Pressure.isBackPressured(position = this.inboundPublication.saveConnect(connectionId, address = channel.remoteAddress()))) {
            this.errorHandler.onError((Throwable)new IllegalStateException("Failed to log connect from " + address + " due to backpressure"));
        }
    }

    private long newConnectionId() {
        long connectionId;
        do {
            ++this.nextConnectionId;
        } while (connectionId == -1L);
        return connectionId;
    }

    @Override
    public ControlledFragmentHandler.Action onInitiateConnection(int libraryId, int port, String host, String senderCompId, String senderSubId, String senderLocationId, String targetCompId, String targetSubId, String targetLocationId, SequenceNumberType sequenceNumberType, int requestedInitialReceivedSequenceNumber, int requestedInitialSentSequenceNumber, boolean resetSequenceNumber, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, String username, String password, Class<? extends FixDictionary> fixDictionary, int heartbeatIntervalInS, long correlationId, Header header) {
        LiveLibraryInfo library = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (library == null) {
            this.saveError(GatewayError.UNKNOWN_LIBRARY, libraryId, correlationId, "");
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        boolean logInboundMessages = this.configuration.logInboundMessages();
        boolean logOutboundMessages = this.configuration.logOutboundMessages();
        if (sequenceNumberType == SequenceNumberType.PERSISTENT && !this.configuration.logAllMessages()) {
            return this.badSequenceNumberConfiguration(libraryId, correlationId, logInboundMessages, logOutboundMessages);
        }
        CompositeKey sessionKey = this.sessionIdStrategy.onInitiateLogon(senderCompId, senderSubId, senderLocationId, targetCompId, targetSubId, targetLocationId);
        SessionContext sessionContext = this.sessionContexts.onLogon(sessionKey);
        if (sessionContext == SessionContexts.DUPLICATE_SESSION) {
            long sessionId = this.sessionContexts.lookupSessionId(sessionKey);
            int owningLibraryId = this.senderEndPoints.libraryLookup().applyAsInt(sessionId);
            String msg = "Duplicate Session for: " + sessionKey + " Surrogate Key: " + sessionId + " Currently owned by " + owningLibraryId;
            this.saveError(GatewayError.DUPLICATE_SESSION, libraryId, correlationId, msg);
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        try {
            DebugLogger.log(LogTag.FIX_CONNECTION, "Connecting to %s:%d from library %d%n", host, (long)port, (long)libraryId);
            InetSocketAddress address = new InetSocketAddress(host, port);
            ConnectingSession connectingSession = new ConnectingSession(address, sessionContext.sessionId());
            library.connectionStartsConnecting(correlationId, connectingSession);
            this.channelSupplier.open(address, (channel, ex) -> {
                if (ex != null) {
                    this.sessionContexts.onDisconnect(sessionContext.sessionId());
                    library.connectionFinishesConnecting(correlationId);
                    this.saveError(GatewayError.UNABLE_TO_CONNECT, libraryId, correlationId, ex);
                    return;
                }
                this.onConnectionOpen(libraryId, senderCompId, senderSubId, senderLocationId, targetCompId, targetSubId, targetLocationId, sequenceNumberType, resetSequenceNumber, closedResendInterval, resendRequestChunkSize, sendRedundantResendRequests, enableLastMsgSeqNumProcessed, username, password, fixDictionary, heartbeatIntervalInS, correlationId, header, library, address, channel, sessionContext, sessionKey);
            });
        }
        catch (Exception ex2) {
            this.sessionContexts.onDisconnect(sessionContext.sessionId());
            this.saveError(GatewayError.UNABLE_TO_CONNECT, libraryId, correlationId, ex2);
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onMidConnectionDisconnect(int libraryId, long correlationId) {
        LiveLibraryInfo library = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (library == null) {
            this.saveError(GatewayError.UNKNOWN_LIBRARY, libraryId, correlationId, "");
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        ConnectingSession connectingSession = library.connectionFinishesConnecting(correlationId);
        if (connectingSession == null) {
            this.saveError(GatewayError.UNKNOWN_SESSION, libraryId, correlationId, "Engine doesn't think library is connecting this session");
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        this.sessionContexts.onDisconnect(connectingSession.sessionId());
        try {
            this.channelSupplier.stopConnecting(connectingSession.address());
        }
        catch (IOException e) {
            this.errorHandler.onError((Throwable)e);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action badSequenceNumberConfiguration(int libraryId, long correlationId, boolean logInboundMessages, boolean logOutboundMessages) {
        String msg = "You need to enable the logging of inbound and outbound messages on your EngineConfigurationin order to initiate a connection with persistent sequence numbers. logInboundMessages = " + logInboundMessages + "logOutboundMessages = " + logOutboundMessages;
        this.saveError(GatewayError.INVALID_CONFIGURATION, libraryId, correlationId, msg);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void onConnectionOpen(int libraryId, String senderCompId, String senderSubId, String senderLocationId, String targetCompId, String targetSubId, String targetLocationId, SequenceNumberType sequenceNumberType, boolean resetSequenceNumber, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, String username, String password, Class<? extends FixDictionary> fixDictionary, int heartbeatIntervalInS, long correlationId, Header header, LiveLibraryInfo library, InetSocketAddress address, TcpChannel channel, SessionContext sessionContext, CompositeKey sessionKey) {
        try {
            DebugLogger.log(LogTag.FIX_CONNECTION, "Initiating session %s from library %s%n", sessionContext.sessionId(), (long)library.libraryId());
            long connectionId = this.newConnectionId();
            sessionContext.onLogon(resetSequenceNumber || sequenceNumberType == SequenceNumberType.TRANSIENT);
            long sessionId = sessionContext.sessionId();
            GatewaySession gatewaySession = this.setupConnection(channel, connectionId, sessionContext, sessionKey, libraryId, ConnectionType.INITIATOR, closedResendInterval, resendRequestChunkSize, sendRedundantResendRequests, enableLastMsgSeqNumProcessed, FixDictionary.of(fixDictionary));
            library.addSession(gatewaySession);
            this.handoverNewConnectionToLibrary(libraryId, senderCompId, senderSubId, senderLocationId, targetCompId, targetSubId, targetLocationId, closedResendInterval, resendRequestChunkSize, sendRedundantResendRequests, enableLastMsgSeqNumProcessed, username, password, fixDictionary, heartbeatIntervalInS, correlationId, library, sessionContext, sessionKey, connectionId, sessionId, gatewaySession, header.sessionId(), header.position(), address.toString(), ConnectionType.INITIATOR);
        }
        catch (Exception e) {
            this.saveError(GatewayError.EXCEPTION, libraryId, correlationId, e);
        }
    }

    private void handoverNewConnectionToLibrary(int libraryId, String senderCompId, String senderSubId, String senderLocationId, String targetCompId, String targetSubId, String targetLocationId, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, String username, String password, Class<? extends FixDictionary> fixDictionary, int heartbeatIntervalInS, long correlationId, LiveLibraryInfo library, SessionContext sessionContext, CompositeKey sessionKey, long connectionId, long sessionId, GatewaySession gatewaySession, int aeronSessionId, long requiredPosition, String address, ConnectionType connectionType) {
        this.retryManager.schedule(new HandoverNewConnectionToLibrary(gatewaySession, aeronSessionId, requiredPosition, sessionId, connectionType, sessionContext, sessionKey, username, password, heartbeatIntervalInS, libraryId, connectionId, closedResendInterval, resendRequestChunkSize, sendRedundantResendRequests, enableLastMsgSeqNumProcessed, correlationId, senderCompId, senderSubId, senderLocationId, targetCompId, targetSubId, targetLocationId, address, fixDictionary, library));
    }

    private void saveError(GatewayError error, int libraryId, long replyToId, String message) {
        this.schedule(() -> this.inboundPublication.saveError(error, libraryId, replyToId, message));
    }

    private void saveError(GatewayError error, int libraryId, long replyToId, Exception e) {
        String message = e.getMessage();
        this.saveError(error, libraryId, replyToId, message == null ? "" : message);
    }

    @Override
    public ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, int libraryId, long connectionId, long sessionId, int sequenceIndex, int messageType, long timestamp, MessageStatus status, int sequenceNumber, long position) {
        long now = this.outboundTimer.recordSince(timestamp);
        this.senderEndPoints.onMessage(libraryId, connectionId, buffer, offset, length, sequenceNumber, position);
        if (this.nonLoggingPositionSender != null) {
            this.nonLoggingPositionSender.newPosition(libraryId, position);
        }
        this.sendTimer.recordSince(now);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private GatewaySession setupConnection(TcpChannel channel, long connectionId, SessionContext context, CompositeKey sessionKey, int libraryId, ConnectionType connectionType, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, FixDictionary fixDictionary) {
        ReceiverEndPoint receiverEndPoint = this.endPointFactory.receiverEndPoint(channel, connectionId, context.sessionId(), context.sequenceIndex(), libraryId, this);
        this.receiverEndPoints.add(receiverEndPoint);
        BlockablePosition libraryBlockablePosition = this.getLibraryBlockablePosition(libraryId);
        SenderEndPoint senderEndPoint = this.endPointFactory.senderEndPoint(channel, connectionId, libraryId, libraryBlockablePosition, this);
        this.senderEndPoints.add(senderEndPoint);
        GatewaySession gatewaySession = new GatewaySession(connectionId, context, channel.remoteAddress(), connectionType, sessionKey, receiverEndPoint, senderEndPoint, this.onSessionlogon, closedResendInterval, resendRequestChunkSize, sendRedundantResendRequests, enableLastMsgSeqNumProcessed, fixDictionary);
        receiverEndPoint.gatewaySession(gatewaySession);
        return gatewaySession;
    }

    private BlockablePosition getLibraryBlockablePosition(int libraryId) {
        if (libraryId == 0) {
            return this.engineBlockablePosition;
        }
        return ((LiveLibraryInfo)this.idToLibrary.get(libraryId)).librarySlowPeeker();
    }

    @Override
    public ControlledFragmentHandler.Action onRequestDisconnect(int libraryId, long connectionId, DisconnectReason reason) {
        return this.onDisconnect(libraryId, connectionId, reason);
    }

    @Override
    public ControlledFragmentHandler.Action onDisconnect(int libraryId, long connectionId, DisconnectReason reason) {
        this.receiverEndPoints.removeConnection(connectionId, reason);
        this.senderEndPoints.removeConnection(connectionId);
        LiveLibraryInfo library = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (library != null) {
            library.removeSession(connectionId);
        } else {
            this.gatewaySessions.releaseByConnectionId(connectionId);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onLibraryConnect(int libraryId, String libraryName, long correlationId, int aeronSessionId) {
        ControlledFragmentHandler.Action action = this.retryManager.retry(correlationId);
        if (action != null) {
            return action;
        }
        if (this.performingCloseOperation) {
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        LiveLibraryInfo existingLibrary = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (existingLibrary != null) {
            existingLibrary.onHeartbeat(this.epochClock.time());
            return Pressure.apply(this.inboundPublication.saveControlNotification(libraryId, existingLibrary.sessions()));
        }
        if (Pressure.isBackPressured(this.inboundPublication.saveControlNotification(libraryId, Collections.emptyList()))) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        LivenessDetector livenessDetector = LivenessDetector.forEngine(this.inboundPublication, libraryId, this.configuration.replyTimeoutInMs(), this.epochClock.time());
        ArrayList<Continuation> unitsOfWork = new ArrayList<Continuation>();
        unitsOfWork.add(() -> {
            SubscriptionSlowPeeker.LibrarySlowPeeker librarySlowPeeker = this.librarySlowPeeker.addLibrary(aeronSessionId);
            if (librarySlowPeeker == null) {
                return -2L;
            }
            LiveLibraryInfo library = new LiveLibraryInfo(libraryId, libraryName, livenessDetector, aeronSessionId, librarySlowPeeker);
            this.idToLibrary.put(libraryId, (Object)library);
            DebugLogger.log(LogTag.LIBRARY_MANAGEMENT, "Library %s - %s connected %n", (long)libraryId, (Object)libraryName);
            return 1L;
        });
        for (GatewaySession gatewaySession : this.gatewaySessions.sessions()) {
            unitsOfWork.add(() -> this.saveManageSession(libraryId, gatewaySession, -1, -1, SessionStatus.LIBRARY_NOTIFICATION));
        }
        return this.retryManager.firstAttempt(correlationId, new UnitOfWork(unitsOfWork));
    }

    @Override
    public ControlledFragmentHandler.Action onApplicationHeartbeat(int libraryId, int aeronSessionId) {
        LiveLibraryInfo library = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (library != null) {
            long timeInMs = this.epochClock.time();
            DebugLogger.log(LogTag.APPLICATION_HEARTBEAT, "Received Heartbeat from library %d at timeInMs %d%n", (long)libraryId, timeInMs);
            library.onHeartbeat(timeInMs);
            return null;
        }
        if (libraryId == 0) {
            return null;
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onReleaseSession(int libraryId, long connectionId, long sessionId, long correlationId, SessionState state, boolean awaitingResend, long heartbeatIntervalInMs, int lastSentSequenceNumber, int lastReceivedSequenceNumber, String username, String password, Header header) {
        LiveLibraryInfo libraryInfo = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (libraryInfo == null) {
            return Pressure.apply(this.inboundPublication.saveReleaseSessionReply(libraryId, SessionReplyStatus.UNKNOWN_LIBRARY, correlationId));
        }
        DebugLogger.log(LogTag.LIBRARY_MANAGEMENT, "Releasing session %s with connectionId %s from library %s%n", sessionId, connectionId, (long)libraryId);
        GatewaySession session = libraryInfo.removeSession(connectionId);
        if (session == null) {
            return Pressure.apply(this.inboundPublication.saveReleaseSessionReply(libraryId, SessionReplyStatus.UNKNOWN_SESSION, correlationId));
        }
        ControlledFragmentHandler.Action action = Pressure.apply(this.inboundPublication.saveReleaseSessionReply(libraryId, SessionReplyStatus.OK, correlationId));
        if (action == ControlledFragmentHandler.Action.ABORT) {
            libraryInfo.addSession(session);
        } else {
            this.gatewaySessions.acquire(session, state, awaitingResend, (int)TimeUnit.MILLISECONDS.toSeconds(heartbeatIntervalInMs), lastSentSequenceNumber, lastReceivedSequenceNumber, username, password, this.engineBlockablePosition);
            this.schedule(() -> this.saveManageSession(0, session, lastSentSequenceNumber, lastReceivedSequenceNumber, SessionStatus.LIBRARY_NOTIFICATION));
        }
        return action;
    }

    @Override
    public ControlledFragmentHandler.Action onRequestSession(int libraryId, long sessionId, long correlationId, int replayFromSequenceNumber, int replayFromSequenceIndex) {
        ControlledFragmentHandler.Action action = this.retryManager.retry(correlationId);
        if (action != null) {
            return action;
        }
        int aeronSessionId = this.outboundPublication.id();
        long requiredPosition = this.outboundPublication.position();
        LiveLibraryInfo libraryInfo = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (libraryInfo == null) {
            return Pressure.apply(this.inboundPublication.saveRequestSessionReply(libraryId, SessionReplyStatus.UNKNOWN_LIBRARY, correlationId));
        }
        GatewaySession gatewaySession = this.gatewaySessions.releaseBySessionId(sessionId);
        if (gatewaySession == null) {
            return Pressure.apply(this.inboundPublication.saveRequestSessionReply(libraryId, SessionReplyStatus.UNKNOWN_SESSION, correlationId));
        }
        InternalSession session = gatewaySession.session();
        if (!session.isActive()) {
            return Pressure.apply(this.inboundPublication.saveRequestSessionReply(libraryId, SessionReplyStatus.SESSION_NOT_LOGGED_IN, correlationId));
        }
        long connectionId = gatewaySession.connectionId();
        int lastSentSeqNum = session.lastSentMsgSeqNum();
        int lastRecvSeqNum = session.lastReceivedMsgSeqNum();
        gatewaySession.handoverManagementTo(libraryId, libraryInfo.librarySlowPeeker());
        libraryInfo.addSession(gatewaySession);
        DebugLogger.log(LogTag.LIBRARY_MANAGEMENT, "Handing control for session %s to library %s%n", sessionId, (long)libraryId);
        if (requiredPosition > 0L && this.configuration.logOutboundMessages()) {
            return this.retryManager.firstAttempt(correlationId, () -> {
                if (this.sentIndexedPosition(aeronSessionId, requiredPosition)) {
                    this.finishSessionHandover(libraryId, correlationId, replayFromSequenceNumber, replayFromSequenceIndex, gatewaySession, session, connectionId, lastSentSeqNum, lastRecvSeqNum);
                    return 1L;
                }
                return -2L;
            });
        }
        this.finishSessionHandover(libraryId, correlationId, replayFromSequenceNumber, replayFromSequenceIndex, gatewaySession, session, connectionId, lastSentSeqNum, lastRecvSeqNum);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void finishSessionHandover(int libraryId, long correlationId, int replayFromSequenceNumber, int replayFromSequenceIndex, GatewaySession gatewaySession, InternalSession session, long connectionId, int lastSentSeqNum, int lastRecvSeqNum) {
        ArrayList<Continuation> continuations = new ArrayList<Continuation>();
        continuations.add(() -> this.saveManageSession(libraryId, gatewaySession, lastSentSeqNum, lastRecvSeqNum, SessionStatus.SESSION_HANDOVER, session.compositeKey(), connectionId, session, correlationId));
        this.catchupSession(continuations, libraryId, connectionId, correlationId, replayFromSequenceNumber, replayFromSequenceIndex, gatewaySession, lastRecvSeqNum);
        this.retryManager.schedule(new UnitOfWork(continuations));
    }

    @Override
    public ControlledFragmentHandler.Action onFollowerSessionRequest(int libraryId, long correlationId, DirectBuffer srcBuffer, int srcOffset, int srcLength) {
        this.asciiBuffer.wrap(srcBuffer);
        this.acceptorHeaderDecoder.decode(this.asciiBuffer, srcOffset, srcLength);
        CompositeKey compositeKey = this.sessionIdStrategy.onAcceptLogon(this.acceptorHeaderDecoder);
        SessionContext sessionContext = this.sessionContexts.newSessionContext(compositeKey);
        long sessionId = sessionContext.sessionId();
        this.retryManager.schedule(() -> this.inboundPublication.saveFollowerSessionReply(libraryId, correlationId, sessionId));
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private long saveManageSession(int libraryId, GatewaySession gatewaySession, int lastSentSeqNum, int lastReceivedSeqNum, SessionStatus logonstatus) {
        CompositeKey compositeKey = gatewaySession.sessionKey();
        if (compositeKey != null) {
            long connectionId = gatewaySession.connectionId();
            InternalSession session = gatewaySession.session();
            return this.saveManageSession(libraryId, gatewaySession, lastSentSeqNum, lastReceivedSeqNum, logonstatus, compositeKey, connectionId, session, 0L);
        }
        return 1L;
    }

    private long saveManageSession(int libraryId, GatewaySession gatewaySession, int lastSentSeqNum, int lastReceivedSeqNum, SessionStatus sessionstatus, CompositeKey compositeKey, long connectionId, InternalSession session, long correlationId) {
        return this.inboundPublication.saveManageSession(libraryId, connectionId, gatewaySession.sessionId(), lastSentSeqNum, lastReceivedSeqNum, session.logonTime(), sessionstatus, gatewaySession.slowStatus(), gatewaySession.connectionType(), session.state(), session.awaitingResend(), gatewaySession.heartbeatIntervalInS(), gatewaySession.closedResendInterval(), gatewaySession.resendRequestChunkSize(), gatewaySession.sendRedundantResendRequests(), gatewaySession.enableLastMsgSeqNumProcessed(), correlationId, gatewaySession.sequenceIndex(), session.lastResentMsgSeqNo(), session.lastResendChunkMsgSeqNum(), session.endOfResendRequestRange(), session.awaitingHeartbeat(), compositeKey.localCompId(), compositeKey.localSubId(), compositeKey.localLocationId(), compositeKey.remoteCompId(), compositeKey.remoteSubId(), compositeKey.remoteLocationId(), gatewaySession.address(), gatewaySession.username(), gatewaySession.password(), gatewaySession.fixDictionary().getClass());
    }

    private void catchupSession(List<Continuation> continuations, int libraryId, long connectionId, long correlationId, int replayFromSequenceNumber, int requestedReplayFromSequenceIndex, GatewaySession session, int lastReceivedSeqNum) {
        if (replayFromSequenceNumber != -1) {
            int replayFromSequenceIndex;
            if (!this.configuration.logInboundMessages()) {
                continuations.add(() -> {
                    long position = this.inboundPublication.saveRequestSessionReply(libraryId, SessionReplyStatus.INVALID_CONFIGURATION_NOT_LOGGING_MESSAGES, correlationId);
                    if (position > 0L) {
                        session.play();
                    }
                    return position;
                });
                return;
            }
            int sequenceIndex = session.sequenceIndex();
            if (requestedReplayFromSequenceIndex == -2) {
                replayFromSequenceIndex = sequenceIndex;
            } else {
                if (requestedReplayFromSequenceIndex > sequenceIndex || requestedReplayFromSequenceIndex == sequenceIndex && replayFromSequenceNumber > lastReceivedSeqNum) {
                    continuations.add(() -> this.sequenceNumberTooHigh(libraryId, correlationId, session));
                    return;
                }
                replayFromSequenceIndex = requestedReplayFromSequenceIndex;
            }
            continuations.add(new CatchupReplayer(this.receivedSequenceNumberIndex, this.inboundMessages, this.inboundPublication, this.errorHandler, correlationId, connectionId, libraryId, lastReceivedSeqNum, sequenceIndex, replayFromSequenceNumber, replayFromSequenceIndex, session, this.catchupTimeout(), this.epochClock));
        } else {
            continuations.add(() -> CatchupReplayer.sendOk(this.inboundPublication, correlationId, session, libraryId));
        }
    }

    private long catchupTimeout() {
        return this.configuration.replyTimeoutInMs() / 2L;
    }

    private long sequenceNumberTooHigh(int libraryId, long correlationId, GatewaySession session) {
        long position = this.inboundPublication.saveRequestSessionReply(libraryId, SessionReplyStatus.SEQUENCE_NUMBER_TOO_HIGH, correlationId);
        if (!Pressure.isBackPressured(position)) {
            session.play();
        }
        return position;
    }

    private void onSessionLogon(GatewaySession gatewaySession) {
        if (!this.configuration.soleLibraryMode()) {
            this.schedule(() -> {
                InternalSession session = gatewaySession.session();
                if (null == session) {
                    return 1L;
                }
                CompositeKey key = gatewaySession.sessionKey();
                return this.saveManageSession(0, gatewaySession, session.lastSentMsgSeqNum(), session.lastReceivedMsgSeqNum(), SessionStatus.SESSION_HANDOVER, key, gatewaySession.connectionId(), session, 0L);
            });
        }
    }

    void onLogonMessageReceived(GatewaySession gatewaySession) {
        if (this.configuration.soleLibraryMode() && gatewaySession.connectionType() == ConnectionType.ACCEPTOR) {
            if (this.idToLibrary.size() != 1) {
                System.err.println("Error, invalid numbers of libraryies: " + this.idToLibrary.size());
            }
            LiveLibraryInfo libraryInfo = (LiveLibraryInfo)this.idToLibrary.values().iterator().next();
            CompositeKey sessionKey = gatewaySession.sessionKey();
            int libraryAeronSessionId = libraryInfo.aeronSessionId();
            long requiredPosition = this.librarySubscription.imageBySessionId(libraryAeronSessionId).position();
            int libraryId = libraryInfo.libraryId();
            gatewaySession.setManagementTo(libraryId, libraryInfo.librarySlowPeeker());
            libraryInfo.addSession(gatewaySession);
            this.handoverNewConnectionToLibrary(libraryId, sessionKey.localCompId(), sessionKey.localSubId(), sessionKey.localLocationId(), sessionKey.remoteCompId(), sessionKey.remoteSubId(), sessionKey.remoteLocationId(), gatewaySession.closedResendInterval(), gatewaySession.resendRequestChunkSize(), gatewaySession.sendRedundantResendRequests(), gatewaySession.enableLastMsgSeqNumProcessed(), gatewaySession.username(), gatewaySession.password(), gatewaySession.fixDictionary().getClass(), gatewaySession.heartbeatIntervalInS(), 0L, libraryInfo, gatewaySession.context(), sessionKey, gatewaySession.connectionId(), gatewaySession.sessionId(), gatewaySession, libraryAeronSessionId, requiredPosition, gatewaySession.address(), ConnectionType.ACCEPTOR);
        }
    }

    void onQueryLibraries(QueryLibrariesCommand command) {
        ArrayList<LibraryInfo> libraries = new ArrayList<LibraryInfo>((Collection<LibraryInfo>)this.idToLibrary.values());
        libraries.add(new EngineLibraryInfo(this.gatewaySessions));
        command.success(libraries);
    }

    void onResetSessionIds(File backupLocation, ResetSessionIdsCommand command) {
        Continuation[] continuationArray = new Continuation[4];
        continuationArray[0] = this.inboundPublication::saveResetSessionIds;
        continuationArray[1] = this.outboundPublication::saveResetSessionIds;
        continuationArray[2] = () -> {
            try {
                this.sessionContexts.reset(backupLocation);
            }
            catch (Exception ex) {
                command.onError(ex);
            }
            return 1L;
        };
        continuationArray[3] = () -> {
            if (command.hasCompleted()) {
                return 1L;
            }
            if (this.sequenceNumbersNotReset()) {
                return -2L;
            }
            command.success();
            return 1L;
        };
        this.schedule(new UnitOfWork(continuationArray));
    }

    void onStartClose(StartCloseCommand startCloseCommand) {
        this.performingCloseOperation = true;
        this.schedule(new CloseOperation(this.inboundPublication, new ArrayList<LiveLibraryInfo>((Collection<LiveLibraryInfo>)this.idToLibrary.values()), new ArrayList<GatewaySession>(this.gatewaySessions.sessions()), this.receiverEndPoints, startCloseCommand));
    }

    void onResetSequenceNumber(ResetSequenceNumberCommand reply) {
        reply.libraryLookup(this.senderEndPoints.libraryLookup());
        if (!reply.poll()) {
            this.replies.add(reply);
        }
    }

    void onLookupSessionId(LookupSessionIdCommand command) {
        CompositeKey compositeKey = this.sessionIdStrategy.onInitiateLogon(command.localCompId, command.localSubId, command.localLocationId, command.remoteCompId, command.remoteSubId, command.remoteLocationId);
        long sessionId = this.sessionContexts.lookupSessionId(compositeKey);
        if (sessionId == -1L) {
            command.error(new IllegalArgumentException("Unknown Session: " + compositeKey));
        } else {
            command.complete(sessionId);
        }
    }

    private boolean sequenceNumbersNotReset() {
        return this.sentSequenceNumberIndex.lastKnownSequenceNumber(1L) != -1 || this.receivedSequenceNumberIndex.lastKnownSequenceNumber(1L) != -1;
    }

    public void onClose() {
        if (this.configuration.gracefulShutdown()) {
            Exceptions.closeAll((AutoCloseable[])new AutoCloseable[]{this::quiesce, this.retryManager, this.inboundMessages, this.receiverEndPoints, this.senderEndPoints, this.channelSupplier});
        } else {
            Exceptions.closeAll((AutoCloseable[])new AutoCloseable[]{this.inboundMessages, this.channelSupplier});
        }
    }

    private void quiesce() {
        Long2LongHashMap inboundPositions = new Long2LongHashMap(-1L);
        inboundPositions.put((long)this.inboundPublication.id(), this.inboundPublication.position());
        this.inboundCompletionPosition.complete(inboundPositions);
        Long2LongHashMap outboundPositions = new Long2LongHashMap(-1L);
        this.idToLibrary.values().forEach(liveLibraryInfo -> {
            int aeronSessionId = liveLibraryInfo.aeronSessionId();
            Image image = this.librarySubscription.imageBySessionId(aeronSessionId);
            if (image != null) {
                long position = image.position();
                outboundPositions.put((long)aeronSessionId, position);
            }
        });
        this.outboundLibraryCompletionPosition.complete(outboundPositions);
        this.recordingCoordinator.completionPositions(inboundPositions, outboundPositions);
    }

    public String roleName() {
        return this.agentNamePrefix + "Framer";
    }

    void schedule(Continuation continuation) {
        if (continuation.attemptToAction() != ControlledFragmentHandler.Action.CONTINUE) {
            this.retryManager.schedule(continuation);
        }
    }

    void slowStatus(int libraryId, long connectionId, boolean hasBecomeSlow) {
        if (hasBecomeSlow) {
            this.sendSlowStatus(libraryId, connectionId, this.resendNotSlowStatus, this.resendSlowStatus, SlowStatus.SLOW);
        } else {
            this.sendSlowStatus(libraryId, connectionId, this.resendSlowStatus, this.resendNotSlowStatus, SlowStatus.NOT_SLOW);
        }
    }

    private void sendSlowStatus(int libraryId, long connectionId, Long2LongHashMap toNotResend, Long2LongHashMap toResend, SlowStatus status) {
        toNotResend.remove(connectionId);
        long position = this.inboundPublication.saveSlowStatusNotification(libraryId, connectionId, status);
        if (Pressure.isBackPressured(position)) {
            toResend.put(connectionId, (long)libraryId);
        }
    }

    void receiverEndPointPollingOptional(long connectionId) {
        this.receiverEndPoints.receiverEndPointPollingOptional(connectionId);
    }

    class HandoverNewConnectionToLibrary
    extends UnitOfWork {
        private final GatewaySession gatewaySession;
        private final int aeronSessionId;
        private final long requiredPosition;
        private final long sessionId;
        private final ConnectionType connectionType;
        private final SessionContext sessionContext;
        private final CompositeKey sessionKey;
        private final String username;
        private final String password;
        private final int heartbeatIntervalInS;
        private final int libraryId;
        private final long connectionId;
        private final boolean closedResendInterval;
        private final int resendRequestChunkSize;
        private final boolean sendRedundantResendRequests;
        private final boolean enableLastMsgSeqNumProcessed;
        private final long correlationId;
        private final String senderCompId;
        private final String senderSubId;
        private final String senderLocationId;
        private final String targetCompId;
        private final String targetSubId;
        private final String targetLocationId;
        private final String address;
        private final Class<? extends FixDictionary> fixDictionary;
        private final LiveLibraryInfo library;
        private int lastSentSequenceNumber;
        private int lastReceivedSequenceNumber;

        HandoverNewConnectionToLibrary(GatewaySession gatewaySession, int aeronSessionId, long requiredPosition, long sessionId, ConnectionType connectionType, SessionContext sessionContext, CompositeKey sessionKey, String username, String password, int heartbeatIntervalInS, int libraryId, long connectionId, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, long correlationId, String senderCompId, String senderSubId, String senderLocationId, String targetCompId, String targetSubId, String targetLocationId, String address, Class<? extends FixDictionary> fixDictionary, LiveLibraryInfo library) {
            super(new Continuation[0]);
            this.gatewaySession = gatewaySession;
            this.aeronSessionId = aeronSessionId;
            this.requiredPosition = requiredPosition;
            this.sessionId = sessionId;
            this.connectionType = connectionType;
            this.sessionContext = sessionContext;
            this.sessionKey = sessionKey;
            this.username = username;
            this.password = password;
            this.heartbeatIntervalInS = heartbeatIntervalInS;
            this.libraryId = libraryId;
            this.connectionId = connectionId;
            this.closedResendInterval = closedResendInterval;
            this.resendRequestChunkSize = resendRequestChunkSize;
            this.sendRedundantResendRequests = sendRedundantResendRequests;
            this.enableLastMsgSeqNumProcessed = enableLastMsgSeqNumProcessed;
            this.correlationId = correlationId;
            this.senderCompId = senderCompId;
            this.senderSubId = senderSubId;
            this.senderLocationId = senderLocationId;
            this.targetCompId = targetCompId;
            this.targetSubId = targetSubId;
            this.targetLocationId = targetLocationId;
            this.address = address;
            this.fixDictionary = fixDictionary;
            this.library = library;
            if (Framer.this.configuration.logInboundMessages()) {
                this.work(this::checkLoggerUpToDate, this::saveManageSession);
            } else {
                this.work(this::onLogon, this::saveManageSession);
            }
        }

        private long checkLoggerUpToDate() {
            if (this.gatewaySession.initialResetSeqNum()) {
                this.lastSentSequenceNumber = 0;
                this.lastReceivedSequenceNumber = 0;
                return 0L;
            }
            if (Framer.this.sentIndexedPosition(this.aeronSessionId, this.requiredPosition)) {
                this.lastSentSequenceNumber = Framer.this.sentSequenceNumberIndex.lastKnownSequenceNumber(this.sessionId);
                this.lastReceivedSequenceNumber = Framer.this.receivedSequenceNumberIndex.lastKnownSequenceNumber(this.sessionId);
                if (this.connectionType == ConnectionType.ACCEPTOR) {
                    this.lastSentSequenceNumber = GatewaySession.adjustLastSequenceNumber(this.lastSentSequenceNumber);
                    this.lastReceivedSequenceNumber = GatewaySession.adjustLastSequenceNumber(this.lastReceivedSequenceNumber);
                }
                return this.onLogon();
            }
            return -2L;
        }

        private long onLogon() {
            this.gatewaySession.onLogon(this.sessionId, this.sessionContext, this.sessionKey, this.username, this.password, this.heartbeatIntervalInS);
            return 1L;
        }

        private long saveManageSession() {
            long position = Framer.this.inboundPublication.saveManageSession(this.libraryId, this.connectionId, this.sessionId, this.lastSentSequenceNumber, this.lastReceivedSequenceNumber, -1L, SessionStatus.SESSION_HANDOVER, SlowStatus.NOT_SLOW, this.connectionType, SessionState.CONNECTED, false, this.heartbeatIntervalInS, this.closedResendInterval, this.resendRequestChunkSize, this.sendRedundantResendRequests, this.enableLastMsgSeqNumProcessed, this.correlationId, this.sessionContext.sequenceIndex(), 0, 0, 0, false, this.senderCompId, this.senderSubId, this.senderLocationId, this.targetCompId, this.targetSubId, this.targetLocationId, this.address, this.username, this.password, this.fixDictionary);
            if (position > 0L) {
                this.library.connectionFinishesConnecting(this.correlationId);
                this.gatewaySession.play();
            }
            return position;
        }
    }
}

