/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import uk.co.real_logic.artio.ValidationError;
import uk.co.real_logic.artio.dictionary.IntDictionary;
import uk.co.real_logic.artio.fields.AsciiFieldFlyweight;
import uk.co.real_logic.artio.otf.MessageControl;
import uk.co.real_logic.artio.otf.OtfMessageAcceptor;
import uk.co.real_logic.artio.otf.OtfParser;
import uk.co.real_logic.artio.util.AsciiBuffer;

public class SequenceNumberExtractor {
    public static final int NO_SEQUENCE_NUMBER = -1;
    private final ErrorHandler errorHandler;
    private int sequenceNumber;
    private final OtfMessageAcceptor extractor = new OtfMessageAcceptor(){

        public MessageControl onNext() {
            return MessageControl.CONTINUE;
        }

        public MessageControl onComplete() {
            return MessageControl.CONTINUE;
        }

        public MessageControl onField(int tag, AsciiBuffer buffer, int offset, int length) {
            if (tag == 34) {
                SequenceNumberExtractor.this.sequenceNumber = buffer.getInt(offset, offset + length);
                return MessageControl.STOP;
            }
            return MessageControl.CONTINUE;
        }

        public MessageControl onGroupHeader(int tag, int numInGroup) {
            return MessageControl.CONTINUE;
        }

        public MessageControl onGroupBegin(int tag, int numInGroup, int index) {
            return MessageControl.CONTINUE;
        }

        public MessageControl onGroupEnd(int tag, int numInGroup, int index) {
            return MessageControl.CONTINUE;
        }

        public boolean onError(ValidationError error, int messageType, int tagNumber, AsciiFieldFlyweight value) {
            return false;
        }
    };
    private final OtfParser parser = new OtfParser(this.extractor, new IntDictionary());

    public SequenceNumberExtractor(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public int extract(DirectBuffer buffer, int offset, int length) {
        this.sequenceNumber = -1;
        this.parser.onMessage(buffer, offset, length);
        return this.sequenceNumber;
    }
}

