/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.protocol;

import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.messages.ApplicationHeartbeatDecoder;
import uk.co.real_logic.artio.messages.AwaitingResend;
import uk.co.real_logic.artio.messages.Bool;
import uk.co.real_logic.artio.messages.ControlNotificationDecoder;
import uk.co.real_logic.artio.messages.EndOfDayDecoder;
import uk.co.real_logic.artio.messages.ErrorDecoder;
import uk.co.real_logic.artio.messages.FollowerSessionReplyDecoder;
import uk.co.real_logic.artio.messages.ManageSessionDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.NewSentPositionDecoder;
import uk.co.real_logic.artio.messages.ReleaseSessionReplyDecoder;
import uk.co.real_logic.artio.messages.RequestSessionReplyDecoder;
import uk.co.real_logic.artio.messages.ResetLibrarySequenceNumberDecoder;
import uk.co.real_logic.artio.messages.SlowStatus;
import uk.co.real_logic.artio.messages.SlowStatusNotificationDecoder;
import uk.co.real_logic.artio.protocol.LibraryEndPointHandler;

public final class LibraryProtocolSubscription
implements ControlledFragmentHandler {
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final ErrorDecoder error = new ErrorDecoder();
    private final ApplicationHeartbeatDecoder applicationHeartbeat = new ApplicationHeartbeatDecoder();
    private final ReleaseSessionReplyDecoder releaseSessionReply = new ReleaseSessionReplyDecoder();
    private final RequestSessionReplyDecoder requestSessionReply = new RequestSessionReplyDecoder();
    private final NewSentPositionDecoder newSentPosition = new NewSentPositionDecoder();
    private final ControlNotificationDecoder controlNotification = new ControlNotificationDecoder();
    private final SlowStatusNotificationDecoder slowStatusNotification = new SlowStatusNotificationDecoder();
    private final ResetLibrarySequenceNumberDecoder resetLibrarySequenceNumber = new ResetLibrarySequenceNumberDecoder();
    private final ManageSessionDecoder manageSession = new ManageSessionDecoder();
    private final FollowerSessionReplyDecoder followerSessionReply = new FollowerSessionReplyDecoder();
    private final EndOfDayDecoder endOfDay = new EndOfDayDecoder();
    private final LibraryEndPointHandler handler;

    public LibraryProtocolSubscription(LibraryEndPointHandler handler) {
        this.handler = handler;
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeader.wrap(buffer, offset);
        int blockLength = this.messageHeader.blockLength();
        int version = this.messageHeader.version();
        offset += this.messageHeader.encodedLength();
        switch (this.messageHeader.templateId()) {
            case 35: {
                return this.onNewSentPosition(buffer, offset, blockLength, version);
            }
            case 8: {
                return this.onManageSession(buffer, offset, blockLength, version);
            }
            case 13: {
                return this.onError(buffer, offset, blockLength, version);
            }
            case 16: {
                return this.onApplicationHeartbeat(buffer, offset, blockLength, version);
            }
            case 30: {
                return this.onReleaseSessionReply(buffer, offset, blockLength, version);
            }
            case 32: {
                return this.onRequestSessionReply(buffer, offset, blockLength, version);
            }
            case 39: {
                return this.onControlNotification(buffer, offset, blockLength, version);
            }
            case 43: {
                return this.onSlowStatusNotification(buffer, offset, blockLength, version);
            }
            case 44: {
                return this.onResetLibrarySequenceNumber(buffer, offset, blockLength, version);
            }
            case 48: {
                return this.onFollowerSessionReply(buffer, offset, blockLength, version);
            }
            case 49: {
                return this.onEndOfDay(buffer, offset, blockLength, version);
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onControlNotification(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.controlNotification.wrap(buffer, offset, blockLength, version);
        int libraryId = this.controlNotification.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onControlNotification(libraryId, this.controlNotification.sessions());
    }

    private ControlledFragmentHandler.Action onSlowStatusNotification(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.slowStatusNotification.wrap(buffer, offset, blockLength, version);
        int libraryId = this.slowStatusNotification.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onSlowStatusNotification(libraryId, this.slowStatusNotification.connectionId(), this.slowStatusNotification.status() == SlowStatus.SLOW);
    }

    private ControlledFragmentHandler.Action onResetLibrarySequenceNumber(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.resetLibrarySequenceNumber.wrap(buffer, offset, blockLength, version);
        int libraryId = this.resetLibrarySequenceNumber.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onResetLibrarySequenceNumber(libraryId, this.resetLibrarySequenceNumber.session());
    }

    private ControlledFragmentHandler.Action onFollowerSessionReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.followerSessionReply.wrap(buffer, offset, blockLength, version);
        int libraryId = this.followerSessionReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onFollowerSessionReply(libraryId, this.followerSessionReply.replyToId(), this.followerSessionReply.session());
    }

    private ControlledFragmentHandler.Action onApplicationHeartbeat(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.applicationHeartbeat.wrap(buffer, offset, blockLength, version);
        return this.handler.onApplicationHeartbeat(this.applicationHeartbeat.libraryId());
    }

    private ControlledFragmentHandler.Action onReleaseSessionReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.releaseSessionReply.wrap(buffer, offset, blockLength, version);
        int libraryId = this.releaseSessionReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onReleaseSessionReply(libraryId, this.releaseSessionReply.replyToId(), this.releaseSessionReply.status());
    }

    private ControlledFragmentHandler.Action onRequestSessionReply(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.requestSessionReply.wrap(buffer, offset, blockLength, version);
        int libraryId = this.requestSessionReply.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onRequestSessionReply(libraryId, this.requestSessionReply.replyToId(), this.requestSessionReply.status());
    }

    private ControlledFragmentHandler.Action onError(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.error.wrap(buffer, offset, blockLength, version);
        int libraryId = this.error.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (action == ControlledFragmentHandler.Action.ABORT) {
            return action;
        }
        return this.handler.onError(libraryId, this.error.errorType(), this.error.replyToId(), this.error.message());
    }

    private ControlledFragmentHandler.Action onNewSentPosition(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.newSentPosition.wrap(buffer, offset, blockLength, version);
        return this.handler.onNewSentPosition(this.newSentPosition.libraryId(), this.newSentPosition.position());
    }

    private ControlledFragmentHandler.Action onManageSession(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.manageSession.wrap(buffer, offset, blockLength, version);
        int libraryId = this.manageSession.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (ControlledFragmentHandler.Action.ABORT == action) {
            return action;
        }
        return this.handler.onManageSession(libraryId, this.manageSession.connection(), this.manageSession.session(), this.manageSession.lastSentSequenceNumber(), this.manageSession.lastReceivedSequenceNumber(), this.manageSession.logonTime(), this.manageSession.sessionStatus(), this.manageSession.slowStatus(), this.manageSession.connectionType(), this.manageSession.sessionState(), this.manageSession.heartbeatIntervalInS(), this.manageSession.closedResendInterval() == Bool.TRUE, this.manageSession.resendRequestChunkSize(), this.manageSession.sendRedundantResendRequests() == Bool.TRUE, this.manageSession.enableLastMsgSeqNumProcessed() == Bool.TRUE, this.manageSession.replyToId(), this.manageSession.sequenceIndex(), this.manageSession.awaitingResend() == AwaitingResend.YES, this.manageSession.lastResentMsgSeqNo(), this.manageSession.lastResendChunkMsgSeqNum(), this.manageSession.endOfResendRequestRange(), this.manageSession.awaitingHeartbeat() == Bool.TRUE, this.manageSession.localCompId(), this.manageSession.localSubId(), this.manageSession.localLocationId(), this.manageSession.remoteCompId(), this.manageSession.remoteSubId(), this.manageSession.remoteLocationId(), this.manageSession.address(), this.manageSession.username(), this.manageSession.password());
    }

    private ControlledFragmentHandler.Action onEndOfDay(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.endOfDay.wrap(buffer, offset, blockLength, version);
        int libraryId = this.endOfDay.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId);
        if (ControlledFragmentHandler.Action.ABORT == action) {
            return action;
        }
        return this.handler.onEngineClose(libraryId);
    }
}

