/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import java.util.List;
import org.agrona.collections.IntArrayList;
import uk.co.real_logic.artio.FixGatewayException;
import uk.co.real_logic.artio.library.LibraryPoller;
import uk.co.real_logic.artio.library.LibraryReply;
import uk.co.real_logic.artio.library.SessionConfiguration;
import uk.co.real_logic.artio.messages.GatewayError;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.session.Session;

class InitiateSessionReply
extends LibraryReply<Session> {
    private final SessionConfiguration configuration;
    private int addressIndex = 0;

    InitiateSessionReply(LibraryPoller libraryPoller, long latestReplyArrivalTime, SessionConfiguration configuration) {
        super(libraryPoller, latestReplyArrivalTime);
        this.configuration = configuration;
        if (libraryPoller.isConnected()) {
            this.sendMessage();
        }
    }

    @Override
    protected void sendMessage() {
        int port;
        List<String> hosts = this.configuration.hosts();
        IntArrayList ports = this.configuration.ports();
        int size = hosts.size();
        if (this.addressIndex >= size) {
            this.onError(new FixGatewayException("Unable to connect to any of the addresses specified"));
            return;
        }
        String host = hosts.get(this.addressIndex);
        long position = this.libraryPoller.saveInitiateConnection(host, port = ports.getInt(this.addressIndex), this.correlationId, this.configuration);
        this.requiresResend = position < 0L;
    }

    @Override
    void onError(GatewayError errorType, String errorMessage) {
        if (errorType == GatewayError.UNABLE_TO_CONNECT) {
            ++this.addressIndex;
            this.register();
            this.sendMessage();
        } else {
            this.onError(new FixGatewayException(String.format("%s: %s", errorType, errorMessage)));
        }
    }

    @Override
    void onComplete(Session result) {
        String host = this.configuration.hosts().get(this.addressIndex);
        int port = this.configuration.ports().getInt(this.addressIndex);
        ((InternalSession)result).address(host, port);
        super.onComplete(result);
    }

    @Override
    protected boolean onTimeout() {
        if (this.libraryPoller.saveMidConnectionDisconnect(this.correlationId) > 0L) {
            super.onTimeout();
        }
        return false;
    }

    SessionConfiguration configuration() {
        return this.configuration;
    }
}

